/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class TextField
extends GuiTextField {
    protected static final int INDEX_X = 1;
    protected static final int INDEX_Y = 2;
    protected static final int INDEX_WIDTH = 3;
    protected static final int INDEX_HEIGHT = 4;
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;

    public TextField(Object text, FontRenderer fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextField(Object text, FontRenderer fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height);
        this.func_73782_a(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void func_73792_b(String par1Str) {
        super.func_73792_b(par1Str);
        if (this.numeric) {
            String fixed = this.func_73781_b().replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                String start = fixed.startsWith("-") ? "-" : "";
                fixed = start + fixed.replaceAll("-", "");
            }
            super.func_73782_a(fixed);
        }
    }

    public void setText(Object object) {
        super.func_73782_a(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.func_73781_b();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean func_73802_a(char par1, int par2) {
        boolean res = super.func_73802_a(par1, par2);
        if (this.numeric && this.func_73806_l()) {
            this.clamp();
        }
        return res;
    }

    public void func_73795_f() {
        super.func_73795_f();
        if (this.func_73778_q() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.func_73801_o() + 1;
            int y2 = y1 + this.getHeight() + 1;
            TextField.func_73734_a((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextField.func_73734_a((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextField.func_73734_a((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextField.func_73734_a((int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        if (!this.numeric) {
            return null;
        }
        String text = this.func_73781_b();
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                this.setText(Math.max(this.clampMin, Integer.parseInt(text)));
            }
            catch (Exception e) {
                this.setText(this.clampMin);
            }
            if (this.clampMax != null) {
                try {
                    this.setText(Math.min(this.clampMax, Integer.parseInt(text)));
                }
                catch (Exception e) {
                    this.setText(this.clampMax);
                }
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getX() {
        return (Integer)ReflectionHelper.getPrivateValue(GuiTextField.class, (Object)((Object)this), (int)1);
    }

    public void setX(int x) {
        ReflectionHelper.setPrivateValue(GuiTextField.class, (Object)((Object)this), (Object)x, (int)1);
    }

    public int getY() {
        return (Integer)ReflectionHelper.getPrivateValue(GuiTextField.class, (Object)((Object)this), (int)2);
    }

    public void setY(int y) {
        ReflectionHelper.setPrivateValue(GuiTextField.class, (Object)((Object)this), (Object)y, (int)2);
    }

    public int func_73801_o() {
        return (Integer)ReflectionHelper.getPrivateValue(GuiTextField.class, (Object)((Object)this), (int)3);
    }

    public void setWidth(int w) {
        ReflectionHelper.setPrivateValue(GuiTextField.class, (Object)((Object)this), (Object)w, (int)3);
    }

    public int getHeight() {
        return (Integer)ReflectionHelper.getPrivateValue(GuiTextField.class, (Object)((Object)this), (int)4);
    }

    public int getCenterX() {
        return this.getX() + this.func_73801_o() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.getHeight() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.getHeight();
    }

    public int getRightX() {
        return this.getX() + this.func_73801_o();
    }
}

