/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MasterOptions;
import net.techbrew.journeymap.ui.map.GeneralDisplayOptions;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.map.MapOverlayActions;
import net.techbrew.journeymap.ui.map.MapOverlayHotkeysHelp;
import net.techbrew.journeymap.ui.minimap.MiniMap;
import net.techbrew.journeymap.ui.minimap.MiniMapHotkeysHelp;
import net.techbrew.journeymap.ui.minimap.MiniMapOptions;
import net.techbrew.journeymap.ui.waypoint.WaypointEditor;
import net.techbrew.journeymap.ui.waypoint.WaypointHelp;
import net.techbrew.journeymap.ui.waypoint.WaypointManager;
import net.techbrew.journeymap.ui.waypoint.WaypointOptions;

public class UIManager {
    private MiniMap miniMap;
    private final Logger logger = JourneyMap.getLogger();
    Minecraft minecraft = Minecraft.func_71410_x();

    public static UIManager getInstance() {
        return Holder.INSTANCE;
    }

    private UIManager() {
        this.miniMap = new MiniMap();
    }

    public void closeAll() {
        this.closeCurrent();
        this.minecraft.func_71373_a(null);
        this.minecraft.func_71381_h();
        TileCache.instance().cleanUp();
    }

    public void closeCurrent() {
        if (this.minecraft.field_71462_r != null && this.minecraft.field_71462_r instanceof JmUI) {
            this.logger.fine("Closing " + this.minecraft.field_71462_r.getClass());
            ((JmUI)this.minecraft.field_71462_r).close();
        }
        KeyBinding.func_74506_a();
    }

    public void openInventory() {
        this.logger.fine("Opening inventory");
        this.closeAll();
        this.minecraft.func_71373_a((GuiScreen)new GuiInventory((EntityPlayer)this.minecraft.field_71439_g));
    }

    public <T extends JmUI> T open(Class<T> uiClass, Class<? extends JmUI> returnClass) {
        try {
            JmUI ui = (JmUI)((Object)uiClass.getConstructor(Class.class).newInstance(returnClass));
            return (T)((Object)this.open(ui));
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception creating UI with return class: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends JmUI> T open(Class<T> uiClass) {
        try {
            JmUI ui = (JmUI)((Object)uiClass.newInstance());
            return (T)((Object)this.open(ui));
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception creating UI: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends JmUI> T open(T ui) {
        this.closeCurrent();
        this.logger.fine("Opening UI " + ((Object)ui).getClass().getSimpleName());
        try {
            this.minecraft.func_71373_a(ui);
        }
        catch (Throwable t) {
            this.logger.severe(String.format("Unexpected exception opening UI %s: %s", ((Object)ui).getClass(), LogFormatter.toString(t)));
        }
        return ui;
    }

    public void toggleMinimap() {
        this.setMiniMapEnabled(!this.isMiniMapEnabled());
    }

    public void setMiniMapEnabled(boolean enable) {
        JourneyMap.getInstance().miniMapProperties.enabled.set(enable);
        JourneyMap.getInstance().miniMapProperties.save();
    }

    public boolean isMiniMapEnabled() {
        return JourneyMap.getInstance().miniMapProperties.enabled.get();
    }

    public void drawMiniMap() {
        try {
            if (JourneyMap.getInstance().miniMapProperties.enabled.get()) {
                boolean doDraw;
                GuiScreen currentScreen = this.minecraft.field_71462_r;
                boolean bl = doDraw = currentScreen == null || currentScreen instanceof GuiChat || currentScreen instanceof MiniMapOptions;
                if (doDraw) {
                    this.miniMap.drawMap();
                }
            }
        }
        catch (Throwable e) {
            JourneyMap.getLogger().severe("Error drawing minimap: " + LogFormatter.toString(e));
        }
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public void openMap() {
        KeyBinding.func_74506_a();
        this.open((JmUI)((Object)MapOverlay.class));
    }

    public void openMap(Waypoint waypoint) {
        try {
            if (waypoint.isInPlayerDimension()) {
                KeyBinding.func_74506_a();
                MapOverlay map = (MapOverlay)((Object)this.open((JmUI)((Object)MapOverlay.class)));
                map.centerOn(waypoint);
            }
        }
        catch (Throwable e) {
            JourneyMap.getLogger().severe("Error opening map on waypoint: " + LogFormatter.toString(e));
        }
    }

    public void openMapHotkeyHelp(Class<? extends JmUI> returnClass) {
        this.open(MapOverlayHotkeysHelp.class, returnClass);
    }

    public void openMiniMapOptions(Class<? extends JmUI> returnClass) {
        this.open(MiniMapOptions.class, returnClass);
    }

    public void openMiniMapHotkeyHelp(Class<? extends JmUI> returnClass) {
        this.open(MiniMapHotkeysHelp.class, returnClass);
    }

    public void openWaypointOptions(Class<? extends JmUI> returnClass) {
        this.open(WaypointOptions.class, returnClass);
    }

    public void openGeneralDisplayOptions(Class<? extends JmUI> returnClass) {
        this.open(GeneralDisplayOptions.class, returnClass);
    }

    public void openMasterOptions() {
        this.open((JmUI)((Object)MasterOptions.class));
    }

    public void openMapActions() {
        this.open((JmUI)((Object)MapOverlayActions.class));
    }

    public void openWaypointHelp(Class<? extends JmUI> returnClass) {
        this.open(WaypointHelp.class, returnClass);
    }

    public void openWaypointManager(Waypoint waypoint, Class<? extends JmUI> returnClass) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointManager manager = new WaypointManager(waypoint, returnClass);
                this.open(manager);
            }
            catch (Throwable e) {
                JourneyMap.getLogger().severe("Error opening waypoint manager: " + LogFormatter.toString(e));
            }
        }
    }

    public void openWaypointEditor(Waypoint waypoint, boolean isNew, Class<? extends JmUI> returnClass) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointEditor editor = new WaypointEditor(waypoint, isNew, returnClass);
                this.open(editor);
            }
            catch (Throwable e) {
                JourneyMap.getLogger().severe("Error opening waypoint editor: " + LogFormatter.toString(e));
            }
        }
    }

    public void reset() {
        MapOverlay.reset();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
        if (this.miniMap != null) {
            this.miniMap.reset();
        }
        this.miniMap = new MiniMap();
    }

    private static class Holder {
        private static final UIManager INSTANCE = new UIManager();

        private Holder() {
        }
    }
}

