/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.minimap.DisplayVars;
import org.lwjgl.opengl.GL11;

public class MiniMap {
    private static final float lightmapS = 240.0f;
    private static final float lightmapT = 240.0f;
    private static final long labelRefreshRate = 1001L;
    private final Logger logger = JourneyMap.getLogger();
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Color playerInfoFgColor = Color.LIGHT_GRAY;
    private final Color playerInfoBgColor = new Color(34, 34, 34);
    private final String[] locationFormats = new String[]{"MapOverlay.location_xzye", "MapOverlay.location_xzy", "MapOverlay.location_xz"};
    private final MiniMapProperties miniMapProperties;
    private final FullMapProperties fullMapProperties;
    private final WaypointProperties waypointProperties;
    private final MapOverlayState state;
    private final OverlayWaypointRenderer waypointRenderer;
    private final OverlayRadarRenderer radarRenderer;
    private final GridRenderer gridRenderer;
    private final TextureImpl playerLocatorTex;
    private EntityClientPlayerMP player;
    private StatTimer drawTimer;
    private StatTimer refreshStateTimer;
    private DisplayVars dv;
    private long lastLabelRefresh;
    private String fpsLabelText;
    private String locationLabelText;
    private String biomeLabelText;
    private ArrayList<DrawWayPointStep> allWaypointSteps;
    private ArrayList<DrawWayPointStep> offscreenWpDrawSteps;

    public MiniMap() {
        this.miniMapProperties = JourneyMap.getInstance().miniMapProperties;
        this.fullMapProperties = JourneyMap.getInstance().fullMapProperties;
        this.waypointProperties = JourneyMap.getInstance().waypointProperties;
        this.state = MapOverlay.state();
        this.waypointRenderer = new OverlayWaypointRenderer();
        this.radarRenderer = new OverlayRadarRenderer();
        this.gridRenderer = new GridRenderer(3);
        this.lastLabelRefresh = 0L;
        this.allWaypointSteps = new ArrayList();
        this.offscreenWpDrawSteps = new ArrayList();
        this.player = this.mc.field_71439_g;
        this.playerLocatorTex = TextureCache.instance().getPlayerLocatorSmall();
        this.updateDisplayVars(DisplayVars.Shape.getPreferred(), DisplayVars.Position.getPreferred(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap() {
        this.player = this.mc.field_71439_g;
        if (this.player == null) {
            return;
        }
        boolean doStateRefresh = this.state.shouldRefresh(this.mc);
        try {
            Point2D.Double playerPixel;
            if (doStateRefresh) {
                this.refreshStateTimer.start();
                this.state.refresh(this.mc, this.player, this.miniMapProperties);
            } else {
                this.drawTimer.start();
            }
            this.gridRenderer.setContext(this.state.getWorldDir(), this.state.getDimension());
            boolean moved = this.gridRenderer.center(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v, this.state.currentZoom);
            if (moved || doStateRefresh) {
                boolean showCaves = this.player.field_70170_p.field_73011_w.field_76576_e || this.fullMapProperties.showCaves.get();
                this.gridRenderer.updateTextures(this.state.getMapType(showCaves), this.state.getVSlice(), this.mc.field_71443_c, this.mc.field_71440_d, doStateRefresh, 0.0, 0.0, this.miniMapProperties);
            }
            if (doStateRefresh) {
                boolean checkWaypointDistance = this.waypointProperties.maxDistance.get() > 0;
                this.state.generateDrawSteps(this.mc, this.gridRenderer, this.waypointRenderer, this.radarRenderer, this.miniMapProperties, this.dv.drawScale, checkWaypointDistance);
                this.state.updateLastRefresh();
                this.allWaypointSteps.clear();
                this.allWaypointSteps.addAll(this.state.getDrawWaypointSteps());
            }
            this.updateDisplayVars(false);
            if (System.currentTimeMillis() - this.lastLabelRefresh > 1001L) {
                this.updateLabels();
            }
            JmUI.sizeDisplay(this.mc.field_71443_c, this.mc.field_71440_d);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            if (this.dv.maskTexture != null) {
                try {
                    GL11.glClear((int)256);
                    GL11.glEnable((int)2960);
                    GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GL11.glDepthMask((boolean)false);
                    GL11.glStencilFunc((int)512, (int)1, (int)255);
                    GL11.glStencilOp((int)7681, (int)7680, (int)7680);
                    GL11.glStencilMask((int)255);
                    GL11.glClear((int)1024);
                    DrawUtil.drawQuad(this.dv.maskTexture, this.dv.textureX, this.dv.textureY, this.dv.maskTexture.width, this.dv.maskTexture.height, null, 1.0f, false, true, 770, 771);
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GL11.glDepthMask((boolean)true);
                    GL11.glStencilMask((int)0);
                    GL11.glStencilFunc((int)514, (int)1, (int)255);
                }
                catch (Throwable t) {
                    this.logger.severe("Stencil buffer failing with circle mask:" + LogFormatter.toString(t));
                    if (doStateRefresh) {
                        this.refreshStateTimer.stop();
                    } else {
                        this.drawTimer.stop();
                    }
                    return;
                }
            }
            GL11.glTranslated((double)this.dv.translateX, (double)this.dv.translateY, (double)0.0);
            GL11.glScissor((int)((int)this.dv.scissorX + 1), (int)((int)this.dv.scissorY + 1), (int)((int)this.dv.minimapSize - 2), (int)((int)this.dv.minimapSize - 2));
            GL11.glEnable((int)3089);
            this.gridRenderer.draw(1.0f, 0.0, 0.0);
            double fontScale = this.getMapFontScale();
            boolean unicodeForced = DrawUtil.startUnicode(this.mc.field_71466_p, this.miniMapProperties.forceUnicode.get());
            this.gridRenderer.draw(this.state.getDrawSteps(), 0.0, 0.0, this.dv.drawScale, fontScale);
            if (!this.allWaypointSteps.isEmpty()) {
                this.gridRenderer.draw(this.allWaypointSteps, 0.0, 0.0, this.dv.drawScale, fontScale);
            }
            if (unicodeForced) {
                DrawUtil.stopUnicode(this.mc.field_71466_p);
            }
            if (this.miniMapProperties.showSelf.get() && (playerPixel = this.gridRenderer.getPixel(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70161_v)) != null) {
                DrawUtil.drawEntity(((Point2D)playerPixel).getX(), ((Point2D)playerPixel).getY(), EntityHelper.getHeading((Entity)this.mc.field_71439_g), false, this.playerLocatorTex, 8, this.dv.drawScale);
            }
            GL11.glTranslated((double)(-this.dv.translateX), (double)(-this.dv.translateY), (double)0.0);
            if (this.dv.labelFps.scissor && this.dv.showFps) {
                this.dv.labelFps.draw(this.fpsLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            if (this.dv.labelLocation.scissor) {
                this.dv.labelLocation.draw(this.locationLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            if (this.dv.labelBiome.scissor) {
                this.dv.labelBiome.draw(this.biomeLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            if (this.dv.maskTexture != null) {
                GL11.glDisable((int)2960);
            }
            GL11.glDisable((int)3089);
            if (!this.dv.labelFps.scissor && this.dv.showFps) {
                this.dv.labelFps.draw(this.fpsLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            if (!this.dv.labelLocation.scissor) {
                this.dv.labelLocation.draw(this.locationLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            if (!this.dv.labelBiome.scissor) {
                this.dv.labelBiome.draw(this.biomeLabelText, this.playerInfoBgColor, 200, this.playerInfoFgColor, 255);
            }
            GL11.glEnable((int)2929);
            DrawUtil.drawImage(this.dv.borderTexture, this.dv.textureX, this.dv.textureY, false, 1.0f);
            if (!this.allWaypointSteps.isEmpty()) {
                GL11.glTranslated((double)this.dv.translateX, (double)this.dv.translateY, (double)0.0);
                for (DrawWayPointStep drawWayPointStep : this.allWaypointSteps) {
                    if (drawWayPointStep.isOnScreen(0.0, 0.0, this.gridRenderer)) continue;
                    drawWayPointStep.draw(0.0, 0.0, this.gridRenderer, this.dv.drawScale, fontScale);
                }
            }
            GL11.glPopMatrix();
            JmUI.sizeDisplay(this.dv.scaledResolution.func_78327_c(), this.dv.scaledResolution.func_78324_d());
        }
        catch (Throwable t) {
            this.logger.severe("Minimap error:" + LogFormatter.toString(t));
        }
        finally {
            if (doStateRefresh) {
                this.refreshStateTimer.stop();
            } else {
                this.drawTimer.stop();
            }
        }
    }

    public void reset() {
        this.state.requireRefresh();
        this.gridRenderer.clear();
    }

    public double getMapFontScale() {
        return (this.miniMapProperties.fontSmall.get() ? 1 : 2) * (this.miniMapProperties.forceUnicode.get() ? 2 : 1);
    }

    public void nextPosition() {
        int nextIndex = this.dv.position.ordinal() + 1;
        if (nextIndex == DisplayVars.Position.values().length) {
            nextIndex = 0;
        }
        this.setPosition(DisplayVars.Position.values()[nextIndex]);
    }

    public DisplayVars.Position getPosition() {
        return this.dv.position;
    }

    public void setPosition(DisplayVars.Position position) {
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.save();
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, position, false);
        }
    }

    public DisplayVars.Shape getShape() {
        return this.dv.shape;
    }

    public void setShape(DisplayVars.Shape shape) {
        if (this.dv != null) {
            this.updateDisplayVars(shape, this.dv.position, false);
        }
    }

    public void updateDisplayVars(boolean force) {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, this.dv.position, force);
        }
    }

    public void updateDisplayVars(DisplayVars.Shape shape, DisplayVars.Position position, boolean force) {
        if (this.dv != null && !force && this.mc.field_71440_d == this.dv.displayHeight && this.mc.field_71443_c == this.dv.displayWidth && this.dv.shape == shape && this.dv.position == position && this.dv.forceUnicode == this.miniMapProperties.forceUnicode.get() && this.dv.fontScale == (double)(this.miniMapProperties.fontSmall.get() ? 1 : 2)) {
            return;
        }
        this.miniMapProperties.shape.set(shape);
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.save();
        DisplayVars oldDv = this.dv;
        this.dv = new DisplayVars(this.mc, shape, position, this.miniMapProperties.fontSmall.get() ? 1.0 : 2.0);
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            this.drawTimer = StatTimer.get("MiniMap.drawMap." + shape.name(), 500);
            this.drawTimer.reset();
            this.refreshStateTimer = StatTimer.get("MiniMap.drawMap." + shape.name() + "+refreshState", 5);
            this.refreshStateTimer.reset();
        }
        this.updateLabels();
        double xpad = this.dv.viewPortPadX;
        double ypad = this.dv.viewPortPadY;
        Rectangle2D.Double viewPort = new Rectangle2D.Double(this.dv.textureX + xpad, this.dv.textureY + ypad, this.dv.minimapSize - 2.0 * xpad, this.dv.minimapSize - 2.0 * ypad);
        this.gridRenderer.setViewPort(viewPort);
    }

    private void updateLabels() {
        if (this.dv.showFps) {
            String fps = this.mc.field_71426_K;
            int idx = fps != null ? fps.indexOf(44) : -1;
            this.fpsLabelText = idx > 0 ? fps.substring(0, idx) : "";
        }
        String playerInfo = "";
        int playerX = (int)this.player.field_70165_t;
        int playerZ = (int)this.player.field_70161_v;
        int playerY = (int)this.player.field_70163_u;
        for (String format : this.locationFormats) {
            playerInfo = Constants.getString(format, playerX, playerZ, playerY, this.mc.field_71439_g.field_70162_ai);
            double infoWidth = (double)this.mc.field_71466_p.func_78256_a(playerInfo) * this.dv.fontScale;
            if (infoWidth <= this.dv.minimapSize - this.dv.viewPortPadX * 2.0) break;
        }
        this.locationLabelText = playerInfo;
        this.biomeLabelText = this.state.getPlayerBiome();
        this.lastLabelRefresh = System.currentTimeMillis();
    }
}

