/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.minimap;

import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.forgehandler.KeyEventHandler;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MasterOptions;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.minimap.DisplayVars;
import net.techbrew.journeymap.ui.minimap.MiniMap;

public class MiniMapHotkeysHelp
extends JmUI {
    private int lastWidth = 0;
    private int lastHeight = 0;
    private Button buttonClose;
    private DisplayVars.Shape currentShape;
    private DisplayVars.Position currentPosition;
    private KeyEventHandler keyEventHandler = new KeyEventHandler();

    public MiniMapHotkeysHelp() {
        this(MasterOptions.class);
    }

    public MiniMapHotkeysHelp(Class<? extends JmUI> returnClass) {
        super(Constants.getString("MiniMap.hotkeys_title"), returnClass);
    }

    @Override
    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.buttonClose = new Button(ButtonEnum.Close, Constants.getString("MapOverlay.close"));
        this.field_73887_h.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_73887_h.isEmpty()) {
            this.func_73866_w_();
        }
        if (this.lastWidth != this.field_73880_f || this.lastHeight != this.field_73881_g) {
            this.lastWidth = this.field_73880_f;
            this.lastHeight = this.field_73881_g;
            int by = this.field_73881_g / 4 + 60;
            this.buttonClose.centerHorizontalOn(this.field_73880_f / 2).setY(by);
        }
    }

    protected void func_73875_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_73741_f];
        switch (id) {
            case Close: {
                this.closeAndReturn();
            }
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int y = this.field_73881_g / 4 - 18;
        y += 12;
        int x = this.field_73880_f / 2;
        this.drawHelpStrings(Constants.getString("MiniMap.hotkeys_toggle"), Constants.getKeyName(Constants.KB_MAP), x, y += 12);
        this.drawHelpStrings(Constants.getString("key.journeymap.zoom_in"), Constants.getKeyName(Constants.KB_MAP_ZOOMIN), x, y += 12);
        this.drawHelpStrings(Constants.getString("key.journeymap.zoom_out"), Constants.getKeyName(Constants.KB_MAP_ZOOMOUT), x, y += 12);
        this.drawHelpStrings(Constants.getString("key.journeymap.day"), Constants.getKeyName(Constants.KB_MAP_DAY), x, y += 12);
        this.drawHelpStrings(Constants.getString("key.journeymap.night"), Constants.getKeyName(Constants.KB_MAP_NIGHT), x, y += 12);
        this.drawHelpStrings(Constants.getString("key.journeymap.minimap_position"), Constants.getKeyName(Constants.KB_MINIMAP_POS), x, y += 12);
        this.buttonClose.setY(y + 16);
    }

    protected void drawHelpStrings(String title, String key, int x, int y) {
        int hgap = 8;
        int tWidth = this.getFontRenderer().func_78256_a(title);
        this.func_73731_b(this.getFontRenderer(), title, x - tWidth - hgap, y, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), Constants.CONTROL_KEYNAME_COMBO + key, x + hgap, y, Color.YELLOW.getRGB());
    }

    @Override
    public void func_73871_c(int layer) {
        super.func_73871_c(layer);
        if (JourneyMap.getInstance().miniMapProperties.enabled.get()) {
            MiniMap miniMap = UIManager.getInstance().getMiniMap();
            miniMap.drawMap();
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        KeyEventHandler.onKeypress(true);
    }

    private static enum ButtonEnum {
        Close;

    }
}

