/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.data.WaypointsData;
import net.techbrew.journeymap.forgehandler.KeyEventHandler;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MasterOptions;
import net.techbrew.journeymap.waypoint.ReiReader;
import net.techbrew.journeymap.waypoint.VoxelReader;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class WaypointHelp
extends JmUI {
    private int lastWidth = 0;
    private int lastHeight = 0;
    private Button buttonRei;
    private Button buttonVoxel;
    private Button buttonClose;
    private KeyEventHandler keyEventHandler = new KeyEventHandler();
    String importReiText;
    String importVoxelText;
    int importReiTextWidth;
    int importVoxelTextWidth;

    public WaypointHelp() {
        this(MasterOptions.class);
    }

    public WaypointHelp(Class<? extends JmUI> returnClass) {
        super(Constants.getString("MapOverlay.waypoint_help_title"), returnClass);
    }

    @Override
    public void func_73866_w_() {
        this.field_73887_h.clear();
        String jmWaypointDir = FileHandler.getWaypointDir().toString();
        FontRenderer fr = this.getFontRenderer();
        String reiFileName = ReiReader.getPointsFilename();
        this.importReiText = Constants.getString("MapOverlay.waypoint_help_import_rei", reiFileName, jmWaypointDir);
        this.importReiTextWidth = fr.func_78256_a(this.importReiText);
        this.buttonRei = new Button(ButtonEnum.ImportRei, Constants.getString("MapOverlay.waypoint_help_import_rei_title"));
        this.buttonRei.setEnabled(WaypointsData.isReiMinimapEnabled());
        this.field_73887_h.add(this.buttonRei);
        String voxFileName = VoxelReader.getPointsFilename();
        this.importVoxelText = Constants.getString("MapOverlay.waypoint_help_import_voxel", voxFileName, jmWaypointDir);
        this.importVoxelTextWidth = fr.func_78256_a(this.importVoxelText);
        this.buttonVoxel = new Button(ButtonEnum.ImportVoxel, Constants.getString("MapOverlay.waypoint_help_import_voxel_title"));
        this.buttonVoxel.setEnabled(WaypointsData.isVoxelMapEnabled());
        this.field_73887_h.add(this.buttonVoxel);
        this.buttonClose = new Button(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.field_73887_h.add(this.buttonClose);
        new ButtonList(this.buttonRei, this.buttonVoxel).equalizeWidths(this.getFontRenderer());
    }

    @Override
    protected void layoutButtons() {
        if (this.field_73887_h.isEmpty()) {
            this.func_73866_w_();
        }
    }

    protected void func_73875_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_73741_f];
        switch (id) {
            case ImportRei: {
                WaypointStore.instance().load(ReiReader.loadWaypoints(), true);
                this.closeAndReturn();
                break;
            }
            case ImportVoxel: {
                WaypointStore.instance().load(VoxelReader.loadWaypoints(), true);
                this.closeAndReturn();
                break;
            }
            case Close: {
                this.closeAndReturn();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int y = Math.max(30, this.field_73881_g / 8);
        int x = this.field_73880_f / 2 + this.getFontRenderer().func_78256_a(Constants.getString("MapOverlay.waypoint_help_create_ingame")) / 3;
        String waypointKey = Constants.getKeyName(Constants.KB_WAYPOINT);
        this.drawHelpStrings(Constants.getString("MapOverlay.waypoint_help_create_ingame"), waypointKey, x, y += 12);
        this.drawHelpStrings(Constants.getString("MapOverlay.waypoint_help_create_inmap"), waypointKey, x, y += 12);
        this.drawHelpStrings(Constants.getString("MapOverlay.waypoint_help_manage_ingame"), Constants.CONTROL_KEYNAME_COMBO + waypointKey, x, y += 12);
        FontRenderer fr = this.getFontRenderer();
        int indentX = this.field_73880_f / 20;
        int indentWidth = this.field_73880_f - indentX;
        int importReiTextWidth = fr.func_78256_a(this.importReiText);
        int importVoxelTextWidth = fr.func_78256_a(this.importVoxelText);
        if (importVoxelTextWidth < indentWidth && importReiTextWidth < indentWidth) {
            indentWidth = Math.max(importReiTextWidth, importVoxelTextWidth);
            indentX = (this.field_73880_f - indentWidth) / 2;
        }
        int reiHeight = fr.func_78271_c(this.importReiText, indentWidth).size() * this.field_73886_k.field_78288_b;
        this.buttonRei.centerHorizontalOn(this.field_73880_f / 2).setY(y += 24);
        fr.func_78279_b(this.importReiText, indentX, y += this.buttonRei.getHeight() + 5, indentWidth, Color.white.getRGB());
        int voxelHeight = fr.func_78271_c(this.importVoxelText, indentWidth).size() * this.field_73886_k.field_78288_b;
        this.buttonVoxel.centerHorizontalOn(this.field_73880_f / 2).setY(y += reiHeight + 16);
        if (!this.buttonVoxel.isDrawButton()) {
            fr.func_78261_a("\u00c2\u00a7n" + this.buttonVoxel.field_73744_e, indentX, y, Color.lightGray.getRGB());
        }
        fr.func_78279_b(this.importVoxelText, indentX, y += this.buttonVoxel.getHeight() + 5, indentWidth, Color.white.getRGB());
        this.buttonClose.centerHorizontalOn(this.field_73880_f / 2);
        this.buttonClose.setY(Math.min(y += voxelHeight + 16, this.field_73881_g - this.buttonClose.getHeight()));
    }

    protected void drawHelpStrings(String title, String key, int x, int y) {
        int hgap = 8;
        int tWidth = this.getFontRenderer().func_78256_a(title);
        this.func_73731_b(this.getFontRenderer(), title, x - tWidth - hgap, y, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), key, x + hgap, y, Color.YELLOW.getRGB());
    }

    private static enum ButtonEnum {
        ImportRei,
        ImportVoxel,
        Close;

    }
}

