/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldProvider;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.command.CmdTeleportWaypoint;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.ScrollPane;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.waypoint.WaypointManagerItem;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class WaypointManager
extends JmUI {
    static final String ASCEND = Constants.getString("JourneyMap.char_uparrow");
    static final String DESCEND = Constants.getString("JourneyMap.char_downarrow");
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    final String on = Constants.getString("MapOverlay.on");
    final String off = Constants.getString("MapOverlay.off");
    protected int rowHeight = 16;
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private DimensionsButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonHelp;
    private Button buttonOptions;
    private Button buttonToggleAll;
    private ButtonList bottomButtons;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private ScrollPane itemScrollPane;
    private Waypoint focusWaypoint;

    public WaypointManager() {
        this((Waypoint)null, (Class<? extends JmUI>)null);
    }

    public WaypointManager(Waypoint focusWaypoint, Class<? extends JmUI> returnClass) {
        super(Constants.getString("Waypoint.manage_title"), returnClass);
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void func_73866_w_() {
        try {
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(this.field_73882_e);
            if (this.field_73887_h.isEmpty()) {
                FontRenderer fr = this.getFontRenderer();
                if (this.buttonSortDistance == null) {
                    WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, true);
                    String distanceLabel = Constants.getString("Waypoint.distance");
                    this.buttonSortDistance = new SortButton(ButtonEnum.SortDistance, distanceLabel, distanceSort);
                    this.buttonSortDistance.setTextOnly(fr);
                }
                this.field_73887_h.add(this.buttonSortDistance);
                if (this.buttonSortName == null) {
                    WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
                    this.buttonSortName = new SortButton(ButtonEnum.SortName, Constants.getString("Waypoint.name"), nameSort);
                    this.buttonSortName.setTextOnly(fr);
                }
                this.field_73887_h.add(this.buttonSortName);
                if (this.buttonToggleAll == null) {
                    String enableOn = Constants.getString("Waypoint.enable_all", "", this.on);
                    String enableOff = Constants.getString("Waypoint.enable_all", "", this.off);
                    this.buttonToggleAll = new Button(ButtonEnum.ToggleAll.ordinal(), 0, 0, enableOff, enableOn, true);
                    this.buttonToggleAll.setTextOnly(this.getFontRenderer());
                }
                this.field_73887_h.add(this.buttonToggleAll);
                if (this.buttonDimensions == null) {
                    this.buttonDimensions = new DimensionsButton(ButtonEnum.Dimensions.ordinal());
                }
                if (this.buttonAdd == null) {
                    this.buttonAdd = new Button(ButtonEnum.Add, Constants.getString("Waypoint.new"));
                    this.buttonAdd.fitWidth(this.getFontRenderer());
                    this.buttonAdd.setWidth(this.buttonAdd.getWidth() * 2);
                }
                if (this.buttonHelp == null) {
                    this.buttonHelp = new Button(ButtonEnum.Help, Constants.getString("MapOverlay.help"));
                    this.buttonHelp.fitWidth(this.getFontRenderer());
                }
                if (this.buttonOptions == null) {
                    this.buttonOptions = new Button(ButtonEnum.Options, Constants.getString("MapOverlay.options_button"));
                    this.buttonOptions.fitWidth(this.getFontRenderer());
                }
                this.buttonClose = new Button(ButtonEnum.Close, Constants.getString("MapOverlay.close"));
                this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonHelp, this.buttonAdd, this.buttonDimensions, this.buttonClose);
                this.field_73887_h.addAll(this.bottomButtons);
            }
            if (this.items.isEmpty()) {
                this.updateItems();
                if (currentSort == null) {
                    this.updateSort(this.buttonSortDistance);
                } else {
                    if (this.buttonSortDistance.sort.equals(currentSort)) {
                        this.buttonSortDistance.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDistance.setActive(true);
                        this.buttonSortName.setActive(false);
                    }
                    if (this.buttonSortName.sort.equals(currentSort)) {
                        this.buttonSortName.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortName.setActive(true);
                        this.buttonSortDistance.setActive(false);
                    }
                }
            }
            if (this.itemScrollPane == null) {
                this.itemScrollPane = new ScrollPane(this.field_73882_e, 0, 0, this.items, this.rowHeight, 2);
                this.itemScrollPane.setShowFrame(false);
                this.itemScrollPane.func_77216_a(false);
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe(LogFormatter.toString(t));
            UIManager.getInstance().closeAll();
        }
    }

    @Override
    protected void layoutButtons() {
        int pad = 3;
        int headerY = 25 + pad;
        if (this.items.size() > 0) {
            if (this.items.get((int)0).y > headerY + 16) {
                headerY = this.items.get((int)0).y - 16;
            }
            this.buttonToggleAll.setY(headerY);
            this.buttonToggleAll.centerHorizontalOn(this.items.get(0).getButtonEnableCenterX());
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        int margin = this.getMargin();
        int headerX = this.itemScrollPane.getX() + margin;
        this.buttonSortDistance.setPosition(headerX + this.colWaypoint, headerY);
        this.colName = this.buttonSortDistance.getX() + this.buttonSortDistance.getWidth() + 5 - headerX;
        this.buttonSortName.setPosition(headerX + this.colName, headerY);
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        int hgap = 4;
        int vgap = 5;
        int bottomButtonsHeight = this.buttonClose.getHeight() + vgap * 2;
        int startY = 25 + vgap + this.getFontRenderer().field_78288_b;
        int scrollWidth = this.field_73880_f - 6;
        this.itemScrollPane.position(scrollWidth, this.field_73881_g, startY, bottomButtonsHeight, 0, 0);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(hgap) + 25, scrollWidth);
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), hgap, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.field_73880_f / 2, this.field_73881_g - bottomButtonsHeight + vgap, true, hgap);
    }

    @Override
    public void func_73863_a(int x, int y, float par3) {
        this.func_73871_c(0);
        this.layoutButtons();
        this.itemScrollPane.func_77211_a(x, y, par3);
        if (this.focusWaypoint != null && !this.items.isEmpty() && this.itemScrollPane != null) {
            int index = -1;
            for (WaypointManagerItem item : this.items) {
                if (!item.waypoint.equals(this.focusWaypoint)) continue;
                this.itemScrollPane.select(item);
                index = this.items.indexOf(item);
                break;
            }
            int offset = Math.max(1, this.itemScrollPane.getLastVisibleIndex() - 2);
            if (index > -1 && index > offset) {
                int delta = index - offset;
                this.itemScrollPane.func_77208_b(delta * this.itemScrollPane.getSlotHeight());
            }
            this.focusWaypoint = null;
        }
        for (int k = 0; k < this.field_73887_h.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_73887_h.get(k);
            guibutton.func_73737_a(this.field_73882_e, x, y);
        }
        this.buttonToggleAll.drawUnderline();
        this.drawTitle();
        this.drawLogo();
    }

    protected int getMargin() {
        return this.field_73880_f > this.itemWidth + 2 ? (this.field_73880_f - this.itemWidth) / 2 : 0;
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        switch (par2) {
            case 1: {
                this.refreshAndClose();
                return;
            }
        }
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.isSelected(item);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.buttonToggleAll.mouseOver(mouseX, mouseY)) {
            return;
        }
        this.itemScrollPane.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_73875_a(GuiButton guibutton) {
        switch (ButtonEnum.values()[guibutton.field_73741_f]) {
            case Close: {
                this.refreshAndClose();
                return;
            }
            case SortName: {
                this.updateSort(this.buttonSortName);
                return;
            }
            case SortDistance: {
                this.updateSort(this.buttonSortDistance);
                return;
            }
            case Dimensions: {
                this.buttonDimensions.toggle();
                this.updateItems();
                return;
            }
            case Add: {
                Waypoint waypoint = Waypoint.of((EntityPlayer)this.field_73882_e.field_71439_g);
                UIManager.getInstance().openWaypointEditor(waypoint, true, WaypointManager.class);
                return;
            }
            case Help: {
                UIManager.getInstance().openWaypointHelp(((Object)((Object)this)).getClass());
                return;
            }
            case ToggleAll: {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
                return;
            }
            case Options: {
                UIManager.getInstance().openWaypointOptions(((Object)((Object)this)).getClass());
                return;
            }
        }
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.instance().remove(item.waypoint);
        this.items.remove(item);
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnable()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnable() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    protected void updateItems() {
        this.items.clear();
        Integer currentDim = DimensionsButton.currentWorldProvider == null ? null : Integer.valueOf(DimensionsButton.currentWorldProvider.field_76574_g);
        FontRenderer fr = this.getFontRenderer();
        this.itemWidth = 0;
        Collection<Waypoint> waypoints = WaypointStore.instance().getAll();
        boolean allOn = true;
        for (Waypoint waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            item.getDistanceTo((EntityPlayer)this.field_73882_e.field_71439_g);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnable();
        }
        this.itemWidth = this.items.isEmpty() ? 460 : this.items.get((int)0).internalWidth;
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
    }

    protected void updateSort(SortButton sortButton) {
        for (Button button : this.field_73887_h) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (sortButton.sort.equals(currentSort)) {
                    sortButton.toggle();
                } else {
                    sortButton.setActive(true);
                }
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("Waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("Waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected void refreshAndClose() {
        this.bottomButtons.setEnabled(false);
        WaypointStore.instance().bulkSave();
        MapOverlay.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.returnClass == null) {
            UIManager.getInstance().closeAll();
        } else {
            UIManager.getInstance().open(this.returnClass);
        }
    }

    protected static class DimensionsButton
    extends Button {
        final List<WorldProvider> worldProviders = WorldData.getDimensionProviders(WaypointStore.instance().getLoadedDimensions());
        static boolean needInit = true;
        static WorldProvider currentWorldProvider;

        public DimensionsButton(int id) {
            super(id, 0, 0, "");
            if (needInit || currentWorldProvider != null) {
                currentWorldProvider = FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w;
                needInit = false;
            }
            this.updateLabel();
            this.fitWidth(FMLClientHandler.instance().getClient().field_71466_p);
        }

        protected void updateLabel() {
            String dimName = currentWorldProvider != null ? currentWorldProvider.func_80007_l() : Constants.getString("Waypoint.dimension_all");
            this.field_73744_e = Constants.getString("Waypoint.dimension", dimName);
        }

        @Override
        public int getFitWidth(FontRenderer fr) {
            int maxWidth = 0;
            for (WorldProvider worldProvider : this.worldProviders) {
                String name = Constants.getString("Waypoint.dimension", worldProvider.func_80007_l());
                maxWidth = Math.max(maxWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(name));
            }
            return maxWidth + 12;
        }

        @Override
        public void toggle() {
            int index;
            if (currentWorldProvider == null) {
                index = 0;
            } else {
                index = -1;
                for (WorldProvider worldProvider : this.worldProviders) {
                    if (worldProvider.field_76574_g != DimensionsButton.currentWorldProvider.field_76574_g) continue;
                    index = this.worldProviders.indexOf(worldProvider) + 1;
                    break;
                }
            }
            currentWorldProvider = index >= this.worldProviders.size() || index < 0 ? null : this.worldProviders.get(index);
            this.updateLabel();
        }
    }

    protected class SortButton
    extends Button {
        final WaypointManagerItem.Sort sort;
        final String labelInactive;

        public SortButton(Enum enumValue, String label, WaypointManagerItem.Sort sort) {
            super(enumValue.ordinal(), 0, 0, String.format("%s %s", label, ASCEND), String.format("%s %s", label, DESCEND), sort.ascending);
            this.labelInactive = label;
            this.sort = sort;
        }

        @Override
        public void toggle() {
            this.sort.ascending = !this.sort.ascending;
            this.setActive(true);
        }

        @Override
        public void func_73737_a(Minecraft minecraft, int mouseX, int mouseY) {
            super.func_73737_a(minecraft, mouseX, mouseY);
            super.drawUnderline();
        }

        public void setActive(boolean active) {
            if (active) {
                this.setToggled(this.sort.ascending);
            } else {
                this.field_73744_e = String.format("%s %s", this.labelInactive, " ");
            }
        }
    }

    private static enum ButtonEnum {
        Add,
        Find,
        SortName,
        SortDistance,
        Dimensions,
        ToggleAll,
        Help,
        Options,
        Close;

    }
}

