/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import java.awt.Color;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.BooleanPropertyButton;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.TextField;

public class WaypointOptions
extends JmUI {
    Button buttonEnable;
    Button buttonHide;
    Button buttonClose;
    TextField maxDistanceField;
    ButtonList listLeftButtons;
    ButtonList listRightButtons;
    String labelMaxDistance = Constants.getString("Waypoint.max_distance");
    WaypointProperties props;

    public WaypointOptions(Class<? extends JmUI> returnClass) {
        super(Constants.getString("Waypoint.options"), returnClass);
        this.props = JourneyMap.getInstance().waypointProperties;
    }

    @Override
    public void func_73866_w_() {
        this.field_73887_h.clear();
        int id = 0;
        this.buttonEnable = BooleanPropertyButton.create(id++, "Waypoint.enable_beacons", (PropertiesBase)this.props, this.props.beaconEnabled);
        this.field_73887_h.add(this.buttonEnable);
        this.listLeftButtons = new ButtonList(BooleanPropertyButton.create(id++, "Waypoint.auto_hide_label", (PropertiesBase)this.props, this.props.autoHideLabel), BooleanPropertyButton.create(id++, "Waypoint.show_static_beam", (PropertiesBase)this.props, this.props.showStaticBeam), BooleanPropertyButton.create(id++, "Waypoint.show_rotating_beam", (PropertiesBase)this.props, this.props.showRotatingBeam), BooleanPropertyButton.create(id++, "Waypoint.show_texture", (PropertiesBase)this.props, this.props.showTexture), BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, "Waypoint.texture_size", this.props, this.props.textureSmall));
        this.field_73887_h.addAll(this.listLeftButtons);
        this.listRightButtons = new ButtonList(BooleanPropertyButton.create(id++, "Waypoint.show_name", (PropertiesBase)this.props, this.props.showName), BooleanPropertyButton.create(id++, "Waypoint.show_distance", (PropertiesBase)this.props, this.props.showDistance), BooleanPropertyButton.create(id++, "Waypoint.bold_label", (PropertiesBase)this.props, this.props.boldLabel), BooleanPropertyButton.create(id++, "Waypoint.force_unicode", (PropertiesBase)this.props, this.props.forceUnicode), BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, "Waypoint.font_size", this.props, this.props.fontSmall));
        this.field_73887_h.addAll(this.listRightButtons);
        this.maxDistanceField = new TextField(this.props.maxDistance.toString(), this.getFontRenderer(), 100, 20, true, true);
        this.maxDistanceField.setClamp(-1, 10000);
        this.buttonHide = new Button(id++, Constants.getString("JourneyMap.show_buttons"), Constants.getString("JourneyMap.hide_buttons"), false);
        this.field_73887_h.add(this.buttonHide);
        this.buttonClose = new Button(id++, Constants.getString("MapOverlay.close"));
        this.buttonClose.setWidth(this.buttonEnable.getWidth());
        this.field_73887_h.add(this.buttonClose);
        new ButtonList(this.field_73887_h).equalizeWidths(this.getFontRenderer());
        this.listLeftButtons.setNoDisableText(true);
        this.listRightButtons.setNoDisableText(true);
        this.updateButtons();
    }

    @Override
    protected void layoutButtons() {
        if (this.field_73887_h.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 4;
        int vgap = 3;
        int bx = this.field_73880_f / 2;
        int by = Math.max(30, (this.field_73881_g - 192) / 2);
        this.buttonEnable.centerHorizontalOn(bx).setY(by);
        by = this.buttonEnable.getBottomY() + 3;
        int leftOffset = 2 + ((Button)this.listLeftButtons.get(0)).getWidth();
        this.listLeftButtons.layoutVertical(bx - leftOffset, by, true, 3);
        this.listRightButtons.layoutVertical(bx + 2, by, true, 3);
        this.maxDistanceField.setX(bx + 4);
        this.maxDistanceField.setY(this.listLeftButtons.getBottomY() + 3);
        this.maxDistanceField.setWidth(this.buttonEnable.getWidth() - 4);
        this.maxDistanceField.func_73795_f();
        DrawUtil.drawRectangle(this.listLeftButtons.getLeftX(), this.maxDistanceField.getY(), ((Button)this.listLeftButtons.get(0)).getWidth(), this.maxDistanceField.getHeight(), Color.black, 150);
        DrawUtil.drawLabel(this.labelMaxDistance, bx - 4, this.maxDistanceField.getMiddleY(), DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, Color.BLACK, 0, Color.cyan, 255, 1.0, true);
        this.buttonHide.setPosition(bx - leftOffset, this.maxDistanceField.getBottomY() + 12);
        this.buttonClose.alignTo(this.buttonHide, DrawUtil.HAlign.Right, 4, DrawUtil.VAlign.Middle, 3);
    }

    public void func_73873_v_() {
        int idx;
        if (this.buttonHide.getToggled().booleanValue()) {
            DrawUtil.drawRectangle(0.0, 0.0, this.field_73880_f, 25.0, Color.black, 100);
            DrawUtil.drawRectangle(0.0, this.field_73881_g - 25, this.field_73880_f, 25.0, Color.black, 150);
        } else {
            super.func_73873_v_();
        }
        String fps = this.field_73882_e.field_71426_K;
        int n = idx = fps != null ? fps.indexOf(44) : -1;
        if (idx > 0) {
            fps = fps.substring(0, idx);
            DrawUtil.drawLabel(fps, this.field_73880_f - 5, 5.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Below, Color.BLACK, 0, Color.cyan, 255, 1.0, true);
        }
    }

    protected void func_73875_a(GuiButton button) {
        if (button instanceof BooleanPropertyButton) {
            ((BooleanPropertyButton)button).toggle();
        }
        if (button.field_73741_f == this.buttonEnable.field_73741_f) {
            this.updateButtons();
            return;
        }
        if (button.field_73741_f == this.buttonHide.field_73741_f) {
            this.buttonHide.toggle();
            this.updateButtons();
            return;
        }
        if (button.field_73741_f == this.buttonClose.field_73741_f) {
            this.closeAndReturn();
        }
    }

    protected void updateButtons() {
        boolean enable = this.buttonEnable.getToggled();
        boolean show = this.buttonHide.getToggled() == false;
        this.listLeftButtons.setDefaultStyle(show);
        this.listLeftButtons.setOptions(enable, show, show);
        this.listRightButtons.setDefaultStyle(show);
        this.listRightButtons.setOptions(enable, show, show);
        this.maxDistanceField.func_82265_c(enable);
        this.buttonEnable.setEnabled(true);
        this.buttonEnable.setDefaultStyle(show);
        this.buttonEnable.setDrawBackground(show);
        this.buttonEnable.setDrawFrame(show);
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (this.maxDistanceField.func_73802_a(par1, par2)) {
            Integer maxDistance = this.maxDistanceField.clamp();
            if (maxDistance != null) {
                JourneyMap.getInstance().waypointProperties.maxDistance.set(maxDistance);
            }
            return;
        }
        super.func_73869_a(par1, par2);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.maxDistanceField.func_73793_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void close() {
        JourneyMap.getInstance().waypointProperties.save();
    }
}

