/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityDTO;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        EntityDTO dto = new EntityDTO((EntityLivingBase)player, false);
        dto.biome = this.getPlayerBiome(mc, player);
        dto.underground = PlayerData.playerIsUnderground(mc, (EntityPlayer)player);
        return dto;
    }

    private String getPlayerBiome(Minecraft mc, EntityClientPlayerMP player) {
        int x = (int)Math.floor(player.field_70165_t) % 16 & 0xF;
        int z = (int)Math.floor(player.field_70161_v) % 16 & 0xF;
        ChunkMD playerChunk = ChunkLoader.getChunkStubFromMemory(player.field_70176_ah, player.field_70164_aj, mc);
        if (playerChunk != null) {
            return playerChunk.stub.func_76591_a((int)x, (int)z, (WorldChunkManager)mc.field_71441_e.func_72959_q()).field_76791_y;
        }
        return "?";
    }

    public static boolean playerIsUnderground(Minecraft mc, EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76576_e) {
            return true;
        }
        int posX = (int)Math.floor(player.field_70165_t);
        int posY = (int)Math.floor(player.field_70163_u) - 1;
        int posZ = (int)Math.floor(player.field_70161_v);
        boolean offset = true;
        int x = 0;
        int y = 0;
        int z = 0;
        boolean blockId = false;
        boolean isUnderground = true;
        if (y < 0) {
            return true;
        }
        block0: for (x = posX - 1; x <= posX + 1; ++x) {
            for (z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                if (!PlayerData.canSeeSky(player.field_70170_p, x, y, z)) continue;
                isUnderground = false;
                break block0;
            }
        }
        return isUnderground;
    }

    private static boolean canSeeSky(World world, int x, int y, int z) {
        boolean seeSky = true;
        int topY = world.func_72825_h(x, z);
        if (y >= topY) {
            return true;
        }
        Chunk chunk = world.func_72938_d(x, z);
        int checkY = topY;
        while (seeSky && checkY > y) {
            try {
                Block block = chunk.func_150810_a(x & 0xF, checkY, z & 0xF);
                if (BlockUtils.hasFlag(block, BlockUtils.Flag.NotHideSky)) {
                    --checkY;
                    continue;
                }
                seeSky = false;
                break;
            }
            catch (Exception e) {
                JourneyMap.getLogger().warning(e + " at " + (x & 0xF) + "," + --checkY + "," + (z & 0xF));
            }
        }
        return seeSky;
    }

    public long getTTL() {
        return JourneyMap.getInstance().coreProperties.cachePlayerData.get();
    }
}

