/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.impl.FairPlay;

public class FeatureManager {
    private final FeatureSet featureSet;

    public static FeatureManager instance() {
        return Holder.INSTANCE;
    }

    private FeatureManager() {
        FeatureSet fs = null;
        try {
            Class<?> fsClass = Class.forName("net.techbrew.journeymap.feature.impl.Unlimited");
            fs = (FeatureSet)fsClass.newInstance();
        }
        catch (Throwable e) {
            fs = new FairPlay();
        }
        this.featureSet = fs;
    }

    public static boolean isAllowed(Feature feature) {
        return Holder.INSTANCE.featureSet.isUnlimited() || !feature.isCurrentlyRestricted() || Holder.INSTANCE.featureSet.getFeatures().contains((Object)feature);
    }

    public static Map<Feature, Boolean> getAllowedFeatures() {
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>(Feature.values().length * 2);
        for (Feature feature : Feature.values()) {
            map.put(feature, FeatureManager.isAllowed(feature));
        }
        return map;
    }

    public static String getFeatureSetName() {
        return FeatureManager.instance().featureSet.getName();
    }

    public static interface FeatureSet {
        public Set<Feature> getFeatures();

        public String getName();

        public boolean isUnlimited();
    }

    private static class Holder {
        private static final FeatureManager INSTANCE = new FeatureManager();

        private Holder() {
        }
    }
}

