/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.Serializable;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.model.EntityHelper;

public final class EntityDTO
implements Serializable {
    public final transient EntityLivingBase entityLiving;
    public final String entityId;
    public final String filename;
    public final Boolean hostile;
    public final double posX;
    public final double posY;
    public final double posZ;
    public final int chunkCoordX;
    public final int chunkCoordY;
    public final int chunkCoordZ;
    public final double heading;
    public final String customName;
    public final String owner;
    public final Integer profession;
    public final String username;
    public String biome;
    public final int dimension;
    public Boolean underground;
    public final boolean invisible;
    public final boolean sneaking;
    public final boolean passiveAnimal;

    public EntityDTO(EntityLivingBase entity, boolean hostile) {
        EntityClientPlayerMP currentPlayer = FMLClientHandler.instance().getClient().field_71439_g;
        this.entityId = entity.func_110124_au().toString();
        this.entityLiving = entity;
        this.dimension = entity.field_71093_bK;
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
        this.chunkCoordX = entity.field_70176_ah;
        this.chunkCoordY = entity.field_70162_ai;
        this.chunkCoordZ = entity.field_70164_aj;
        this.heading = EntityHelper.getHeading((Entity)entity);
        this.invisible = currentPlayer != null ? entity.func_98034_c((EntityPlayer)currentPlayer) : false;
        this.sneaking = entity.func_70093_af();
        if (entity instanceof EntityPlayer) {
            this.filename = "/skin/" + ((EntityPlayer)entity).getDisplayName();
            this.username = ((EntityPlayer)entity).getDisplayName();
        } else {
            this.filename = EntityHelper.getFileName((Entity)entity);
            this.username = null;
        }
        String owner = null;
        if (entity instanceof EntityTameable) {
            owner = ((EntityTameable)entity).func_70905_p();
        } else if (entity instanceof IEntityOwnable) {
            owner = ((IEntityOwnable)entity).func_70905_p();
        } else if (entity instanceof EntityHorse) {
            owner = ((EntityHorse)entity).func_142019_cb();
        }
        this.owner = owner;
        String customName = null;
        boolean passive = false;
        if (entity instanceof EntityLiving) {
            EntityLivingBase attackTarget;
            if (((EntityLiving)entity).func_94056_bM()) {
                customName = StringUtils.func_76338_a((String)((EntityLiving)entity).func_94057_bL());
            }
            if (!hostile && currentPlayer != null && (attackTarget = ((EntityLiving)entity).func_70638_az()) != null && attackTarget.func_110124_au().equals(currentPlayer.func_110124_au())) {
                hostile = true;
            }
            if (EntityHelper.isPassiveAnimal((EntityLiving)entity)) {
                passive = true;
            }
        }
        this.customName = customName;
        this.hostile = hostile;
        this.passiveAnimal = passive;
        this.profession = entity instanceof EntityVillager ? Integer.valueOf(((EntityVillager)entity).func_70946_n()) : null;
    }
}

