/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.CoreProperties;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;

public class MapOverlayState {
    final CoreProperties coreProperties;
    public final int minZoom = 0;
    public final int maxZoom = 5;
    public boolean follow;
    public int currentZoom;
    public String playerLastPos;
    private Constants.MapType overrideMapType;
    private File worldDir;
    private long lastRefresh;
    private Integer vSlice;
    private boolean underground;
    private int dimension;
    private boolean caveMappingAllowed;
    private List<DrawStep> drawStepList;
    private List<DrawWayPointStep> drawWaypointStepList;
    private String playerBiome;

    public MapOverlayState() {
        this.coreProperties = JourneyMap.getInstance().coreProperties;
        this.minZoom = 0;
        this.maxZoom = 5;
        this.follow = true;
        this.playerLastPos = "0,0";
        this.worldDir = null;
        this.lastRefresh = 0L;
        this.vSlice = null;
        this.underground = false;
        this.dimension = Integer.MIN_VALUE;
        this.caveMappingAllowed = false;
        this.drawStepList = new ArrayList<DrawStep>();
        this.drawWaypointStepList = new ArrayList<DrawWayPointStep>();
        this.playerBiome = "";
    }

    public void refresh(Minecraft mc, EntityClientPlayerMP player, MapProperties mapProperties) {
        boolean showCaves = JourneyMap.getInstance().fullMapProperties.showCaves.get();
        Constants.MapType lastMapType = this.getMapType(showCaves);
        boolean lastUnderground = this.underground;
        int lastDimension = this.currentZoom;
        File lastWorldDir = this.worldDir;
        this.caveMappingAllowed = FeatureManager.isAllowed(Feature.MapCaves);
        this.dimension = player.field_71093_bK;
        this.underground = DataCache.getPlayer().underground;
        this.vSlice = this.underground ? Integer.valueOf(player.field_70162_ai) : null;
        this.worldDir = FileHandler.getJMWorldDir(mc);
        if (player.field_71093_bK != this.dimension) {
            this.follow = true;
        } else if (!this.worldDir.equals(this.worldDir)) {
            this.follow = true;
        } else if (this.getMapType(showCaves) == Constants.MapType.underground && lastMapType != Constants.MapType.underground) {
            this.follow = true;
        }
        this.playerBiome = DataCache.getPlayer().biome;
        this.updateLastRefresh();
    }

    public void overrideMapType(Constants.MapType mapType) {
        this.overrideMapType = mapType;
        this.requireRefresh();
    }

    public Constants.MapType getMapType(boolean allowCaves) {
        if (this.underground && this.caveMappingAllowed && allowCaves) {
            return Constants.MapType.underground;
        }
        if (this.overrideMapType != null) {
            return this.overrideMapType;
        }
        long ticks = Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L;
        return ticks < 13800L ? Constants.MapType.day : Constants.MapType.night;
    }

    public Integer getVSlice() {
        return this.vSlice;
    }

    public boolean isUnderground() {
        return this.underground;
    }

    public int getDimension() {
        return this.dimension;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public List<DrawWayPointStep> getDrawWaypointSteps() {
        return this.drawWaypointStepList;
    }

    public void generateDrawSteps(Minecraft mc, GridRenderer gridRenderer, OverlayWaypointRenderer waypointRenderer, OverlayRadarRenderer radarRenderer, MapProperties mapProperties, float drawScale, boolean checkWaypointDistance) {
        this.drawStepList.clear();
        this.drawWaypointStepList.clear();
        ArrayList<EntityDTO> entities = new ArrayList<EntityDTO>(32);
        if (this.currentZoom == 0) {
            drawScale *= 0.5f;
        }
        if (FeatureManager.isAllowed(Feature.RadarAnimals) && (mapProperties.showAnimals.get() || mapProperties.showPets.get())) {
            entities.addAll(DataCache.instance().getAnimals(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarVillagers) && mapProperties.showVillagers.get()) {
            entities.addAll(DataCache.instance().getVillagers(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarMobs) && mapProperties.showMobs.get()) {
            entities.addAll(DataCache.instance().getMobs(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarPlayers) && mapProperties.showPlayers.get()) {
            entities.addAll(DataCache.instance().getPlayers(false).values());
        }
        if (!entities.isEmpty()) {
            Collections.sort(entities, new EntityHelper.EntityMapComparator());
            this.drawStepList.addAll(radarRenderer.prepareSteps(entities, gridRenderer, drawScale, mapProperties));
        }
        if (mapProperties.showWaypoints.get()) {
            ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>(DataCache.instance().getWaypoints(false));
            this.drawWaypointStepList.addAll(waypointRenderer.prepareSteps(waypoints, gridRenderer, checkWaypointDistance));
        }
    }

    public boolean zoomIn() {
        if (this.currentZoom < 5) {
            return this.setZoom(this.currentZoom + 1);
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.currentZoom > 0) {
            return this.setZoom(this.currentZoom - 1);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 5 || zoom < 0 || zoom == this.currentZoom) {
            return false;
        }
        this.currentZoom = zoom;
        this.requireRefresh();
        return true;
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(Minecraft mc) {
        if (System.currentTimeMillis() > this.lastRefresh + 500L + (long)this.coreProperties.chunkPoll.get()) {
            return true;
        }
        if (this.dimension != mc.field_71441_e.field_73011_w.field_76574_g) {
            return true;
        }
        return this.underground != DataCache.getPlayer().underground;
    }
}

