/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawPlayerStep
implements DrawStep {
    final TextureImpl texture;
    final EntityPlayer entity;

    public DrawPlayerStep(EntityPlayer entity, TextureImpl texture) {
        this.entity = entity;
        this.texture = texture;
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale) {
        if (this.entity.field_70128_L || !this.entity.field_70175_ag || this.entity.func_70093_af()) {
            return;
        }
        float labelOffset = this.texture != null ? (float)this.texture.height : 0.0f;
        Point2D.Double pixel = gridRenderer.getPixel(this.entity.field_70165_t, this.entity.field_70161_v);
        if (pixel != null) {
            if (this.texture != null) {
                DrawUtil.drawEntity(((Point2D)pixel).getX() + xOffset, ((Point2D)pixel).getY() + yOffset, EntityHelper.getHeading((Entity)this.entity), true, this.texture, 0, drawScale * 0.75f);
            }
            DrawUtil.drawCenteredLabel(this.entity.func_70005_c_(), ((Point2D)pixel).getX() + xOffset, ((Point2D)pixel).getY() + yOffset - (double)labelOffset, Color.black, 205, Color.green, 255, fontScale);
        }
    }
}

