/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.entity;

import java.awt.Color;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.properties.WaypointProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.waypoint.WaypointStore;
import org.lwjgl.opengl.GL11;

public class RenderWaypointBeacon {
    static final ResourceLocation beam = new ResourceLocation("textures/entity/beacon_beam.png");
    static StatTimer timer = StatTimer.get("WaypointBeacon.doRender", 100);
    static StatTimer allTimer = StatTimer.get("WaypointBeacon.renderAll", 100);
    static Minecraft mc = Minecraft.func_71410_x();
    static RenderManager renderManager = RenderManager.field_78727_a;
    static String distanceLabel = Constants.getString("Waypoint.distance_meters", "%1.0f");
    static WaypointProperties waypointProperties;

    public static void resetStatTimers() {
        timer.reset();
        allTimer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAll() {
        try {
            if (waypointProperties == null) {
                waypointProperties = JourneyMap.getInstance().waypointProperties;
            }
            Collection<Waypoint> waypoints = WaypointStore.instance().getAll();
            allTimer.start();
            int playerDim = RenderWaypointBeacon.mc.field_71439_g.field_71093_bK;
            for (Waypoint wp : waypoints) {
                if (!wp.isEnable() || !wp.getDimensions().contains(playerDim)) continue;
                try {
                    RenderWaypointBeacon.doRender(wp);
                }
                catch (Throwable t) {
                    JourneyMap.getLogger().severe("EntityWaypoint failed to render for " + wp + ": " + LogFormatter.toString(t));
                }
            }
        }
        catch (Throwable t) {
            allTimer.cancel();
            JourneyMap.getLogger().severe("Error rendering waypoints: " + LogFormatter.toString(t));
        }
        finally {
            allTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doRender(Waypoint waypoint) {
        if (RenderWaypointBeacon.renderManager.field_78734_h == null) {
            return;
        }
        timer.start();
        RenderHelper.func_74519_b();
        try {
            int dimension = RenderWaypointBeacon.renderManager.field_78734_h.field_71093_bK;
            Vec3 playerVec = RenderWaypointBeacon.renderManager.field_78734_h.func_70666_h(1.0f);
            Vec3 waypointVec = waypoint.getPosition();
            waypointVec.field_72448_b += 0.118;
            double actualDistance = playerVec.func_72438_d(waypointVec);
            int maxDistance = RenderWaypointBeacon.waypointProperties.maxDistance.get();
            if (maxDistance > 0 && actualDistance > (double)maxDistance) {
                return;
            }
            double viewDistance = actualDistance;
            double maxRenderDistance = RenderWaypointBeacon.mc.field_71474_y.field_151451_c * 16;
            if (viewDistance > maxRenderDistance) {
                Vec3 delta = waypointVec.func_72444_a(playerVec).func_72432_b();
                waypointVec = playerVec.func_72441_c(-delta.field_72450_a * maxRenderDistance, -delta.field_72448_b * maxRenderDistance, -delta.field_72449_c * maxRenderDistance);
                viewDistance = maxRenderDistance;
            }
            double shiftX = waypointVec.field_72450_a - RenderWaypointBeacon.renderManager.field_78730_l;
            double shiftY = waypointVec.field_72448_b - RenderWaypointBeacon.renderManager.field_78731_m;
            double shiftZ = waypointVec.field_72449_c - RenderWaypointBeacon.renderManager.field_78728_n;
            boolean showStaticBeam = RenderWaypointBeacon.waypointProperties.showStaticBeam.get();
            boolean showRotatingBeam = RenderWaypointBeacon.waypointProperties.showRotatingBeam.get();
            if (showStaticBeam || showRotatingBeam) {
                RenderWaypointBeacon.renderBeam(shiftX, -RenderWaypointBeacon.renderManager.field_78731_m, shiftZ, waypoint.getColor(), showStaticBeam, showRotatingBeam);
            }
            String label = waypoint.getName();
            boolean labelHidden = false;
            if (viewDistance > 0.5 && RenderWaypointBeacon.waypointProperties.autoHideLabel.get()) {
                double playerYaw;
                int angle = 5;
                double yaw = Math.atan2(RenderWaypointBeacon.renderManager.field_78728_n - waypointVec.field_72449_c, RenderWaypointBeacon.renderManager.field_78730_l - waypointVec.field_72450_a);
                double degrees = Math.toDegrees(yaw) + 90.0;
                if (degrees < 0.0) {
                    degrees = 360.0 + degrees;
                }
                if ((playerYaw = (double)(RenderWaypointBeacon.renderManager.field_78734_h.func_70079_am() % 360.0f)) < 0.0) {
                    playerYaw += 360.0;
                }
                playerYaw = Math.toRadians(playerYaw);
                double playerDegrees = Math.toDegrees(playerYaw);
                labelHidden = Math.abs((degrees += (double)angle) + (double)angle - ((playerDegrees += (double)angle) + (double)angle)) > (double)angle;
            }
            double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
            FontRenderer fr = renderManager.func_78716_a();
            TextureImpl texture = waypoint.getTexture();
            double halfTexHeight = texture.height / 2;
            boolean showName = RenderWaypointBeacon.waypointProperties.showName.get() && label != null && label.length() > 0;
            boolean showDistance = RenderWaypointBeacon.waypointProperties.showDistance.get();
            if (!labelHidden && (showName || showDistance)) {
                StringBuilder sb = new StringBuilder();
                if (RenderWaypointBeacon.waypointProperties.boldLabel.get()) {
                    sb.append(EnumChatFormatting.BOLD);
                }
                if (showName) {
                    sb.append(label);
                }
                if (showName && showDistance) {
                    sb.append(" ");
                }
                if (showDistance) {
                    sb.append(String.format(distanceLabel, actualDistance));
                }
                if (sb.length() > 0) {
                    label = sb.toString();
                    GL11.glPushMatrix();
                    GL11.glDisable((int)2896);
                    GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                    GL11.glTranslated((double)shiftX, (double)shiftY, (double)shiftZ);
                    GL11.glRotatef((float)(-RenderWaypointBeacon.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)RenderWaypointBeacon.renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScaled((double)(-scale), (double)(-scale), (double)scale);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    int fontScale = RenderWaypointBeacon.waypointProperties.fontSmall.get() ? 2 : 4;
                    boolean forced = DrawUtil.startUnicode(fr, RenderWaypointBeacon.waypointProperties.forceUnicode.get());
                    double labelY = 0.0 - halfTexHeight - 8.0;
                    DrawUtil.drawLabel(label, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, Color.black, 150, waypoint.getSafeColor(), 255, fontScale, false);
                    GL11.glDisable((int)2929);
                    GL11.glDepthMask((boolean)false);
                    DrawUtil.drawLabel(label, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, Color.black, 100, waypoint.getSafeColor(), 255, fontScale, false);
                    if (forced) {
                        DrawUtil.stopUnicode(fr);
                    }
                    GL11.glPopMatrix();
                }
            }
            if (viewDistance > 0.1 && RenderWaypointBeacon.waypointProperties.showTexture.get()) {
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                int n = RenderWaypointBeacon.waypointProperties.textureSmall.get() ? 1 : 2;
                GL11.glTranslated((double)shiftX, (double)shiftY, (double)shiftZ);
                GL11.glRotatef((float)(-RenderWaypointBeacon.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)RenderWaypointBeacon.renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)(-(scale *= (double)n)), (double)(-scale), (double)scale);
                GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * scale));
                DrawUtil.drawColoredImage(texture, 255, waypoint.getColor(), (double)(0 - texture.width / 2) + 0.5, 0.0 - halfTexHeight + 0.2);
                GL11.glPopMatrix();
            }
        }
        finally {
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)2896);
            timer.stop();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2912);
            RenderHelper.func_74518_a();
        }
    }

    static void renderBeam(double x, double y, double z, Color color, boolean staticBeam, boolean rotatingBeam) {
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderWaypointBeacon.mc.field_71446_o.func_110577_a(beam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        float time = RenderWaypointBeacon.mc.field_71441_e.func_82737_E();
        if (mc.func_147113_T()) {
            time = Minecraft.func_71386_F() / 50L;
        }
        float texOffset = -(-time * 0.2f - (float)MathHelper.func_76141_d((float)(-time * 0.1f))) * 0.6f;
        if (rotatingBeam) {
            boolean b0 = true;
            double d3 = (double)time * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
            tessellator.func_78382_b();
            tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), 80);
            double d4 = (double)b0 * 0.2;
            double d5 = Math.cos(d3 + 2.356194490192345) * d4;
            double d6 = Math.sin(d3 + 2.356194490192345) * d4;
            double d7 = Math.cos(d3 + 0.7853981633974483) * d4;
            double d8 = Math.sin(d3 + 0.7853981633974483) * d4;
            double d9 = Math.cos(d3 + 3.9269908169872414) * d4;
            double d10 = Math.sin(d3 + 3.9269908169872414) * d4;
            double d11 = Math.cos(d3 + 5.497787143782138) * d4;
            double d12 = Math.sin(d3 + 5.497787143782138) * d4;
            double d13 = 256.0f * f1;
            double d14 = 0.0;
            double d15 = 1.0;
            double d16 = -1.0f + texOffset;
            double d17 = (double)(256.0f * f1) * (0.5 / d4) + d16;
            tessellator.func_78374_a(x + d5, y + d13, z + d6, d15, d17);
            tessellator.func_78374_a(x + d5, y, z + d6, d15, d16);
            tessellator.func_78374_a(x + d7, y, z + d8, d14, d16);
            tessellator.func_78374_a(x + d7, y + d13, z + d8, d14, d17);
            tessellator.func_78374_a(x + d11, y + d13, z + d12, d15, d17);
            tessellator.func_78374_a(x + d11, y, z + d12, d15, d16);
            tessellator.func_78374_a(x + d9, y, z + d10, d14, d16);
            tessellator.func_78374_a(x + d9, y + d13, z + d10, d14, d17);
            tessellator.func_78374_a(x + d7, y + d13, z + d8, d15, d17);
            tessellator.func_78374_a(x + d7, y, z + d8, d15, d16);
            tessellator.func_78374_a(x + d11, y, z + d12, d14, d16);
            tessellator.func_78374_a(x + d11, y + d13, z + d12, d14, d17);
            tessellator.func_78374_a(x + d9, y + d13, z + d10, d15, d17);
            tessellator.func_78374_a(x + d9, y, z + d10, d15, d16);
            tessellator.func_78374_a(x + d5, y, z + d6, d14, d16);
            tessellator.func_78374_a(x + d5, y + d13, z + d6, d14, d17);
            tessellator.func_78381_a();
        }
        if (staticBeam) {
            GL11.glDisable((int)2884);
            double d26 = 256.0f * f1;
            double d29 = -1.0f + texOffset;
            double d30 = (double)(256.0f * f1) + d29;
            tessellator.func_78382_b();
            tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), 40);
            tessellator.func_78374_a((x -= 0.5) + 0.2, y + d26, (z -= 0.5) + 0.2, 1.0, d30);
            tessellator.func_78374_a(x + 0.2, y, z + 0.2, 1.0, d29);
            tessellator.func_78374_a(x + 0.8, y, z + 0.2, 0.0, d29);
            tessellator.func_78374_a(x + 0.8, y + d26, z + 0.2, 0.0, d30);
            tessellator.func_78374_a(x + 0.8, y + d26, z + 0.8, 1.0, d30);
            tessellator.func_78374_a(x + 0.8, y, z + 0.8, 1.0, d29);
            tessellator.func_78374_a(x + 0.2, y, z + 0.8, 0.0, d29);
            tessellator.func_78374_a(x + 0.2, y + d26, z + 0.8, 0.0, d30);
            tessellator.func_78374_a(x + 0.8, y + d26, z + 0.2, 1.0, d30);
            tessellator.func_78374_a(x + 0.8, y, z + 0.2, 1.0, d29);
            tessellator.func_78374_a(x + 0.8, y, z + 0.8, 0.0, d29);
            tessellator.func_78374_a(x + 0.8, y + d26, z + 0.8, 0.0, d30);
            tessellator.func_78374_a(x + 0.2, y + d26, z + 0.8, 1.0, d30);
            tessellator.func_78374_a(x + 0.2, y, z + 0.8, 1.0, d29);
            tessellator.func_78374_a(x + 0.2, y, z + 0.2, 0.0, d29);
            tessellator.func_78374_a(x + 0.2, y + d26, z + 0.2, 0.0, d30);
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }
}

