/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import com.google.common.base.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.render.draw.DrawCenteredLabelStep;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawPlayerStep;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class OverlayRadarRenderer {
    final Color labelBg = Color.darkGray.darker();

    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, float drawScale, MapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showPets = mapProperties.showPets.get();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            String playername = Minecraft.func_71410_x().field_71439_g.getDisplayName();
            TextureCache tc = TextureCache.instance();
            for (EntityDTO dto : entityDTOs) {
                try {
                    TextureImpl entityIcon;
                    boolean isPet;
                    boolean bl = isPet = !Strings.isNullOrEmpty((String)dto.owner);
                    if (!showPets && isPet || !showAnimals && dto.passiveAnimal && (!isPet || !showPets) || grid.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean isPlayer = dto.entityLiving instanceof EntityPlayer;
                    TextureImpl locatorImg = dto.hostile != false ? tc.getHostileLocator() : (!Strings.isNullOrEmpty((String)dto.owner) && playername.equals(dto.owner) ? tc.getPetLocator() : (isPlayer ? tc.getOtherLocator() : tc.getNeutralLocator()));
                    drawStepList.add(new DrawEntityStep((Entity)dto.entityLiving, false, locatorImg, (int)(8.0f * drawScale)));
                    if (isPlayer) {
                        entityIcon = tc.getPlayerSkin(dto.username);
                        drawStepList.add(new DrawPlayerStep((EntityPlayer)dto.entityLiving, entityIcon));
                        continue;
                    }
                    entityIcon = tc.getEntityImage(dto.filename);
                    if (entityIcon != null) {
                        int bottomMargin = isPlayer ? 0 : (int)(8.0f * drawScale);
                        drawStepList.add(new DrawEntityStep((Entity)dto.entityLiving, true, entityIcon, bottomMargin));
                    }
                    if (dto.customName == null) continue;
                    drawStepList.add(new DrawCenteredLabelStep(dto.posX, dto.posZ, dto.customName, entityIcon.height / 2, this.labelBg, Color.white));
                }
                catch (Exception e) {
                    JourneyMap.getLogger().severe("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

