/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.texture.DelayedTexture;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.thread.JMThreadFactory;

public class TextureCache {
    private final Map<Name, TextureImpl> namedTextures = Collections.synchronizedMap(new HashMap(Name.values().length + Name.values().length / 2 + 1));
    private final Map<String, TextureImpl> customTextures = Collections.synchronizedMap(new HashMap(3));
    private final Map<String, TextureImpl> skinImageMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, TextureImpl> entityImageMap = Collections.synchronizedMap(new HashMap());
    private ThreadPoolExecutor texExec = (ThreadPoolExecutor)Executors.newFixedThreadPool(3, new JMThreadFactory("texture"));

    public static TextureCache instance() {
        return Holder.INSTANCE;
    }

    public static DynamicTexture newTexture(String path) {
        DynamicTexture texture;
        block4: {
            ResourceLocation loc = new ResourceLocation(path);
            texture = null;
            InputStream is = null;
            try {
                is = JourneyMap.class.getResourceAsStream(path);
                texture = new DynamicTexture(ImageIO.read(is));
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe("Can't get icon for " + loc + ": " + LogFormatter.toString(e));
                if (is == null) break block4;
                try {
                    is.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        return texture;
    }

    public Future<DelayedTexture> prepareImage(final Integer glId, final BufferedImage image, final File worldDir, final ChunkCoordIntPair startCoord, final ChunkCoordIntPair endCoord, final Constants.MapType mapType, final Integer vSlice, final int dimension, final Boolean useCache, final Integer imageWidth, final Integer imageHeight, final boolean showGrid) {
        Future<DelayedTexture> future = this.texExec.submit(new Callable<DelayedTexture>(){

            @Override
            public DelayedTexture call() throws Exception {
                BufferedImage chunksImage = RegionImageHandler.getMergedChunks(worldDir, startCoord, endCoord, mapType, vSlice, dimension, useCache, image, imageWidth, imageHeight, true, showGrid);
                if (chunksImage == null) {
                    chunksImage = RegionImageHandler.createBlankImage(imageWidth, imageHeight);
                }
                return new DelayedTexture(glId, chunksImage, null);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getCustomTexture(String filename, boolean retain) {
        Map<String, TextureImpl> map = this.customTextures;
        synchronized (map) {
            TextureImpl tex = this.customTextures.get(filename);
            if (tex == null || !tex.hasImage() && retain) {
                BufferedImage img = FileHandler.getCustomImage(filename);
                if (img == null) {
                    img = this.getUnknownEntity().getImage();
                }
                if (img != null) {
                    if (tex != null) {
                        tex.deleteTexture();
                    }
                    tex = new TextureImpl(img, retain);
                    this.customTextures.put(filename, tex);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureImpl getNamedTexture(Name name, String filename, boolean retain) {
        Map<Name, TextureImpl> map = this.namedTextures;
        synchronized (map) {
            TextureImpl tex = this.namedTextures.get((Object)name);
            if (tex == null || !tex.hasImage() && retain) {
                BufferedImage img = FileHandler.getWebImage(filename);
                if (img == null) {
                    img = this.getUnknownEntity().getImage();
                }
                if (img != null) {
                    if (tex != null) {
                        tex.deleteTexture();
                    }
                    tex = new TextureImpl(img, retain);
                    this.namedTextures.put(name, tex);
                }
            }
            return tex;
        }
    }

    public TextureImpl getMinimapSmallSquare() {
        return this.getNamedTexture(Name.MinimapSmallSquare, "minimap/minimap-square-128.png", false);
    }

    public TextureImpl getMinimapMediumSquare() {
        return this.getNamedTexture(Name.MinimapMediumSquare, "minimap/minimap-square-256.png", false);
    }

    public TextureImpl getMinimapLargeSquare() {
        return this.getNamedTexture(Name.MinimapLargeSquare, "minimap/minimap-square-512.png", false);
    }

    public TextureImpl getMinimapSmallCircle() {
        return this.getNamedTexture(Name.MinimapSmallCircle, "minimap/minimap-circle-256.png", false);
    }

    public TextureImpl getMinimapSmallCircleMask() {
        return this.getNamedTexture(Name.MinimapSmallCircle, "minimap/minimap-circle-mask-256.png", false);
    }

    public TextureImpl getMinimapLargeCircle() {
        return this.getNamedTexture(Name.MinimapLargeCircle, "minimap/minimap-circle-512.png", false);
    }

    public TextureImpl getMinimapLargeCircleMask() {
        return this.getNamedTexture(Name.MinimapLargeCircle, "minimap/minimap-circle-mask-512.png", false);
    }

    public TextureImpl getWaypoint() {
        return this.getNamedTexture(Name.Waypoint, "waypoint.png", false);
    }

    public TextureImpl getWaypointEdit() {
        return this.getNamedTexture(Name.WaypointEdit, "waypoint-edit.png", false);
    }

    public TextureImpl getWaypointOffscreen() {
        return this.getNamedTexture(Name.WaypointOffscreen, "waypoint-offscreen.png", false);
    }

    public TextureImpl getDeathpoint() {
        return this.getNamedTexture(Name.Deathpoint, "waypoint-death.png", false);
    }

    public TextureImpl getLogo() {
        return this.getNamedTexture(Name.Logo, "ico/journeymap60.png", false);
    }

    public TextureImpl getHostileLocator() {
        return this.getNamedTexture(Name.LocatorHostile, "locator-hostile.png", false);
    }

    public TextureImpl getNeutralLocator() {
        return this.getNamedTexture(Name.LocatorNeutral, "locator-neutral.png", false);
    }

    public TextureImpl getOtherLocator() {
        return this.getNamedTexture(Name.LocatorOther, "locator-other.png", false);
    }

    public TextureImpl getPetLocator() {
        return this.getNamedTexture(Name.LocatorPet, "locator-pet.png", false);
    }

    public TextureImpl getPlayerLocator() {
        return this.getNamedTexture(Name.LocatorPlayer, "locator-player.png", false);
    }

    public TextureImpl getPlayerLocatorSmall() {
        return this.getNamedTexture(Name.LocatorPlayerSmall, "locator-player-sm.png", false);
    }

    public TextureImpl getColorPicker() {
        return this.getNamedTexture(Name.ColorPicker, "colorpick.png", true);
    }

    public TextureImpl getUnknownEntity() {
        return this.getNamedTexture(Name.UnknownEntity, "entity/unknown.png", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getEntityImage(String filename) {
        Map<String, TextureImpl> map = this.entityImageMap;
        synchronized (map) {
            BufferedImage img;
            TextureImpl tex = this.entityImageMap.get(filename);
            if (!(tex != null && tex.hasImage() || (img = FileHandler.getCustomizableImage("entity/" + filename, this.getUnknownEntity().getImage())) == null)) {
                if (tex != null) {
                    tex.deleteTexture();
                }
                tex = new TextureImpl(img);
                this.entityImageMap.put(filename, tex);
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getPlayerSkin(String username) {
        Map<String, TextureImpl> map = this.skinImageMap;
        synchronized (map) {
            TextureImpl tex = this.skinImageMap.get(username);
            if (tex == null) {
                BufferedImage img = null;
                try {
                    URL url = new URL("http://s3.amazonaws.com/MinecraftSkins/" + username + ".png");
                    img = ImageIO.read(url).getSubimage(8, 8, 8, 8);
                }
                catch (Throwable e) {
                    try {
                        URL url = new URL("http://s3.amazonaws.com/MinecraftSkins/char.png");
                        img = ImageIO.read(url).getSubimage(8, 8, 8, 8);
                    }
                    catch (Throwable e2) {
                        JourneyMap.getLogger().warning("Can't get skin image for " + username + ": " + e2.getMessage());
                    }
                }
                if (img != null) {
                    BufferedImage scaledImage = new BufferedImage(24, 24, img.getType());
                    Graphics2D g = RegionImageHandler.initRenderingHints(scaledImage.createGraphics());
                    g.drawImage(img, 0, 0, 24, 24, null);
                    g.dispose();
                    tex = new TextureImpl(scaledImage, true);
                } else {
                    tex = this.getUnknownEntity();
                }
                this.skinImageMap.put(username, tex);
            }
            return tex;
        }
    }

    public void purge() {
    }

    public static enum Name {
        MinimapSmallSquare,
        MinimapMediumSquare,
        MinimapLargeSquare,
        MinimapSmallCircle,
        MinimapLargeCircle,
        Waypoint,
        Deathpoint,
        WaypointOffscreen,
        WaypointEdit,
        Logo,
        LocatorHostile,
        LocatorNeutral,
        LocatorOther,
        LocatorPet,
        LocatorPlayer,
        LocatorPlayerSmall,
        ColorPicker,
        UnknownEntity;

    }

    private static class Holder {
        private static final TextureCache INSTANCE = new TextureCache();

        private Holder() {
        }
    }
}

