/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import net.minecraft.world.World;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.IMapTask;

public abstract class BaseMapTask
implements IMapTask {
    final World world;
    final int dimension;
    final boolean underground;
    final Integer vSlice;
    final ChunkMD.Set chunkMdSet;
    final boolean flushCacheWhenDone;

    public BaseMapTask(World world, int dimension, boolean underground, Integer vSlice, ChunkMD.Set chunkMdSet, boolean flushCacheWhenDone) {
        this.world = world;
        this.dimension = dimension;
        this.underground = underground;
        this.vSlice = vSlice;
        if ((vSlice == null || vSlice == -1) && underground) {
            throw new IllegalStateException("vSlice can't be null (-1) and task be underground");
        }
        this.chunkMdSet = chunkMdSet;
        this.flushCacheWhenDone = flushCacheWhenDone;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isUnderground() {
        return this.underground;
    }

    @Override
    public Integer getVSlice() {
        return this.vSlice;
    }

    @Override
    public ChunkMD.Set getChunkStubs() {
        return this.chunkMdSet;
    }

    @Override
    public boolean flushCacheWhenDone() {
        return this.flushCacheWhenDone;
    }
}

