/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.BaseMapTask;
import net.techbrew.journeymap.task.ITaskManager;

public class MapPlayerTask
extends BaseMapTask {
    private static final Logger logger = JourneyMap.getLogger();
    private static TreeSet<ChunkCoordIntPair> queuedChunks = new TreeSet<ChunkCoordIntPair>(MapPlayerTask.getDistanceComparator());
    private static ChunkMD.Set lastChunkStubs = new ChunkMD.Set(512);
    private static ChunkCoordinates lastPlayerPos;
    private static Boolean lastUnderground;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queueChunk(ChunkCoordIntPair chunkCoords) {
        TreeSet<ChunkCoordIntPair> treeSet = queuedChunks;
        synchronized (treeSet) {
            return queuedChunks.add(chunkCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dequeueChunk(ChunkCoordIntPair chunkCoords) {
        Cloneable cloneable = queuedChunks;
        synchronized (cloneable) {
            queuedChunks.remove(chunkCoords);
        }
        cloneable = lastChunkStubs;
        synchronized (cloneable) {
            lastChunkStubs.remove(chunkCoords);
        }
    }

    private static Comparator<ChunkCoordIntPair> getDistanceComparator() {
        return new Comparator<ChunkCoordIntPair>(){
            Minecraft minecraft = Minecraft.func_71410_x();

            @Override
            public int compare(ChunkCoordIntPair o1, ChunkCoordIntPair o2) {
                if (this.minecraft.field_71439_g == null) {
                    return 0;
                }
                double d1 = this.minecraft.field_71439_g.func_70092_e((double)o1.func_77273_a(), this.minecraft.field_71439_g.field_70163_u, (double)o1.func_77274_b());
                double d2 = this.minecraft.field_71439_g.func_70092_e((double)o2.func_77273_a(), this.minecraft.field_71439_g.field_70163_u, (double)o2.func_77274_b());
                return Double.compare(d1, d2);
            }
        };
    }

    private MapPlayerTask(World world, int dimension, boolean underground, Integer chunkY, ChunkMD.Set chunkStubs) {
        super(world, dimension, underground, chunkY, chunkStubs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseMapTask create(EntityPlayer player) {
        int initialQueueSize;
        ChunkMD chunkMd;
        boolean underground;
        int missing = 0;
        int offset = JourneyMap.getInstance().coreProperties.chunkOffset.get();
        ChunkCoordinates playerPos = new ChunkCoordinates(player.field_70176_ah, player.field_70162_ai, player.field_70164_aj);
        boolean bl = underground = player.field_70170_p.field_73011_w.field_76576_e || DataCache.getPlayer().underground != false && JourneyMap.getInstance().fullMapProperties.showCaves.get();
        if (underground && !FeatureManager.isAllowed(Feature.MapCaves)) {
            return null;
        }
        int dimension = DataCache.getPlayer().dimension;
        if (lastUnderground == null) {
            lastUnderground = underground;
        }
        if (lastPlayerPos == null) {
            lastPlayerPos = playerPos;
        }
        if (lastPlayerPos.equals((Object)playerPos) && offset >= 2) {
            offset /= 2;
        }
        lastPlayerPos = playerPos;
        lastUnderground = underground;
        int side = offset + offset + 1;
        ChunkMD.Set chunks = new ChunkMD.Set(side * 3);
        World world = player.field_70170_p;
        Integer chunkY = underground ? Integer.valueOf(MapPlayerTask.lastPlayerPos.field_71572_b) : null;
        ChunkCoordIntPair min = new ChunkCoordIntPair(MapPlayerTask.lastPlayerPos.field_71574_a - offset, MapPlayerTask.lastPlayerPos.field_71573_c - offset);
        ChunkCoordIntPair max = new ChunkCoordIntPair(MapPlayerTask.lastPlayerPos.field_71574_a + offset, MapPlayerTask.lastPlayerPos.field_71573_c + offset);
        for (int x = min.field_77276_a; x <= max.field_77276_a; ++x) {
            for (int z = min.field_77275_b; z <= max.field_77275_b; ++z) {
                ChunkCoordIntPair coord = new ChunkCoordIntPair(x, z);
                chunkMd = (ChunkMD)lastChunkStubs.get(coord);
                chunkMd = chunkMd == null ? ChunkLoader.getChunkStubFromMemory(x, z, world) : ChunkLoader.refreshChunkStubFromMemory(chunkMd, world);
                if (chunkMd != null) {
                    chunkMd.render = true;
                    chunks.add(chunkMd);
                    continue;
                }
                ++missing;
            }
        }
        HashSet<ChunkCoordIntPair> tempQueue = new HashSet<ChunkCoordIntPair>(0);
        TreeSet<ChunkCoordIntPair> treeSet = queuedChunks;
        synchronized (treeSet) {
            initialQueueSize = queuedChunks.size();
            tempQueue.addAll(queuedChunks);
            queuedChunks.clear();
        }
        int maxChunks = 1024;
        int queued = 0;
        for (ChunkCoordIntPair coord : tempQueue) {
            chunkMd = ChunkLoader.getChunkStubFromMemory(coord.field_77276_a, coord.field_77275_b, world);
            if (chunkMd != null) {
                chunkMd.render = true;
                chunks.add(chunkMd);
                lastChunkStubs.put(coord, chunkMd);
                ++queued;
            } else {
                ++missing;
            }
            if (queued <= maxChunks || !logger.isLoggable(Level.FINE)) continue;
            logger.fine(String.format("Exceeded maxChunks, discarding %s", tempQueue.size() - maxChunks));
        }
        int skipped = 0;
        ChunkMD.Set set = lastChunkStubs;
        synchronized (set) {
            if (!lastChunkStubs.isEmpty()) {
                ChunkMD.Set removed = new ChunkMD.Set(64);
                for (ChunkMD oldChunk : lastChunkStubs) {
                    if (!chunks.containsKey(oldChunk.coord)) {
                        if (oldChunk.discard(1) <= 4) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Discarding out-of-range chunk: " + oldChunk);
                        }
                        removed.add(oldChunk);
                        continue;
                    }
                    oldChunk.discard(-1);
                    ChunkMD newChunk = (ChunkMD)chunks.get(oldChunk.coord);
                    if (tempQueue.contains(newChunk.coord)) {
                        newChunk.render = true;
                    }
                    if (!newChunk.render.booleanValue() || !logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Mapping chunk: " + newChunk);
                }
                lastChunkStubs.keySet().removeAll(removed.keySet());
            }
        }
        if (chunks.size() - skipped > 1 && logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Kept %s of %s queued chunks, mapped %s, skipped %s, missing %s, lastChunkStubs=%s", tempQueue.size(), initialQueueSize, chunks.size() - skipped, skipped, missing, lastChunkStubs.size()));
        }
        return new MapPlayerTask(world, dimension, underground, chunkY, chunks);
    }

    public static void clearCache() {
        lastChunkStubs.clear();
        lastPlayerPos = null;
        lastUnderground = null;
    }

    @Override
    public void taskComplete() {
        lastChunkStubs.putAll(this.chunkMdSet);
    }

    public static class Manager
    implements ITaskManager {
        boolean enabled;

        public Class<? extends BaseMapTask> getTaskClass() {
            return MapPlayerTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            this.enabled = true;
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            this.enabled = false;
        }

        @Override
        public BaseMapTask getTask(Minecraft minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (minecraft.field_71439_g.field_70175_ag) {
                BaseMapTask baseMapTask = MapPlayerTask.create((EntityPlayer)minecraft.field_71439_g);
                return baseMapTask;
            }
            return null;
        }

        @Override
        public void taskAccepted(boolean accepted) {
        }
    }
}

