/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.io.nbt.RegionLoader;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.task.BaseMapTask;
import net.techbrew.journeymap.task.ITask;
import net.techbrew.journeymap.task.ITaskManager;

public class MapRegionTask
extends BaseMapTask {
    private static final Logger logger = JourneyMap.getLogger();

    private MapRegionTask(World world, int dimension, boolean underground, Integer chunkY, ChunkMD.Set chunkMdPool) {
        super(world, dimension, underground, chunkY, chunkMdPool, true);
    }

    public static BaseMapTask create(RegionCoord rCoord, Minecraft minecraft) {
        int missing = 0;
        WorldClient world = minecraft.field_71441_e;
        File mcWorldDir = FileHandler.getMCWorldDir(minecraft, rCoord.dimension);
        ChunkMD.Set chunks = new ChunkMD.Set(1280);
        List<ChunkCoordIntPair> coords = rCoord.getChunkCoordsInRegion();
        while (!coords.isEmpty()) {
            ChunkCoordIntPair coord = coords.remove(0);
            ChunkMD stub = ChunkLoader.getChunkStubFromDisk(coord.field_77276_a, coord.field_77275_b, mcWorldDir, (World)world);
            if (stub == null) {
                ++missing;
                continue;
            }
            chunks.add(stub);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Chunks: " + missing + " skipped, " + chunks.size() + " used");
        }
        if (chunks.size() > 0) {
            logger.warning("No viable chunks found in region " + rCoord);
        }
        return new MapRegionTask((World)world, rCoord.dimension, rCoord.isUnderground(), rCoord.getVerticalSlice(), chunks);
    }

    @Override
    public void taskComplete() {
    }

    public static class Manager
    implements ITaskManager {
        RegionLoader regionLoader;
        boolean enabled;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return MapRegionTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            boolean bl = this.enabled = params != null;
            if (!this.enabled) {
                return false;
            }
            this.enabled = false;
            if (minecraft.func_71387_A()) {
                try {
                    Constants.MapType mapType;
                    EntityDTO player = DataCache.getPlayer();
                    int dimension = player.dimension;
                    boolean underground = player.underground != false && FeatureManager.isAllowed(Feature.MapCaves) && JourneyMap.getInstance().fullMapProperties.showCaves.get();
                    Integer vSlice = null;
                    if (underground) {
                        mapType = Constants.MapType.underground;
                        vSlice = player.chunkCoordY;
                    } else {
                        long time = minecraft.field_71441_e.func_72912_H().func_76073_f() % 24000L;
                        mapType = time < 13800L ? Constants.MapType.day : Constants.MapType.night;
                    }
                    Boolean mapAll = params == null ? false : (Boolean)params;
                    this.regionLoader = new RegionLoader(minecraft, dimension, mapType, vSlice, mapAll);
                    if (this.regionLoader.getRegionsFound() == 0) {
                        this.disableTask(minecraft);
                    } else {
                        this.enabled = true;
                    }
                }
                catch (Throwable t) {
                    String error = Constants.getMessageJMERR00("Couldn't Auto-Map: " + t.getMessage());
                    ChatLog.announceError(error);
                    logger.severe(error + ": " + LogFormatter.toString(t));
                }
            }
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            if (this.regionLoader != null) {
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("MapOverlay.automap_complete_underground", this.regionLoader.getVSlice());
                } else {
                    ChatLog.announceI18N("MapOverlay.automap_complete", new Object[0]);
                }
            }
            this.enabled = false;
            if (this.regionLoader != null) {
                RegionImageCache.getInstance().flushToDisk();
                RegionImageCache.getInstance().clear();
                this.regionLoader.getRegions().clear();
                this.regionLoader = null;
            }
        }

        @Override
        public BaseMapTask getTask(Minecraft minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (this.regionLoader.getRegions().isEmpty()) {
                this.disableTask(minecraft);
                return null;
            }
            RegionCoord rCoord = this.regionLoader.getRegions().peek();
            BaseMapTask baseMapTask = MapRegionTask.create(rCoord, minecraft);
            return baseMapTask;
        }

        @Override
        public void taskAccepted(boolean accepted) {
            if (accepted) {
                this.regionLoader.getRegions().pop();
                float total = 1.0f * (float)this.regionLoader.getRegionsFound();
                float remaining = total - (float)this.regionLoader.getRegions().size();
                String percent = new DecimalFormat("##.#").format(remaining * 100.0f / total) + "%";
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("MapOverlay.automap_status_underground", this.regionLoader.getVSlice(), percent);
                } else {
                    ChatLog.announceI18N("MapOverlay.automap_status", percent);
                }
            }
        }
    }
}

