/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.ScrollPane;
import org.lwjgl.opengl.GL11;

public class Button
extends GuiButton
implements ScrollPane.Scrollable {
    protected Boolean toggled = true;
    protected String icon;
    protected DynamicTexture iconTexture;
    protected String labelOn;
    protected String labelOff;
    protected static Color smallFrameColorLight = new Color(160, 160, 160);
    protected static Color smallFrameColorDark = new Color(120, 120, 120);
    protected static Color smallBgColor = new Color(100, 100, 100);
    protected static Color smallBgHoverColor = new Color(125, 135, 190);
    protected boolean field_146124_l;
    protected boolean drawButton;
    protected boolean noDisableText;
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean defaultStyle = true;

    public Button(Enum enumValue, String label) {
        this(enumValue.ordinal(), 0, 0, label);
    }

    public Button(int id, String label) {
        this(id, 0, 0, label);
    }

    public Button(Enum enumValue, int width, int height, String label) {
        this(enumValue.ordinal(), width, height, label);
    }

    public Button(Enum enumValue, String labelOn, String labelOff, boolean toggled) {
        this(enumValue.ordinal(), 0, 0, labelOn, labelOff, toggled);
    }

    public Button(int id, String labelOn, String labelOff, boolean toggled) {
        this(id, 0, 0, labelOn, labelOff, toggled);
    }

    public Button(int id, int width, int height, String label) {
        super(id, 0, 0, width, height, label);
        this.finishInit();
    }

    public Button(int id, int width, int height, String labelOn, String labelOff, boolean toggled) {
        super(id, 0, 0, width, height, toggled ? labelOn : labelOff);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.finishInit();
    }

    private void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.field_146121_g == 0) {
            this.field_146121_g = 20;
        }
        if (this.field_146120_f == 0) {
            this.field_146120_f = 200;
        }
    }

    private void updateLabel() {
        if (this.labelOn != null && this.labelOff != null) {
            this.field_146126_j = this.getToggled() != false ? this.labelOn : this.labelOff;
        }
    }

    public void setLabels(String labelOn, String labelOff) {
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.updateLabel();
    }

    public void toggle() {
        this.setToggled(this.getToggled() == false);
    }

    public void setToggled(Boolean toggled) {
        this.toggled = toggled;
        this.updateLabel();
    }

    @Override
    public void setWidth(int width) {
        this.field_146120_f = width;
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.field_146126_j);
        if (this.labelOn != null) {
            max = Math.max(max, fr.func_78256_a(this.labelOn));
        }
        if (this.labelOff != null) {
            max = Math.max(max, fr.func_78256_a(this.labelOff));
        }
        return max + 12;
    }

    public void fitWidth(FontRenderer fr) {
        this.field_146120_f = this.getFitWidth(fr);
    }

    @Override
    public void drawPartialScrollable(Minecraft minecraft, int x, int y, int width, int height) {
        minecraft.func_110434_K().func_110577_a(field_146122_a);
        int k = 0;
        this.func_73729_b(x, y, 0, 46 + k * 20, width / 2, height);
        this.func_73729_b(x + width / 2, y, 200 - width / 2, 46 + k * 20, width / 2, height);
    }

    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isDrawButton()) {
            return;
        }
        if (this.defaultStyle) {
            super.func_146112_a(minecraft, mouseX, mouseY);
        } else {
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(field_146122_a);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, 1.0, smallFrameColorLight, 255);
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i, 1.0, this.field_146121_g, smallFrameColorLight, 255);
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i + this.field_146121_g - 1, this.field_146120_f - 1, 1.0, smallFrameColorDark, 255);
                DrawUtil.drawRectangle(this.field_146128_h + this.field_146120_f - 1, this.field_146129_i + 1, 1.0, this.field_146121_g - 1, smallFrameColorDark, 255);
            }
            if (this.isDrawBackground()) {
                int k = this.func_146114_a(this.field_146123_n);
                DrawUtil.drawRectangle(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146120_f - 2, this.field_146121_g - 2, k == 2 ? smallBgHoverColor : smallBgColor, 255);
            }
            this.func_146119_b(minecraft, mouseX, mouseY);
            int l = 0xE0E0E0;
            if (!this.isEnabled()) {
                l = -6250336;
            } else if (this.field_146123_n) {
                l = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
        }
        if (!this.isEnabled()) {
            int alpha;
            boolean drawDisabledText = this.mouseOver(mouseX, mouseY) && !this.isNoDisableText();
            int n = alpha = drawDisabledText ? 255 : 185;
            if (this.field_146121_g >= 20) {
                DrawUtil.drawRectangle(this.getX() + 1, this.getY() + 1, this.field_146120_f - 3, this.field_146121_g - 2, Color.darkGray, alpha);
                if (drawDisabledText) {
                    this.func_73732_a(minecraft.field_71466_p, Constants.getString("MapOverlay.disabled_feature"), this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, -6250336);
                }
            } else {
                DrawUtil.drawRectangle(this.getX() + 1, this.getY() + 1, this.field_146120_f - 2, this.field_146121_g - 2, Color.darkGray, alpha);
                this.func_73732_a(minecraft.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, Color.darkGray.brighter().getRGB());
            }
        }
    }

    public void drawUnderline() {
        if (this.isDrawButton()) {
            DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i + this.field_146121_g, this.field_146120_f, 1.0, smallFrameColorDark, 255);
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int i, int j) {
        return this.isEnabled() && this.isDrawButton() && i >= this.getX() && j >= this.getY() && i < this.getX() + this.getWidth() && j < this.getY() + this.getHeight();
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX <= this.field_146128_h + this.field_146120_f && mouseY <= this.field_146129_i + this.field_146121_g;
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g;
    }

    public void setHeight(int height) {
        this.field_146121_g = height;
        if (height != 20) {
            this.defaultStyle = false;
        }
    }

    public void setTextOnly(FontRenderer fr) {
        this.setHeight(fr.field_78288_b + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    @Override
    public void drawScrollable(Minecraft mc, int mouseX, int mouseY) {
        this.func_146112_a(mc, mouseX, mouseY);
    }

    @Override
    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public int getX() {
        return this.field_146128_h;
    }

    @Override
    public int getY() {
        return this.field_146129_i;
    }

    public void setX(int x) {
        this.field_146128_h = x;
    }

    public void setY(int y) {
        this.field_146129_i = y;
    }

    public int getCenterX() {
        return this.field_146128_h + this.field_146120_f / 2;
    }

    public int getMiddleY() {
        return this.field_146129_i + this.field_146121_g / 2;
    }

    public int getBottomY() {
        return this.field_146129_i + this.field_146121_g;
    }

    public int getRightX() {
        return this.field_146128_h + this.field_146120_f;
    }

    @Override
    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Button leftOf(int x) {
        this.setX(x - this.getWidth());
        return this;
    }

    public Button rightOf(int x) {
        this.setX(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.setX(x - this.field_146120_f / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.setY(y + this.field_146121_g / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.setX(other.getX() - this.getWidth() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.setX(other.getX() + other.getWidth() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.setY(other.getY() - this.getHeight() - margin);
        return this;
    }

    public Button above(int y) {
        this.setY(y - this.getHeight());
        return this;
    }

    public Button below(Button other, int margin) {
        this.setY(other.getY() + other.getHeight() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.setY(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.setY(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.getX();
        int y = this.getY();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.getX() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.getY() - vgap - this.getHeight();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.getHeight() / 2;
            }
        }
        this.setX(x);
        this.setY(y);
        return this;
    }

    public boolean isEnabled() {
        return this.field_146124_l;
    }

    public void setEnabled(boolean enabled) {
        this.field_146124_l = enabled;
    }

    public boolean isDrawButton() {
        return this.drawButton;
    }

    public void setDrawButton(boolean drawButton) {
        this.drawButton = drawButton;
    }

    public boolean isNoDisableText() {
        return this.noDisableText;
    }

    public void setNoDisableText(boolean noDisableText) {
        this.noDisableText = noDisableText;
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }
}

