/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.Button;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScrollPane
extends GuiSlot {
    private Color frameColor = new Color(-6250336);
    private List<? extends Scrollable> items;
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    protected Scrollable selected = null;
    private boolean showFrame = true;
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    private int firstVisibleIndex;
    private int lastVisibleIndex;

    public ScrollPane(Minecraft mc, int width, int height, List<? extends Scrollable> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, height, itemHeight + itemGap);
        this.items = items;
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int func_148146_j() {
        return this.field_148149_f;
    }

    public void position(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.func_148122_a(width, height, marginTop, height - marginBottom);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int func_148127_b() {
        return this.items.size();
    }

    protected void func_148144_a(int i, boolean flag, int p1, int p2) {
        this.selected = this.items.get(i);
    }

    protected boolean func_148131_a(int i) {
        return this.items.get(i) == this.selected;
    }

    public boolean isSelected(Scrollable item) {
        return item == this.selected;
    }

    public void select(Scrollable item) {
        this.selected = item;
    }

    protected void func_148123_a() {
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            ArrayList<? extends Scrollable> itemsCopy = new ArrayList<Scrollable>(this.items);
            for (Scrollable scrollable : itemsCopy) {
                if (scrollable == null || !this.inFullView(scrollable)) continue;
                if (scrollable instanceof Button) {
                    Button button = (Button)scrollable;
                    if (!button.func_146116_c(this.mc, mouseX, mouseY)) continue;
                    this.func_148147_a(button);
                    return button;
                }
                scrollable.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public void func_148128_a(int mX, int mY, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.getX(), (double)this.getY(), (double)0.0);
        this._mouseX = mX;
        this._mouseY = mY;
        if (this.selected == null || Mouse.isButtonDown((int)0) || Mouse.getDWheel() != 0 || !Mouse.next() || Mouse.getEventButtonState()) {
            // empty if block
        }
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.func_148128_a(mX - this.getX(), mY - this.getY(), f);
        GL11.glPopMatrix();
    }

    protected void func_148126_a(int index, int xPosition, int yPosition, int l, Tessellator tessellator, int var6, int var7) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.getX()), (double)(-this.getY()), (double)0.0);
        int margin = 4;
        int itemX = this.getX() + 2;
        int itemY = yPosition + this.getY();
        Scrollable item = this.items.get(index);
        item.setPosition(itemX, itemY);
        item.setWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(this.mc, this._mouseX, this._mouseY);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = itemY + item.getHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (itemY < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - itemY;
            } else if (itemY < paneBottomY && itemBottomY > paneBottomY) {
                drawY = itemY;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null) {
                item.drawPartialScrollable(this.mc, itemX, drawY, item.getWidth(), item.getHeight() - yDiff);
            }
        }
        GL11.glPopMatrix();
    }

    public boolean inFullView(Scrollable item) {
        return item.getY() >= this.getY() && item.getY() + item.getHeight() <= this.getY() + this.paneHeight;
    }

    protected int func_148137_d() {
        return this.paneWidth;
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.func_148148_g();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(FontRenderer fr) {
        int fit = 0;
        for (Scrollable scrollable : this.items) {
            fit = Math.max(fit, scrollable.getFitWidth(fr));
        }
        return fit;
    }

    public void setShowFrame(boolean showFrame) {
        this.showFrame = showFrame;
    }

    protected void drawContainerBackground(Tessellator tess) {
        int width = this.getWidth();
        int alpha = 100;
        DrawUtil.drawRectangle(0.0, this.field_148153_b, width, this.paneHeight, Color.BLACK, alpha);
        DrawUtil.drawRectangle(width - 6, this.field_148153_b, 5.0, this.paneHeight, Color.BLACK, alpha);
        if (this.showFrame) {
            alpha = 255;
            DrawUtil.drawRectangle(-1.0, -1.0, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(-1.0, this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(-1.0, -1.0, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(width + 1, -1.0, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public int getFirstVisibleIndex() {
        return this.firstVisibleIndex;
    }

    public int getLastVisibleIndex() {
        return this.lastVisibleIndex;
    }

    public static interface Scrollable {
        public void setPosition(int var1, int var2);

        public void setWidth(int var1);

        public int getX();

        public int getY();

        public int getWidth();

        public int getFitWidth(FontRenderer var1);

        public int getHeight();

        public void drawScrollable(Minecraft var1, int var2, int var3);

        public void drawPartialScrollable(Minecraft var1, int var2, int var3, int var4, int var5);

        public void clickScrollable(Minecraft var1, int var2, int var3);
    }
}

