/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.properties.FullMapProperties;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.BooleanPropertyButton;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.ButtonList;
import net.techbrew.journeymap.ui.JmUI;

public class GeneralDisplayOptions
extends JmUI {
    Button buttonCaves;
    Button buttonGrid;
    Button buttonClose;
    String labelOn = Constants.getString("MapOverlay.on");
    String labelOff = Constants.getString("MapOverlay.off");
    String labelFullMap = Constants.getString("MapOverlay.title");
    String labelMiniMap = Constants.getString("MiniMap.title");
    ArrayList<ButtonList> leftRows = new ArrayList();
    ArrayList<ButtonList> rightRows = new ArrayList();
    ButtonList rowMobs;
    ButtonList rowAnimals;
    ButtonList rowVillagers;
    ButtonList rowPets;
    ButtonList rowGrid;
    ButtonList rowCaves;
    ButtonList rowSelf;
    ButtonList rowPlayers;
    ButtonList rowWaypoints;
    ButtonList rowFontSize;
    ButtonList rowForceUnicode;
    ButtonList rowTextureSize;

    public GeneralDisplayOptions(Class<? extends JmUI> returnClass) {
        super(Constants.getString("MapOverlay.general_display_title"), returnClass);
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.leftRows.clear();
        this.rightRows.clear();
        int id = 0;
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        FullMapProperties fullMap = JourneyMap.getInstance().fullMapProperties;
        MiniMapProperties miniMap = JourneyMap.getInstance().miniMapProperties;
        this.rowMobs = new ButtonList(Constants.getString("MapOverlay.show_monsters", ""));
        this.rowMobs.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showMobs));
        this.rowMobs.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showMobs));
        this.rowMobs.setEnabled(FeatureManager.isAllowed(Feature.RadarMobs));
        this.leftRows.add(this.rowMobs);
        this.rowAnimals = new ButtonList(Constants.getString("MapOverlay.show_animals", ""));
        this.rowAnimals.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showAnimals));
        this.rowAnimals.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showAnimals));
        this.rowAnimals.setEnabled(FeatureManager.isAllowed(Feature.RadarAnimals));
        this.leftRows.add(this.rowAnimals);
        this.rowVillagers = new ButtonList(Constants.getString("MapOverlay.show_villagers", ""));
        this.rowVillagers.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showVillagers));
        this.rowVillagers.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showVillagers));
        this.rowVillagers.setEnabled(FeatureManager.isAllowed(Feature.RadarVillagers));
        this.leftRows.add(this.rowVillagers);
        this.rowPets = new ButtonList(Constants.getString("MapOverlay.show_pets", ""));
        this.rowPets.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showPets));
        this.rowPets.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showPets));
        this.rowPets.setEnabled(FeatureManager.isAllowed(Feature.RadarAnimals));
        this.leftRows.add(this.rowPets);
        this.buttonCaves = BooleanPropertyButton.create(id++, fullMap, fullMap.showCaves);
        this.buttonCaves.setEnabled(FeatureManager.isAllowed(Feature.RadarPlayers));
        this.rowCaves = new ButtonList(Constants.getString("MapOverlay.show_caves", ""));
        this.rowCaves.add(this.buttonCaves);
        this.leftRows.add(this.rowCaves);
        this.buttonGrid = BooleanPropertyButton.create(id++, fullMap, fullMap.showGrid);
        this.rowGrid = new ButtonList(Constants.getString("MapOverlay.show_grid", ""));
        this.rowGrid.add(this.buttonGrid);
        this.leftRows.add(this.rowGrid);
        this.rowSelf = new ButtonList(Constants.getString("MapOverlay.show_self", ""));
        this.rowSelf.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showSelf));
        this.rowSelf.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showSelf));
        this.rightRows.add(this.rowSelf);
        this.rowPlayers = new ButtonList(Constants.getString("MapOverlay.show_players", ""));
        this.rowPlayers.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showPlayers));
        this.rowPlayers.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showPlayers));
        this.rowPlayers.setEnabled(FeatureManager.isAllowed(Feature.RadarPlayers));
        this.rightRows.add(this.rowPlayers);
        this.rowWaypoints = new ButtonList(Constants.getString("MapOverlay.show_waypoints", ""));
        this.rowWaypoints.add(BooleanPropertyButton.create(id++, fullMap, fullMap.showWaypoints));
        this.rowWaypoints.add(BooleanPropertyButton.create(id++, miniMap, miniMap.showWaypoints));
        this.rowWaypoints.setEnabled(JourneyMap.getInstance().waypointProperties.managerEnabled.get());
        this.rightRows.add(this.rowWaypoints);
        this.rowForceUnicode = new ButtonList(Constants.getString("MiniMap.force_unicode", ""));
        this.rowForceUnicode.add(BooleanPropertyButton.create(id++, fullMap, fullMap.forceUnicode));
        this.rowForceUnicode.add(BooleanPropertyButton.create(id++, miniMap, miniMap.forceUnicode));
        this.rightRows.add(this.rowForceUnicode);
        this.rowFontSize = new ButtonList(Constants.getString("MiniMap.font", ""));
        this.rowFontSize.add(BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, (PropertiesBase)fullMap, fullMap.fontSmall));
        this.rowFontSize.add(BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, (PropertiesBase)miniMap, miniMap.fontSmall));
        this.rightRows.add(this.rowFontSize);
        this.rowTextureSize = new ButtonList(Constants.getString("MiniMap.texture_size", ""));
        this.rowTextureSize.add(BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, (PropertiesBase)fullMap, fullMap.textureSmall));
        this.rowTextureSize.add(BooleanPropertyButton.create(id++, BooleanPropertyButton.Type.SmallLarge, (PropertiesBase)miniMap, miniMap.textureSmall));
        this.rightRows.add(this.rowTextureSize);
        int commonWidth = this.getFontRenderer().func_78256_a(this.labelOn);
        commonWidth = Math.max(commonWidth, this.getFontRenderer().func_78256_a(this.labelOff));
        commonWidth = Math.max(commonWidth, this.getFontRenderer().func_78256_a(this.labelFullMap));
        commonWidth = Math.max(commonWidth, this.getFontRenderer().func_78256_a(this.labelMiniMap));
        commonWidth += 4;
        for (ButtonList ButtonList2 : this.leftRows) {
            ButtonList2.setWidths(commonWidth);
            this.field_146292_n.addAll(ButtonList2);
        }
        for (ButtonList ButtonList2 : this.rightRows) {
            ButtonList2.setWidths(commonWidth);
            this.field_146292_n.addAll(ButtonList2);
        }
        this.rowCaves.setWidths(this.rowAnimals.getWidth(4));
        this.rowGrid.setWidths(this.rowAnimals.getWidth(4));
        this.buttonClose = new Button(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.buttonClose.fitWidth(this.getFontRenderer());
        if (this.buttonClose.getWidth() < 150) {
            this.buttonClose.setWidth(150);
        }
        this.field_146292_n.add(this.buttonClose);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 4;
        int vgap = 3;
        int rowWidth = 10 + this.leftRows.get(0).getWidth(4) * 2;
        int bx = (this.field_146294_l - rowWidth) / 2;
        int by = Math.max(50, (this.field_146295_m - 140) / 2);
        int leftX = this.field_146294_l;
        int rightX = 0;
        int topY = by - 20;
        int bottomY = 0;
        ButtonList lastRow = null;
        for (ButtonList row : this.leftRows) {
            if (lastRow == null) {
                row.layoutHorizontal(bx, by, true, 4);
            } else {
                row.layoutHorizontal(bx, lastRow.getBottomY() + 3, true, 4);
            }
            lastRow = row;
            DrawUtil.drawLabel(row.getLabel(), row.getLeftX() - 4, lastRow.getTopY() + 3, DrawUtil.HAlign.Left, DrawUtil.VAlign.Below, Color.black, 0, Color.cyan, 255, 1.0, true);
            leftX = Math.min(leftX, row.getLeftX() - 4 - this.getFontRenderer().func_78256_a(row.getLabel()));
            bottomY = Math.max(bottomY, row.getBottomY());
        }
        DrawUtil.drawCenteredLabel(this.labelFullMap, ((Button)this.leftRows.get(0).get(0)).getCenterX(), by - 10, Color.black, 0, Color.white, 255, 1.0);
        DrawUtil.drawCenteredLabel(this.labelMiniMap, ((Button)this.leftRows.get(0).get(1)).getCenterX(), by - 10, Color.black, 0, Color.white, 255, 1.0);
        lastRow = null;
        bx = (this.field_146294_l + rowWidth) / 2;
        for (ButtonList row : this.rightRows) {
            if (lastRow == null) {
                row.layoutHorizontal(bx, by, true, 4);
            } else {
                row.layoutHorizontal(bx, lastRow.getBottomY() + 3, true, 4);
            }
            lastRow = row;
            DrawUtil.drawLabel(row.getLabel(), row.getLeftX() - 4, lastRow.getTopY() + 3, DrawUtil.HAlign.Left, DrawUtil.VAlign.Below, Color.black, 0, Color.cyan, 255, 1.0, true);
            rightX = Math.max(rightX, row.getRightX());
            bottomY = Math.max(bottomY, row.getBottomY());
        }
        DrawUtil.drawCenteredLabel(this.labelFullMap, ((Button)this.rightRows.get(0).get(0)).getCenterX(), by - 10, Color.black, 0, Color.white, 255, 1.0);
        DrawUtil.drawCenteredLabel(this.labelMiniMap, ((Button)this.rightRows.get(0).get(1)).getCenterX(), by - 10, Color.black, 0, Color.white, 255, 1.0);
        DrawUtil.drawRectangle(leftX -= 5, topY -= 5, (rightX += 5) - leftX, 1.0, Color.lightGray, 150);
        DrawUtil.drawRectangle(leftX, bottomY += 10, rightX - leftX, 1.0, Color.lightGray, 150);
        if (rightX - leftX > this.field_146294_l) {
            int commonWidth = ((Button)this.leftRows.get(0).get(0)).getWidth() - 4;
            for (ButtonList ButtonList2 : this.leftRows) {
                ButtonList2.setWidths(commonWidth);
            }
            for (ButtonList ButtonList2 : this.rightRows) {
                ButtonList2.setWidths(commonWidth);
            }
            this.rowCaves.setWidths(this.rowAnimals.getWidth(4));
            this.rowGrid.setWidths(this.rowAnimals.getWidth(4));
        }
        int closeY = Math.min(this.field_146295_m - 3 - this.buttonClose.getHeight(), bottomY + 12);
        this.buttonClose.centerHorizontalOn(this.field_146294_l / 2).setY(closeY);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof BooleanPropertyButton) {
            ((BooleanPropertyButton)button).toggle();
            return;
        }
        if (button == this.buttonClose) {
            this.closeAndReturn();
        }
    }

    private static enum ButtonEnum {
        Caves,
        Grid,
        Close;

    }
}

