/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import se.rupy.http.Chain;
import se.rupy.http.Daemon;
import se.rupy.http.Event;
import se.rupy.http.Hash;
import se.rupy.http.Service;

public class Session
extends Hash {
    private Daemon daemon;
    private Chain service;
    private Chain event;
    private boolean set;
    private String key;
    private String domain;
    private long date;
    private long expires;

    protected Session(Daemon daemon) {
        this.daemon = daemon;
        this.service = new Chain();
        this.event = new Chain();
        this.touch();
    }

    protected synchronized void add(Service service) {
        if (!this.service.contains(service)) {
            this.service.add(service);
        }
    }

    protected void add(Event event) {
        if (!this.event.contains(event)) {
            this.event.add(event);
        }
    }

    public Chain event() {
        return this.event;
    }

    protected Daemon daemon() {
        return this.daemon;
    }

    protected void remove() throws Exception {
        this.remove(null);
    }

    protected synchronized boolean remove(Event event) throws Exception {
        if (event == null) {
            this.event.clear();
            this.service.exit(this, 2);
            return true;
        }
        boolean found = this.event.remove(event);
        if (this.event.isEmpty() && found) {
            this.service.exit(this, 3);
            return true;
        }
        return false;
    }

    public boolean set() {
        return this.set;
    }

    public void set(boolean set) {
        this.set = set;
    }

    protected long expires() {
        return this.expires;
    }

    protected void expires(long expires) {
        this.expires = expires;
    }

    public String key() {
        return this.key;
    }

    protected void key(String key) {
        this.key = key;
        this.set = false;
    }

    public String domain() {
        return this.domain;
    }

    public void key(String key, String domain, long expires) {
        if (key == null) {
            return;
        }
        this.daemon.session().remove(this.key);
        this.key = key;
        this.daemon.session().put(key, this);
        this.domain = domain;
        this.expires = expires;
        this.set = false;
    }

    public long date() {
        return this.date;
    }

    protected void touch() {
        this.date = System.currentTimeMillis();
    }

    @Override
    public String toString() {
        return this.key;
    }
}

