/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.helper.impl;

import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.HashSet;
import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class ColorHelper_1_8
implements IColorHelper {
    private volatile BufferedImage blocksTexture;
    Logger logger = Journeymap.getLogger();
    HashSet<BlockMD> failed = new HashSet();

    @Override
    public boolean hasBlocksTexture() {
        return this.blocksTexture != null;
    }

    @Override
    public boolean clearBlocksTexture() {
        if (this.blocksTexture == null) {
            return false;
        }
        this.blocksTexture = null;
        return true;
    }

    @Override
    public boolean failedFor(BlockMD blockMD) {
        return this.failed.contains(blockMD);
    }

    @Override
    public int getColorMultiplier(ChunkMD chunkMD, Block block, int x, int y, int z) {
        if (chunkMD == null) {
            return block.func_176202_d(ForgeHelper.INSTANCE.getIBlockAccess(), new BlockPos(x, y, z));
        }
        return block.func_176202_d((IBlockAccess)chunkMD.getWorld(), new BlockPos(x, y, z));
    }

    @Override
    @Deprecated
    public int getRenderColor(BlockMD blockMD) {
        Block block = blockMD.getBlock();
        IBlockState blockState = block.func_176203_a(blockMD.getMeta());
        return block.func_180644_h(blockState);
    }

    @Override
    public int getMapColor(BlockMD blockMD) {
        IBlockState blockState;
        Block block = blockMD.getBlock();
        MapColor mapColor = block.func_180659_g(blockState = block.func_176203_a(blockMD.getMeta()));
        if (mapColor != null) {
            return mapColor.field_76291_p;
        }
        return 0;
    }

    @Override
    public Integer getTextureColor(BlockMD blockMD) {
        boolean ok;
        Integer color = null;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        try {
            TextureAtlasSprite blockIcon = this.getDirectIcon(blockMD);
            if (blockIcon == null && blockMD.getBlock() instanceof ITileEntityProvider) {
                this.logger.debug("Ignoring TitleEntity without standard block texture: " + blockMD);
                blockMD.addFlags(BlockMD.Flag.TileEntity, BlockMD.Flag.HasAir);
                return null;
            }
            if (blockIcon == null) {
                blockMD.addFlags(BlockMD.Flag.Error);
                this.failed.add(blockMD);
                return null;
            }
            color = this.getColorForIcon(blockMD, blockIcon);
            if (color == null) {
                this.failed.add(blockMD);
                return null;
            }
            return color;
        }
        catch (Throwable t) {
            this.failed.add(blockMD);
            if (blockMD.getUid().modId.equals("minecraft")) {
                this.logger.warn("Error getting block color. Plese report this exception to the JourneyMap mod author regarding " + blockMD.getUid() + ": " + LogFormatter.toPartialString(t));
            } else {
                this.logger.warn("Error getting block color from mod. Plese report this exception to the mod author of " + blockMD.getUid() + ": " + LogFormatter.toPartialString(t));
            }
            return null;
        }
    }

    private TextureAtlasSprite getDirectIcon(BlockMD blockMD) {
        boolean ok;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        Block block = blockMD.getBlock();
        Integer overrideMeta = null;
        if (blockMD.hasOverrideMeta()) {
            overrideMeta = blockMD.getOverrideMeta();
        }
        int meta = overrideMeta != null ? overrideMeta.intValue() : blockMD.getMeta();
        IBlockState state = blockMD.getBlock().func_176203_a(meta);
        if (block instanceof BlockDoublePlant && ((BlockDoublePlant.EnumBlockHalf)state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).toString().equals("lower")) {
            state = state.func_177231_a((IProperty)BlockDoublePlant.field_176492_b);
        }
        TextureAtlasSprite icon = ForgeHelper.INSTANCE.getClient().func_175602_ab().func_175023_a().func_178122_a(state);
        return icon;
    }

    Integer getColorForIcon(BlockMD blockMD, TextureAtlasSprite icon) {
        boolean ok;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        Integer color = null;
        try {
            int count = 0;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int x = 0;
            int y = 0;
            if (icon.func_94211_a() + icon.func_130010_a() > this.blocksTexture.getWidth() || icon.func_94216_b() + icon.func_110967_i() > this.blocksTexture.getHeight()) {
                this.logger.warn("Couldn't get texture for " + icon.func_94215_i() + " because of an error matching it within the stitched blocks atlas.");
                return null;
            }
            BufferedImage textureImg = this.blocksTexture.getSubimage(icon.func_130010_a(), icon.func_110967_i(), icon.func_94211_a(), icon.func_94216_b());
            int yStart = 0;
            int xStart = 0;
            int xStop = textureImg.getWidth();
            int yStop = textureImg.getHeight();
            boolean unusable = true;
            if (textureImg != null && textureImg.getWidth() > 0) {
                block5: for (x = xStart; x < xStop; ++x) {
                    for (y = yStart; y < yStop; ++y) {
                        int argb;
                        try {
                            argb = textureImg.getRGB(x, y);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.logger.warn("Bad index at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            continue;
                        }
                        catch (Throwable e) {
                            this.logger.warn("Couldn't get RGB from BlocksTexture at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            break block5;
                        }
                        int alpha = argb >> 24 & 0xFF;
                        if (alpha <= 0) continue;
                        ++count;
                        a += alpha;
                        r += argb >> 16 & 0xFF;
                        g += argb >> 8 & 0xFF;
                        b += argb & 0xFF;
                    }
                }
                if (count > 0) {
                    unusable = false;
                    if (a > 0) {
                        a /= count;
                    }
                    if (r > 0) {
                        r /= count;
                    }
                    if (g > 0) {
                        g /= count;
                    }
                    if (b > 0) {
                        b /= count;
                    }
                }
            } else {
                this.logger.warn("Couldn't get texture for " + icon.func_94215_i() + " using blockid ");
            }
            if (unusable) {
                blockMD.addFlags(BlockMD.Flag.Error);
                String pattern = "Unusable texture for %s, icon=%s,texture coords %s,%s - %s,%s";
                this.logger.debug(String.format(pattern, blockMD, icon.func_94215_i(), xStart, yStart, xStop, yStop));
                b = 0;
                g = 0;
                r = 0;
            }
            color = RGB.toInteger(r, g, b);
            Block block = blockMD.getBlock();
            float blockAlpha = 1.0f;
            if (unusable) {
                blockAlpha = 0.0f;
            } else if (blockMD.hasFlag(BlockMD.Flag.Transparency)) {
                blockAlpha = blockMD.getAlpha();
            } else if (block.func_149645_b() > 0) {
                if (block.func_149751_l()) {
                    blockAlpha = (float)block.func_149717_k() / 255.0f;
                }
                if (blockAlpha == 0.0f || blockAlpha == 1.0f) {
                    blockAlpha = (float)a * 1.0f / 255.0f;
                }
            }
            blockMD.setAlpha(blockAlpha);
            blockMD.setIconName(icon.func_94215_i());
        }
        catch (Throwable e1) {
            this.logger.warn("Error deriving color for " + blockMD + ": " + LogFormatter.toString(e1));
        }
        if (color != null && this.logger.isTraceEnabled()) {
            this.logger.debug("Derived color for " + blockMD + ": " + Integer.toHexString(color));
        }
        return color;
    }

    @Override
    public boolean initBlocksTexture() {
        StatTimer timer = StatTimer.get("ColorHelper.initBlocksTexture", 0);
        try {
            if (!Display.isCurrent()) {
                return false;
            }
            this.blocksTexture = null;
            timer.start();
            int blocksTexId = ForgeHelper.INSTANCE.getClient().func_147117_R().func_110552_b();
            ForgeHelper.INSTANCE.getRenderHelper().glBindTexture(blocksTexId);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            int miplevel = 0;
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)miplevel, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)miplevel, (int)4097);
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)(width * height));
            int[] aint = new int[width * height];
            GL11.glGetTexImage((int)3553, (int)miplevel, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(aint);
            BufferedImage bufferedimage = new BufferedImage(width, height, 2);
            bufferedimage.setRGB(0, 0, width, height, aint, 0, width);
            this.blocksTexture = bufferedimage;
            double time = timer.stop();
            Journeymap.getLogger().info(String.format("initBlocksTexture: %sx%s loaded in %sms", width, height, time));
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Could not load blocksTexture :" + t);
            timer.cancel();
            return false;
        }
    }
}

