/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.client.model.mod.vanilla.VanillaColorHandler;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockMD {
    public static final EnumSet FlagsPlantAndCrop = EnumSet.of(Flag.Plant, Flag.Crop);
    public static final EnumSet FlagsBiomeColored = EnumSet.of(Flag.Grass, Flag.Foliage, Flag.Water, Flag.CustomBiomeColor);
    private static final Map<Block, Map<Integer, BlockMD>> cache = new HashMap<Block, Map<Integer, BlockMD>>();
    public static BlockMD AIRBLOCK;
    public static BlockMD VOIDBLOCK;
    private static ModBlockDelegate modBlockDelegate;
    private final Block block;
    private final int meta;
    private final GameRegistry.UniqueIdentifier uid;
    private final String name;
    private EnumSet<Flag> flags;
    private int textureSide;
    private Integer overrideMeta;
    private Integer color;
    private float alpha;
    private String iconName;
    private ModBlockDelegate.IModBlockColorHandler blockColorHandler;
    private ModBlockDelegate.IModBlockHandler modBlockHandler;

    private BlockMD(Block block, int meta) {
        this(block, meta, GameRegistry.findUniqueIdentifierFor((Block)block), BlockMD.getBlockName(block, meta), Float.valueOf(1.0f), 1, EnumSet.noneOf(Flag.class));
    }

    private BlockMD(Block block, int meta, GameRegistry.UniqueIdentifier uid, String name, Float alpha, int textureSide, EnumSet<Flag> flags) {
        this.block = block;
        this.meta = meta;
        this.uid = uid;
        this.name = name;
        this.alpha = alpha.floatValue();
        this.textureSide = textureSide;
        this.flags = flags;
        this.blockColorHandler = VanillaColorHandler.INSTANCE;
        if (block != null) {
            modBlockDelegate.initialize(this);
        }
    }

    public static void reset() {
        StatTimer timer = StatTimer.get("BlockMD.reset", 0, 2000);
        timer.start();
        cache.clear();
        modBlockDelegate = new ModBlockDelegate();
        AIRBLOCK = new BlockMD(Blocks.field_150350_a, 0, new GameRegistry.UniqueIdentifier("minecraft:air"), "Air", Float.valueOf(0.0f), 1, EnumSet.of(Flag.HasAir));
        VOIDBLOCK = new BlockMD(null, 0, new GameRegistry.UniqueIdentifier("journeymap:void"), "Void", Float.valueOf(0.0f), 1, EnumSet.noneOf(Flag.class));
        Collection<BlockMD> all = BlockMD.getAll();
        VanillaColorHandler.INSTANCE.setExplicitColors();
        timer.stop();
        Journeymap.getLogger().info(String.format("Built BlockMD cache (%s) : %s", all.size(), timer.getLogReportString()));
    }

    public static Collection<BlockMD> getAll() {
        ArrayList<BlockMD> allBlockMDs = new ArrayList<BlockMD>(512);
        for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
            Collection<Integer> metas = BlockMD.getMetaValuesForBlock(block);
            for (int meta : metas) {
                allBlockMDs.add(BlockMD.get(block, meta, metas.size()));
            }
        }
        return allBlockMDs;
    }

    public static BlockMD getBlockMD(ChunkMD chunkMd, int localX, int y, int localZ) {
        try {
            if (y >= 0) {
                BlockMD delegated;
                Block block = chunkMd.getBlock(localX, y, localZ);
                if (block instanceof BlockAir) {
                    return AIRBLOCK;
                }
                int meta = chunkMd.getBlockMeta(localX, y, localZ);
                BlockMD blockMD = BlockMD.get(block, meta);
                if (blockMD.hasFlag(Flag.SpecialHandling) && (delegated = ModBlockDelegate.handleBlock(chunkMd, blockMD, localX, y, localZ)) != null) {
                    blockMD = delegated;
                }
                return blockMD;
            }
            return VOIDBLOCK;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't get blockId/meta for chunk %s,%s block %s,%s,%s : %s", chunkMd.getChunk().field_76635_g, chunkMd.getChunk().field_76647_h, localX, y, localZ, LogFormatter.toString(e)));
            return AIRBLOCK;
        }
    }

    public static BlockMD get(Block block, int meta) {
        return BlockMD.get(block, meta, null);
    }

    private static BlockMD get(Block block, int meta, Integer subBlocks) {
        try {
            BlockMD blockMD;
            if (block == null) {
                return AIRBLOCK;
            }
            Map<Integer, BlockMD> map = cache.get(block);
            if (map == null) {
                if (subBlocks == null) {
                    subBlocks = BlockMD.getMetaValuesForBlock(block).size();
                }
                int size = (int)Math.ceil((double)Math.max(1, subBlocks) * 1.25);
                map = new HashMap<Integer, BlockMD>(size + size / 2);
                cache.put(block, map);
            }
            if ((blockMD = map.get(meta)) == null) {
                GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Block)block);
                if (uid == null) {
                    Journeymap.getLogger().warn(String.format("Can't find UID for block %s", block));
                    return AIRBLOCK;
                }
                blockMD = new BlockMD(block, meta);
                map.put(meta, blockMD);
            }
            return blockMD;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't get blockId/meta for block %s meta %s : %s", block, meta, LogFormatter.toString(e)));
            return AIRBLOCK;
        }
    }

    public static void debug() {
        for (BlockMD blockMD : BlockMD.getAll()) {
            Journeymap.getLogger().info((Object)blockMD);
        }
    }

    private static String getBlockName(Block block, int meta) {
        String name = null;
        try {
            name = ForgeHelper.INSTANCE.getBlockName(block, meta);
            if (name == null) {
                name = block.func_149739_a().replaceAll("tile.", "").replaceAll("Block", "");
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().debug("Displayname not available for " + name);
        }
        if (Strings.isNullOrEmpty((String)name)) {
            name = block.getClass().getSimpleName().replaceAll("Block", "");
        }
        return name;
    }

    public static Collection<Integer> getMetaValuesForBlock(Block block) {
        ArrayList<Integer> metas = new ArrayList<Integer>();
        ArrayList subBlocks = new ArrayList();
        try {
            Item item = Item.func_150898_a((Block)block);
            if (item == null) {
                metas.add(0);
            } else {
                block.func_149666_a(item, null, subBlocks);
                for (ItemStack subBlockStack : subBlocks) {
                    metas.add(subBlockStack.func_77960_j());
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Couldn't get subblocks for block " + block + ": " + e);
        }
        return metas;
    }

    public static Collection<BlockMD> getAllBlockMDs(Block block) {
        if (cache.isEmpty()) {
            BlockMD.reset();
        }
        Collection<Integer> metas = BlockMD.getMetaValuesForBlock(block);
        ArrayList<BlockMD> list = new ArrayList<BlockMD>(metas.size());
        for (int meta : metas) {
            list.add(BlockMD.get(block, meta));
        }
        return list;
    }

    public static void setAllFlags(Block block, Flag ... flags) {
        for (BlockMD blockMD : BlockMD.getAllBlockMDs(block)) {
            blockMD.addFlags(flags);
        }
        Journeymap.getLogger().debug(block.func_149739_a() + " flags set: " + flags);
    }

    public static void setAllAlpha(Block block, Float alpha) {
        for (BlockMD blockMD : BlockMD.getAllBlockMDs(block)) {
            blockMD.setAlpha(alpha.floatValue());
        }
        Journeymap.getLogger().debug(block.func_149739_a() + " alpha set: " + alpha);
    }

    public static void setTextureSide(Block block, int side) {
        for (BlockMD blockMD : BlockMD.getAllBlockMDs(block)) {
            blockMD.setTextureSide(side);
        }
    }

    public boolean hasFlag(Flag checkFlag) {
        return this.flags.contains((Object)checkFlag);
    }

    public boolean hasAnyFlag(EnumSet<Flag> checkFlags) {
        for (Flag flag : checkFlags) {
            if (!this.flags.contains((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public void addFlags(Flag ... addFlags) {
        Collections.addAll(this.flags, addFlags);
    }

    public void addFlags(Collection<Flag> addFlags) {
        this.flags.addAll(addFlags);
    }

    public void clearFlags() {
        this.flags.clear();
    }

    public int getColor(ChunkMD chunkMD, int globalX, int y, int globalZ) {
        return this.blockColorHandler.getBlockColor(chunkMD, this, globalX, y, globalZ);
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer baseColor) {
        this.color = baseColor;
    }

    public boolean ensureColor() {
        if (this.color == null) {
            this.color = this.blockColorHandler.getTextureColor(this);
            return true;
        }
        return false;
    }

    public void setBlockColorHandler(ModBlockDelegate.IModBlockColorHandler blockColorHandler) {
        this.blockColorHandler = blockColorHandler;
    }

    public String getIconName() {
        return this.iconName == null ? "" : this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(Flag.Transparency);
        } else if (this.hasFlag(Flag.Transparency)) {
            this.flags.remove((Object)Flag.Transparency);
        }
    }

    public boolean hasNoShadow() {
        if (this.hasFlag(Flag.NoShadow)) {
            return true;
        }
        return this.hasAnyFlag(FlagsPlantAndCrop) && !JourneymapClient.getCoreProperties().mapPlantShadows.get();
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean hasTranparency() {
        return this.hasFlag(Flag.Transparency);
    }

    public boolean isAir() {
        return this.block instanceof BlockAir || this.hasFlag(Flag.HasAir);
    }

    public boolean isIce() {
        return this.block == Blocks.field_150432_aD;
    }

    public boolean isTorch() {
        return this.block == Blocks.field_150478_aa || this.block == Blocks.field_150429_aA || this.block == Blocks.field_150437_az;
    }

    public boolean isWater() {
        return this.hasFlag(Flag.Water);
    }

    public boolean isTransparentRoof() {
        return this.hasFlag(Flag.TransparentRoof);
    }

    public boolean isLava() {
        return this.block == Blocks.field_150353_l || this.block == Blocks.field_150356_k;
    }

    public boolean isFoliage() {
        return this.hasFlag(Flag.Foliage);
    }

    public boolean isGrass() {
        return this.hasFlag(Flag.Grass);
    }

    public String getName() {
        return this.name;
    }

    public GameRegistry.UniqueIdentifier getUid() {
        return this.uid;
    }

    public int getMeta() {
        return this.meta;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public boolean hasOverrideMeta() {
        return this.overrideMeta != null;
    }

    public boolean isBiomeColored() {
        return this.hasAnyFlag(FlagsBiomeColored);
    }

    public int getTextureSide() {
        return this.textureSide;
    }

    public void setTextureSide(int textureSide) {
        this.textureSide = textureSide;
    }

    public Integer getOverrideMeta() {
        return this.overrideMeta;
    }

    public void setOverrideMeta(Integer overrideMeta) {
        this.overrideMeta = overrideMeta;
    }

    public ModBlockDelegate.IModBlockHandler getModBlockHandler() {
        return this.modBlockHandler;
    }

    public void setModBlockHandler(ModBlockDelegate.IModBlockHandler modBlockHandler) {
        this.modBlockHandler = modBlockHandler;
        if (modBlockHandler == null) {
            this.flags.remove((Object)Flag.SpecialHandling);
        } else {
            this.flags.add(Flag.SpecialHandling);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMD blockMD = (BlockMD)o;
        if (this.meta != blockMD.meta) {
            return false;
        }
        return this.uid.equals((Object)blockMD.uid);
    }

    public int hashCode() {
        int result = this.uid.hashCode();
        result = 31 * result + this.meta;
        return result;
    }

    public String toString() {
        return String.format("BlockMD [%s:%s:%s] (%s)", this.uid.modId, this.uid.name, this.meta, Joiner.on((String)",").join(this.flags));
    }

    static {
        modBlockDelegate = new ModBlockDelegate();
    }

    public static enum Flag {
        HasAir,
        CustomBiomeColor,
        Foliage,
        Grass,
        Water,
        OpenToSky,
        NoShadow,
        Transparency,
        Error,
        TransparentRoof,
        Plant,
        Crop,
        TileEntity,
        SpecialHandling,
        NoTopo;

    }
}

