/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.JMLogger;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFacade;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;

public class EntityHelper {
    public static EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    public static EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static EntityMapComparator entityMapComparator = new EntityMapComparator();

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        Minecraft mc = ForgeHelper.INSTANCE.getClient();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList(mc.field_71441_e.field_72996_f);
        AxisAlignedBB bb = EntityHelper.getBB(mc.field_71439_g);
        try {
            block2: for (Entity entity : allEntities) {
                if (!(entity instanceof EntityLivingBase) || entity.field_70128_L || !entity.field_70175_ag || !bb.func_72326_a(ForgeHelper.INSTANCE.getEntityBoundingBox((EntityLivingBase)entity))) continue;
                for (Class entityClass : entityClasses) {
                    if (!entityClass.isAssignableFrom(entity.getClass())) continue;
                    EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                    EntityDTO dto = DataCache.instance().getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                int before = list.size();
                EntityHelper.entityDTODistanceComparator.player = mc.field_71439_g;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", JourneymapClient.getCoreProperties().maxMobsData.get(), true, IMob.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", JourneymapClient.getCoreProperties().maxVillagersData.get(), false, EntityVillager.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", JourneymapClient.getCoreProperties().maxAnimalsData.get(), false, EntityAnimal.class, EntityGolem.class, EntityWaterMob.class);
    }

    public static boolean isPassive(EntityLiving entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof IMob) {
            return false;
        }
        return entityLiving.func_70638_az() == null;
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        Minecraft mc = ForgeHelper.INSTANCE.getClient();
        List allPlayers = new ArrayList(mc.field_71441_e.field_73010_i);
        allPlayers.remove(mc.field_71439_g);
        int max = JourneymapClient.getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.field_71439_g;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (EntityPlayer player : allPlayers) {
            EntityDTO dto = DataCache.instance().getEntityDTO((EntityLivingBase)player);
            dto.update((EntityLivingBase)player, false);
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static AxisAlignedBB getBB(EntityPlayerSP player) {
        int lateralDistance = JourneymapClient.getCoreProperties().radarLateralDistance.get();
        int verticalDistance = JourneymapClient.getCoreProperties().radarVerticalDistance.get();
        return ForgeHelper.INSTANCE.getBoundingBox((EntityPlayer)player, lateralDistance, verticalDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<String, EntityDTO> idMap = new LinkedHashMap<String, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put("id" + entityDTO.entityId, entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    public static String getFileName(Entity entity) {
        Render entityRender = ForgeHelper.INSTANCE.getRenderManager().func_78713_a(entity);
        if (entityRender instanceof RenderHorse) {
            EntityHorse horse = (EntityHorse)entity;
            int type = ((EntityHorse)entity).func_110265_bP();
            switch (type) {
                case 1: {
                    return "horse/donkey.png";
                }
                case 2: {
                    return "horse/mule.png";
                }
                case 3: {
                    return "horse/horse_zombie.png";
                }
                case 4: {
                    return "horse/horse_skeleton.png";
                }
                case 0: {
                    String variantTexture = horse.func_110212_cp()[0];
                    if (!variantTexture.startsWith("textures/entity/")) break;
                    return variantTexture.split("textures/entity/")[1];
                }
            }
            return "horse/horse_brown.png";
        }
        ResourceLocation loc = RenderFacade.getEntityTexture(entityRender, entity);
        if (loc == null) {
            JMLogger.logOnce("Can't get entityTexture for " + entity.getClass() + " via " + entityRender.getClass(), null);
            return null;
        }
        if (loc.func_110624_b().equals("minecraft")) {
            String search;
            String tex = loc.func_110623_a();
            int i = tex.lastIndexOf(search = "/entity/");
            if (i >= 0) {
                tex = tex.substring(i + search.length());
            }
            return tex;
        }
        return loc.func_110624_b() + "/" + loc.func_110623_a();
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        EntityPlayer player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            EntityLivingBase e1 = (EntityLivingBase)o1.entityLivingRef.get();
            EntityLivingBase e2 = (EntityLivingBase)o2.entityLivingRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.func_70068_e((Entity)this.player), e2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<Entity> {
        EntityPlayer player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.func_70068_e((Entity)this.player), o2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer n2;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.customName != null) {
                n2 = o1rank;
                n = o1rank = Integer.valueOf(o1rank + 1);
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.customName != null) {
                n2 = o2rank;
                n = o2rank = Integer.valueOf(o2rank + 1);
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

