/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.concurrent.atomic.AtomicInteger;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IPropertyHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class IntSliderButton
extends Button
implements IPropertyHolder<AtomicInteger, Integer> {
    public String prefix = "";
    public boolean dragging = false;
    public int minValue = 0;
    public int maxValue = 0;
    public String suffix = "";
    public boolean drawString = true;
    PropertiesBase properties;
    AtomicInteger property;

    public IntSliderButton(PropertiesBase properties, AtomicInteger property, String prefix, String suf, int minVal, int maxVal, boolean drawStr) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.property = property;
        this.properties = properties;
        this.setValue(property.get());
        this.disabledLabelColor = 0x404040;
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m && this.isEnabled()) {
            if (this.dragging) {
                this.setSliderValue((float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8));
            }
            int k = this.func_146114_a(this.isEnabled());
            if (this.isEnabled() || this.dragging) {
                renderHelper.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                double sliderValue = this.getSliderValue();
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)(this.field_146128_h + 1 + (int)(sliderValue * (double)(this.field_146120_f - 10))), (int)(this.field_146129_i + 1), (int)0, (int)66, (int)8, (int)(this.field_146121_g - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            }
        }
    }

    @Override
    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_146116_c(par1Minecraft, par2, par3)) {
            this.setSliderValue((float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8));
            this.dragging = true;
            return true;
        }
        return false;
    }

    public double getSliderValue() {
        return ((double)this.property.get() - (double)this.minValue * 1.0) / (double)(this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        if (sliderValue < 0.0) {
            sliderValue = 0.0;
        }
        if (sliderValue > 1.0) {
            sliderValue = 1.0;
        }
        int intVal = (int)Math.round(sliderValue * (double)(this.maxValue - this.minValue) + (double)this.minValue);
        this.setValue(intVal);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.field_146126_j = this.prefix + this.property.get() + this.suffix;
        }
    }

    public void func_146118_a(int par1, int par2) {
        if (this.dragging) {
            this.dragging = false;
            if (this.properties != null) {
                this.properties.save();
            }
        }
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.func_78256_a(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    @Override
    public boolean keyTyped(char c, int i) {
        if (this.isEnabled()) {
            if (i == 203 || i == 208 || i == 74) {
                this.setValue(Math.max(this.minValue, this.getValue() - 1));
                return true;
            }
            if (i == 205 || i == 200 || i == 78) {
                this.setValue(Math.min(this.maxValue, this.getValue() + 1));
                return true;
            }
        }
        return false;
    }

    public int getValue() {
        return this.property.get();
    }

    public void setValue(int value) {
        value = Math.min(value, this.maxValue);
        value = Math.max(value, this.minValue);
        if (this.property.get() != value) {
            this.property.set(value);
            if (!this.dragging && this.properties != null) {
                this.properties.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public AtomicInteger getProperty() {
        return this.property;
    }

    @Override
    public Integer getPropertyValue() {
        return this.property.get();
    }

    @Override
    public void setPropertyValue(Integer value) {
        if (this.property == null) {
            return;
        }
        this.setValue(value);
    }
}

