/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.LogFormatter;
import journeymap.common.Journeymap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Keyboard;

public class Constants {
    public static final Ordering<String> CASE_INSENSITIVE_NULL_SAFE_ORDER = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Joiner path = Joiner.on((String)File.separator).useForNull("");
    private static final String END = null;
    public static String JOURNEYMAP_DIR_LEGACY = "journeyMap";
    public static String JOURNEYMAP_DIR_BACKUP = "journeymap_bak";
    public static String JOURNEYMAP_DIR = "journeymap";
    public static String CONFIG_DIR_LEGACY = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[0]);
    public static String CONFIG_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[]{Journeymap.JM_VERSION.toMajorMinorString(), END});
    public static String CACHE_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"cache", new Object[]{END});
    public static String DATA_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"data", new Object[0]);
    public static String SP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.sp, new Object[]{END});
    public static String MP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.mp, new Object[]{END});
    public static String RESOURCE_PACKS_DEFAULT = "Default";
    public static String CONTROL_KEYNAME_COMBO;
    public static String KEYBINDING_CATEGORY;
    public static KeyBinding KB_MAP;
    public static KeyBinding KB_MAP_ZOOMIN;
    public static KeyBinding KB_MAP_ZOOMOUT;
    public static KeyBinding KB_MAP_DAY;
    public static KeyBinding KB_MAP_NIGHT;
    public static KeyBinding KB_MINIMAP_PRESET;
    public static KeyBinding KB_WAYPOINT;
    private static String ICON_DIR;
    public static String ENTITY_ICON_DIR;
    public static String WAYPOINT_ICON_DIR;
    public static String THEME_ICON_DIR;

    public static List<KeyBinding> initKeybindings() {
        CONTROL_KEYNAME_COMBO = "Ctrl,";
        KEYBINDING_CATEGORY = Constants.getString("jm.common.hotkeys_keybinding_category", CONTROL_KEYNAME_COMBO);
        KB_MAP = new KeyBinding("key.journeymap.map_toggle", 36, KEYBINDING_CATEGORY);
        KB_MAP_ZOOMIN = new KeyBinding("key.journeymap.zoom_in", 13, KEYBINDING_CATEGORY);
        KB_MAP_ZOOMOUT = new KeyBinding("key.journeymap.zoom_out", 12, KEYBINDING_CATEGORY);
        KB_MAP_DAY = new KeyBinding("key.journeymap.minimap_type", 26, KEYBINDING_CATEGORY);
        KB_MAP_NIGHT = new KeyBinding("key.journeymap.minimap_type", 27, KEYBINDING_CATEGORY);
        KB_MINIMAP_PRESET = new KeyBinding("key.journeymap.minimap_preset", 43, KEYBINDING_CATEGORY);
        KB_WAYPOINT = new KeyBinding("key.journeymap.create_waypoint", 48, KEYBINDING_CATEGORY);
        return Arrays.asList(KB_MAP, KB_MAP_ZOOMIN, KB_MAP_ZOOMOUT, KB_MAP_DAY, KB_MAP_NIGHT, KB_MINIMAP_PRESET, KB_WAYPOINT);
    }

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String lang = ForgeHelper.INSTANCE.getClient().func_135016_M().func_135041_c().func_135034_a();
            locale = new Locale(lang);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't determine locale from game settings, defaulting to " + locale);
        }
        return locale;
    }

    public static String getString(String key) {
        String result = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (result.equals(key)) {
            Journeymap.getLogger().warn("Message key not found: " + key);
        }
        return result;
    }

    public static String getString(String key, Object ... params) {
        String result = I18n.func_135052_a((String)key, (Object[])params);
        if (result.equals(key)) {
            Journeymap.getLogger().warn("Message key not found: " + key);
        }
        return result;
    }

    public static String getKeyName(KeyBinding keyBinding) {
        return Keyboard.getKeyName((int)Constants.getKeyCode(keyBinding));
    }

    private static int getKeyCode(KeyBinding keyBinding) {
        return keyBinding.func_151463_i();
    }

    public static boolean isPressed(KeyBinding keyBinding) {
        try {
            return keyBinding.func_151468_f() || Keyboard.isKeyDown((int)Constants.getKeyCode(keyBinding));
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Error checking whether keybinding.isPressed(): " + t);
            return false;
        }
    }

    public static boolean safeEqual(String first, String second) {
        int result = CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second);
        if (result != 0) {
            return false;
        }
        return CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second) == 0;
    }

    public static String getResourcePackNames() {
        String packs;
        ArrayList entries = new ArrayList();
        try {
            ResourcePackRepository resourcepackrepository = ForgeHelper.INSTANCE.getClient().func_110438_M();
            entries.addAll(resourcepackrepository.func_110613_c());
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Can't get resource pack names: %s", LogFormatter.toString(t)));
        }
        if (entries.isEmpty()) {
            packs = RESOURCE_PACKS_DEFAULT;
        } else {
            ArrayList<String> entryStrings = new ArrayList<String>(entries.size());
            for (ResourcePackRepository.Entry entry : entries) {
                entryStrings.add(entry.toString());
            }
            Collections.sort(entryStrings);
            packs = Joiner.on((String)", ").join(entryStrings);
        }
        return packs;
    }

    public static String getModNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!Loader.isModLoaded((String)mod.getModId())) continue;
            list.add(String.format("%s:%s", mod.getName(), mod.getVersion()));
        }
        Collections.sort(list);
        return Joiner.on((String)", ").join(list);
    }

    static {
        ICON_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"icon", new Object[0]);
        ENTITY_ICON_DIR = path.join((Object)ICON_DIR, (Object)"entity", new Object[]{END});
        WAYPOINT_ICON_DIR = path.join((Object)ICON_DIR, (Object)"waypoint", new Object[]{END});
        THEME_ICON_DIR = path.join((Object)ICON_DIR, (Object)"theme", new Object[]{END});
    }

    public static enum WorldType {
        mp,
        sp;

    }
}

