/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.model.Waypoint;
import journeymap.client.waypoint.ReiReader;
import journeymap.client.waypoint.VoxelReader;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;

public class WaypointsData
extends CacheLoader<Class, Collection<Waypoint>> {
    public static void enableRecheck() {
        ReiReader.modLoaded = null;
        VoxelReader.modLoaded = null;
    }

    public static boolean isManagerEnabled() {
        return JourneymapClient.getWaypointProperties().managerEnabled.get();
    }

    public static boolean isReiMinimapEnabled() {
        if (ReiReader.modLoaded == null) {
            try {
                ReiReader.modLoaded = WaypointsData.waypointClassesFound(ReiReader.classNames);
            }
            catch (Throwable t) {
                ReiReader.modLoaded = false;
                Journeymap.getLogger().warn("Rei's Minimap Waypoints can't be used: " + t.getMessage());
            }
            if (ReiReader.modLoaded.booleanValue()) {
                Journeymap.getLogger().info("Rei's Minimap Waypoints enabled.");
            }
        }
        return ReiReader.modLoaded;
    }

    public static boolean isVoxelMapEnabled() {
        if (VoxelReader.modLoaded == null) {
            try {
                VoxelReader.modLoaded = WaypointsData.waypointClassesFound(VoxelReader.classNames);
            }
            catch (Throwable t) {
                VoxelReader.modLoaded = false;
                Journeymap.getLogger().warn("VoxelMap Waypoints can't be used: " + t.getMessage());
            }
            if (VoxelReader.modLoaded.booleanValue()) {
                Journeymap.getLogger().info("VoxelMap Waypoints enabled.");
            }
        }
        return VoxelReader.modLoaded;
    }

    protected static List<Waypoint> getWaypoints() {
        ArrayList<Waypoint> list = new ArrayList<Waypoint>(0);
        if (WaypointsData.isReiMinimapEnabled()) {
            list.addAll(ReiReader.loadWaypoints());
        }
        if (WaypointsData.isVoxelMapEnabled()) {
            list.addAll(VoxelReader.loadWaypoints());
        }
        if (WaypointsData.isManagerEnabled()) {
            list.addAll(WaypointStore.instance().getAll());
        }
        return list;
    }

    private static boolean waypointClassesFound(String ... names) throws Exception {
        boolean loaded = true;
        for (String name : names) {
            if (!loaded) break;
            try {
                loaded = false;
                Class.forName(name);
                loaded = true;
                Journeymap.getLogger().debug("Class found: " + name);
            }
            catch (NoClassDefFoundError e) {
                throw new Exception("Class detected, but is obsolete: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                Journeymap.getLogger().debug("Class not found: " + name);
            }
            catch (VerifyError v) {
                throw new Exception("Class detected, but is obsolete: " + v.getMessage());
            }
            catch (Throwable t) {
                throw new Exception("Class detected, but produced errors.", t);
            }
        }
        return loaded;
    }

    public Collection<Waypoint> load(Class aClass) throws Exception {
        return WaypointsData.getWaypoints();
    }

    public long getTTL() {
        return 5000L;
    }
}

