/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.base.Strings;
import java.util.EnumSet;
import java.util.Set;
import journeymap.client.data.DataCache;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.LogFormatter;
import journeymap.client.ui.UIManager;
import journeymap.common.Journeymap;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChatEventHandler
implements EventHandlerManager.EventHandler {
    Set<String> featureControlCodes = FeatureManager.instance().getControlCodes();

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.MinecraftForgeBus);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        if (event.message != null) {
            try {
                String text = event.message.func_150254_d();
                if (!Strings.isNullOrEmpty((String)text)) {
                    this.checkForControlCode(text.replaceAll(EnumChatFormatting.RESET.toString(), ""));
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
    }

    private void checkForControlCode(String text) {
        if (text.contains("\u00a7")) {
            boolean resetRequired = false;
            for (String code : this.featureControlCodes) {
                if (!text.contains(code)) continue;
                FeatureManager.instance().handleControlCode(code);
                resetRequired = true;
            }
            if (resetRequired) {
                DataCache.instance().purge();
                UIManager.getInstance().reset();
            }
        }
    }
}

