var mapScale=2;var mapBounds={x1:0,z1:0,x2:0,z2:0};var mapDataMode="png";var showLight=false;var showCaves=true;var showGrid=true;var showLabels=false;var centerOnPlayer=true;var autoRefresh=true;var mapBackground="#252";var chunks=new Object();var canvas;var ctx;var isScroll=false;var mx,my;var msx,msy;var tempCanvasImage;var tempCanvas;var playerCanvas;var useTempCanvas=false;var lastChunksImage;var playerImage;var worldPath;var worldProviderType;var worldName;var worldTime;var player;var timeInfo;var jm_version;var mc_version;var latest_journeymap_version;var latest_minecraft_version;var refreshDataTimer;var mobs;var others;var mobImages=new Object();var otherImages=new Array();var chunks=new Object();var chunkScale=mapScale*16;var playerLastPos="0,0";var clientRefreshRate=1500;$(function(){$("a[rel]").overlay({mask:"darkred",effect:"apple",onBeforeLoad:function(){var wrap=this.getOverlay().find(".contentWrap");wrap.load(this.getTrigger().attr("href"));}});});$(document).ready(init);function init(){if(!(window.badBrowser===undefined)){return;}if((navigator.userAgent.match(/iPhone/i))||(navigator.userAgent.match(/iPod/i))){window.scrollTo(0,1);}initImages();canvas=$("#mapCanvas")[0];tempCanvas=document.createElement("canvas");playerCanvas=document.createElement("canvas");timeInfo=$("#timeInfo")[0];$(function(){$("#slider-vertical").slider({orientation:"vertical",range:"min",min:2,max:8,value:2,step:1,slide:function(event,ui){setZoom(ui.value);}});});setMapType("day");registerEvents();initWorld();checkVersion();}function checkVersion(){$.ajax({url:"http://goo.gl/q0piA",dataType:"script",success:function(){if(latest_journeymap_version>jm_version){$("#versionButton").attr("title","<b>Update Available</b><br/>JourneyMap "+latest_journeymap_version+" for Minecraft "+latest_minecraft_version);$("#versionButton").css("visibility","visible");$("#versionButton").tooltip({effect:"slide",opacity:0.9,}).dynamic({bottom:{direction:"down",bounce:true}});}},error:function(jqXHR,textStatus,errorThrown){console.log("Error checking version: "+errorThrown);}});}function initImages(){$("#dayButton").attr("title","<b>Daylight Map</b><br/>The world map as it appears in daylight.");$("#nightButton").attr("title","<b>Moonlight Map</b><br/>The world map as it appears in moonlight.");$("#followButton").attr("title","<b>Follow Me</b><br/>Auto-center the map on you. (Turns off if you manually pan.)");$("#caveButton").attr("title","<b>Show Caves</b><br/>Show cave/interior map when you're not under sky.");$("#saveButton").attr("title","<b>Save Map</b><br/>Save the current map image to file");$("#aboutButton").attr("title","<b>About JM</b><br/>Help, Licenses, Acknowledgements, and Disclaimers");$("#toolbar img[title]").tooltip({effect:"slide",opacity:0.9,}).dynamic({bottom:{direction:"down",bounce:true}});$("#infobar img[title]").tooltip({effect:"slide",opacity:0.9,}).dynamic({bottom:{direction:"down",bounce:true}});playerImage=document.createElement("img");playerImage.id="playerImage";playerImage.style.position="absolute";playerImage.style.height="32px";playerImage.style.width="32px";playerImage.style.cursor="hand";playerImage.src="arrow.png";playerImage.onclick=function(){setCenterOnPlayer(true);refreshData();};document.body.appendChild(playerImage);initMobImage("Creeper");initMobImage("Skeleton");initMobImage("Zombie");initMobImage("PigZombie");initMobImage("Spider");initMobImage("Enderman");initMobImage("Silverfish");initMobImage("Ghast");initMobImage("Dragon");initMobImage("Slime");initMobImage("MagmaCube");initMobImage("Blaze");otherImage=new Image();otherImage["class"]="mobImage";otherImage.src="other.png";}function initMobImage(name){var img=new Image();img["class"]="mobImage";img.src=name+".png";mobImages[name]=img;}function saveMapImage(){$.ajax({async:false,url:getMapDataUrl(),beforeSend:function(xhr){xhr.overrideMimeType("text/plain; charset=x-user-defined");},success:function(data){var b64=Base64.encode(data);var uri="data:image/png;base64,"+encodeURIComponent(b64);window.open(uri);}});}function initWorld(){$.ajax({url:"/jm",dataType:"script",success:function(){if(worldName!=null){$("#worldNameHeader").attr("innerHTML",worldName);$("#version").attr("innerHTML",jm_version+" for Minecraft "+mc_version);setCenterOnPlayer(true);}refreshDataTimer=setInterval(function(){if(autoRefresh&&!isScroll){refreshData();}},clientRefreshRate);sizeMap();refreshData();},error:function(jqXHR,textStatus,errorThrown){handleError(errorThrown);}});}var delay=(function(){var timer=0;return function(callback,ms){clearTimeout(timer);timer=setTimeout(callback,ms);};})();function setScale(newScale){mapScale=newScale;chunkScale=mapScale*16;setCookie("scale",mapScale,365);}function sizeMap(){setCanvasWidth($(window).width());setCanvasHeight($(window).height());document.body.style.backgroundColor=mapBackground;}function getCanvasWidth(){var ctx=getContext();if(ctx.canvas.width){return ctx.canvas.width;}else{return ctx.canvas.style.pixelWidth;}}function setCanvasWidth(width){var ctx=getContext();if(ctx.canvas.width){ctx.canvas.width=width;}else{ctx.canvas.style.pixelWidth=width;}}function getCanvasHeight(){var ctx=getContext();if(ctx.canvas.height){return ctx.canvas.height;}else{return ctx.canvas.style.pixelHeight;}}function setCanvasHeight(height){var ctx=getContext();if(ctx.canvas.height){ctx.canvas.height=height;}else{ctx.canvas.style.pixelHeight=height;}}function centerMapOnPlayer(){centerMapOnChunk(Math.round(player.chunkCoordX),Math.round(player.chunkCoordZ));}function centerMapOnChunk(chunkX,chunkZ){var ctx=getContext();var maxChunksWide=Math.ceil(getCanvasWidth()/mapScale/16);var maxChunksHigh=Math.ceil(getCanvasHeight()/mapScale/16);mapBounds.x1=chunkX-Math.round(maxChunksWide/2)+1;mapBounds.z1=chunkZ-Math.round(maxChunksHigh/2)+1;checkBounds();}function checkBounds(){var ctx=getContext();var maxChunksWide=Math.ceil(getCanvasWidth()/mapScale/16);var maxChunksHigh=Math.ceil(getCanvasHeight()/mapScale/16);mapBounds.x2=mapBounds.x1+maxChunksWide;mapBounds.z2=mapBounds.z1+maxChunksHigh;}function setMapType(mapType,refresh){if(mapType=="day"){showLight=false;mapBackground="#252";$("#dayButton").removeClass("imgButton").addClass("imgButtonSelected");$("#nightButton").removeClass("imgButtonSelected").addClass("imgButton");}else{if(mapType=="night"){showLight=true;mapBackground="#000";$("#dayButton").removeClass("imgButtonSelected").addClass("imgButton");$("#nightButton").removeClass("imgButton").addClass("imgButtonSelected");}else{console.log("Error: Can't set mapType: "+mapType);return;}}document.body.style.backgroundColor=mapBackground;if(refresh==true){refreshData();}}function setCenterOnPlayer(onPlayer){centerOnPlayer=onPlayer;if(onPlayer==true){centerMapOnPlayer();$("#followButton").removeClass("imgButton").addClass("imgButtonToggle");}else{$("#followButton").removeClass("imgButtonToggle").addClass("imgButton");}}function setShowCaves(show){showCaves=show;if(showCaves==true){$("#caveButton").removeClass("imgButton").addClass("imgButtonToggle");}else{$("#caveButton").removeClass("imgButtonToggle").addClass("imgButton");}}function checkShowCaves(){if(player.underground==true&&showCaves){mapBackground="#000";}else{if(showLight){setMapType("night");}else{setMapType("day");}}}function getContext(){var theCanvas;if(useTempCanvas){theCanvas=tempCanvas;}else{theCanvas=canvas;}return theCanvas.getContext("2d");}function getMapDataUrl(){var mapType=(player.underground&&showCaves)?"underground":(showLight?"night":"day");var depth=player.chunkCoordY;var request=worldPath+"&mapType="+mapType+"&depth="+depth+"&x1="+mapBounds.x1+"&z1="+mapBounds.z1+"&x2="+mapBounds.x2+"&z2="+mapBounds.z2+"&t="+new Date().getTime();return request;}function refreshData(){if(isScroll==false){refreshImageData();}}function refreshImageData(){$.ajax({url:"/jm",dataType:"script",success:function(){if(centerOnPlayer){centerMapOnPlayer();}else{checkBounds();}lastChunksImage=new Image();lastChunksImage.onload=function(){var ctx=getContext();updateUI();};lastChunksImage.src=getMapDataUrl();},error:function(jqXHR,textStatus,errorThrown){handleError(errorThrown);}});}function updateInfo(){var allsecs=worldTime/20;var mins=Math.floor(allsecs/60);var secs=Math.ceil(allsecs%60);if(secs<10){secs="0"+secs;}var currentTime=mins+":"+secs;if(worldTime>=22200||worldTime<=12000){var txt="Sunset is at 10:00";}else{var txt="Sunrise is at 18:30";}timeInfo.innerHTML="<big>World Time: <b>"+currentTime+"</b></big><br/>"+txt;}function handleError(error){if(error==""||error==null){error="Minecraft World Not Connected";}else{if(error.substring&&error.substring(1,8)=="JMERR09"){error="Minecraft World Not Opened";}}document.body.style.backgroundColor="#000";clearInterval(refreshDataTimer);sizeMap();var creeper=new Image();creeper.onload=function(){ctx.drawImage(creeper,getCanvasWidth()/2-68,getCanvasHeight()/2-110);creeper.onload=null;};creeper.src="/creeper.jpg";var ctx=getContext();ctx.globalAlpha=1;ctx.fillStyle="red";ctx.font="bold 16px Arial";ctx.textAlign="center";ctx.fillText(error,getCanvasWidth()/2,(getCanvasHeight()/2)+10);$.each(otherImages,function(index,otherImage){document.body.removeChild(otherImage);});setTimeout(initWorld,5000);}function updateUI(){document.body.style.cursor="wait";useTempCanvas=true;sizeMap();var ctx=getContext();checkShowCaves();drawImageChunks();drawPlayer();drawMobs();drawOthers();if(ctx.getImageData){tempCanvasImage=ctx.getImageData(0,0,getCanvasWidth(),getCanvasHeight());}useTempCanvas=false;sizeMap();ctx=getContext();ctx.globalAlpha=1;if(ctx.putImageData){ctx.putImageData(tempCanvasImage,0,0);}updateInfo();document.body.style.cursor="default";}function drawBackground(){var ctx=getContext();ctx.globalAlpha=1;ctx.fillStyle=mapBackground;ctx.fillRect(0,0,getCanvasWidth(),getCanvasHeight());}function drawPlayer(){var x=getScaledChunkX(player.posX/16);var z=getScaledChunkZ(player.posZ/16);if(x>=0&&x<=getCanvasWidth()&&z>=0&&z<=getCanvasWidth()){var ctx=getContext();ctx.globalAlpha=0.4;if(showLight==false){ctx.fillStyle="#000000";}else{ctx.fillStyle="#ffffff";}ctx.beginPath();ctx.arc(x,z,20,0,Math.PI*2,true);ctx.closePath();ctx.fill();$("#playerImage").css("visibility","visible");$("#playerImage").css("left",x-16);$("#playerImage").css("top",z-16);$("#playerImage").css("zIndex",2);var rotate="rotate("+player.heading+"deg)";$("#playerImage").css("-webkit-transform",rotate);$("#playerImage").css("-moz-transform",rotate);$("#playerImage").css("-o-transform",rotate);$("#playerImage").css("-ms-transform",rotate);$("#playerImage").css("transform",rotate);playerPos=player.posX+","+player.posZ+"&nbsp;("+player.posY+")";if(playerPos!=playerLastPos){playerLastPos=playerPos;}var loc="<em>Location:</em> "+playerPos;if(worldProviderType==-1){loc+="<br/><span style='color:#a00'>The Nether</span>";}else{if(worldProviderType==1){loc+="<br/><span style='color:#a00'>The End</span>";}}var slice="Vertical slice: "+(player.posY>>4);$("#playerImage").attr("title",player.name);$("#playerInfo").attr("innerHTML",loc);$("#playerInfo").attr("title",slice);}else{}}function drawMobs(){$.each(mobs,function(index,mob){var x=getScaledChunkX(mob.posX/16);var z=getScaledChunkZ(mob.posZ/16);if(x>=0&&x<=getCanvasWidth()&&z>=0&&z<=getCanvasWidth()){var ctx=getContext();ctx.globalAlpha=0.85;ctx.strokeStyle="#f00";ctx.lineWidth=2;ctx.beginPath();var radius=16;if(mob.type=="Ghast"||mob.type=="Dragon"){radius=24;}ctx.arc(x,z,radius,0,Math.PI*2,true);ctx.stroke();ctx.globalAlpha=1;var type=mob.type;var mobImage=mobImages[mob.type];if(mobImage){ctx.drawImage(mobImage,x-radius,z-radius,radius*2,radius*2);}}});}function drawOthers(){$.each(otherImages,function(index,otherImage){document.body.removeChild(otherImage);});otherImages=new Array();$.each(others,function(index,other){var x=getScaledChunkX(other.posX/16);var z=getScaledChunkZ(other.posZ/16);if(other.username!=player.name){if(x>=0&&x<=getCanvasWidth()&&z>=0&&z<=getCanvasWidth()){var ctx=getContext();ctx.globalAlpha=0.85;ctx.strokeStyle="#0f0";ctx.lineWidth=2;ctx.beginPath();ctx.arc(x,z,20,0,Math.PI*2,true);ctx.stroke();ctx.globalAlpha=1;var otherImage=document.createElement("img");otherImage.src="other.png";otherImage.title=other.username;otherImage.style.visibility="visible";otherImage.style.position="absolute";otherImage.style.height="20px";otherImage.style.width="20px";otherImage.style.left=x-10;otherImage.style.top=z-10;otherImage.style.zIndex=1;document.body.appendChild(otherImage);otherImages.push(otherImage);}}});}function drawImageChunks(){var maxHeight=0;var minHeight=128;var key;var ctx=getContext();ctx.drawImage(lastChunksImage,0,0,lastChunksImage.width*mapScale,lastChunksImage.height*mapScale);}function getScaledChunkX(chunkX){var xOffset=((mapBounds.x1)*chunkScale);return(chunkX*chunkScale)-xOffset;}function getScaledChunkZ(chunkZ){var zOffset=((mapBounds.z1)*chunkScale);return(chunkZ*chunkScale)-zOffset;}function registerEvents(){$("*").live("selectstart dragstart",function(evt){evt.preventDefault();return false;});canvas.onselectstart=function(){return false;};canvas.onmousedown=myDown;canvas.onmouseup=myUp;canvas.ondblclick=myDblClick;if(window.addEventListener){window.addEventListener("DOMMouseScroll",myMouseWheel,false);}window.onmousewheel=document.onmousewheel=myMouseWheel;if(document.addEventListener){document.addEventListener("touchstart",touchHandler,true);document.addEventListener("touchmove",touchHandler,true);document.addEventListener("touchend",touchHandler,true);document.addEventListener("touchcancel",touchHandler,true);}document.onkeypress=myKeyPress;window.onresize=function(event){delay(refreshData,200);};}function getMouse(event){if(!event){event=window.event;}mx=event.pageX;my=event.pageY;}function myDown(e){scrollCanvas(e);}function myUp(e){getMouse(e);var mouseDragX=(mx-msx);var mouseDragY=(my-msy);if(mouseDragX==0&&mouseDragY==0){isScroll=false;}if(isScroll){var xOffset=Math.floor(mouseDragX/chunkScale);var zOffset=Math.floor(mouseDragY/chunkScale);mapBounds.x1=mapBounds.x1-xOffset-1;mapBounds.z1=mapBounds.z1-zOffset-1;isScroll=false;refreshData();}}function myDblClick(e){getMouse(e);}function myKeyPress(e){var key=(e)?e.which:e.keyCode;switch(String.fromCharCode(key)){case"-":zoom("out");break;case"=":zoom("in");break;case"w":case"W":moveCanvas("up");break;case"a":case"A":moveCanvas("right");break;case"s":case"S":moveCanvas("down");break;case"d":case"D":moveCanvas("left");break;}}function myMouseWheel(event){var delta=0;if(!event){event=window.event;}if(event.wheelDelta){delta=event.wheelDelta/120;if(window.opera){delta=-delta;}}else{if(event.detail){delta=-event.detail/3;}}if(delta>0){zoom("in");}if(delta<0){zoom("out");}if(event.preventDefault){event.preventDefault();}event.returnValue=false;event.cancelBubble=true;}function zoom(dir){if(dir=="in"&&mapScale<8){setZoom(mapScale+1);}else{if(dir=="out"&&mapScale>2){setZoom(mapScale-1);}}}function setZoom(scale){var centerChunkX=Math.floor(getCanvasWidth()/chunkScale/2)+mapBounds.x1;var centerChunkZ=Math.floor(getCanvasHeight()/chunkScale/2)+mapBounds.z1;$("#slider-vertical").slider("value",scale);setScale(scale);centerMapOnChunk(centerChunkX,centerChunkZ);refreshData();}function scrollCanvas(e){isScroll=true;getMouse(e);msx=mx;msy=my;var ctx=tempCanvas.getContext("2d");ctx.globalAlpha=0.5;ctx.drawImage(canvas,0,0);playerImage.style.visibility="hidden";document.onmousemove=scrollingCanvas;}function scrollingCanvas(e){if(isScroll){document.body.style.cursor="move";getMouse(e);var mouseDragX=(mx-msx);var mouseDragY=(my-msy);var xOffset=Math.ceil(mouseDragX/chunkScale);var zOffset=Math.ceil(mouseDragY/chunkScale);if(Math.abs(xOffset)>0||Math.abs(zOffset)>0){setCenterOnPlayer(false);}drawBackground();var ctx=getContext();ctx.globalAlpha=1;ctx.drawImage(tempCanvas,(xOffset*chunkScale),(zOffset*chunkScale));}else{tempCanvasImage=null;document.onmousemove=null;document.body.style.cursor="default";}}function moveCanvas(dir){switch(dir){case"left":mapBounds.x1++;break;case"right":mapBounds.x1--;
break;case"up":mapBounds.z1--;break;case"down":mapBounds.z1++;break;}setCenterOnPlayer(false);refreshData();}function touchHandler(event){var touches=event.changedTouches,first=touches[0],type="";switch(event.type){case"touchstart":type="mousedown";break;case"touchmove":type="mousemove";break;case"touchend":type="mouseup";break;default:return;}var simulatedEvent=document.createEvent("MouseEvent");simulatedEvent.initMouseEvent(type,true,true,window,1,first.screenX,first.screenY,first.clientX,first.clientY,false,false,false,false,0,null);first.target.dispatchEvent(simulatedEvent);event.preventDefault();}function setCookie(c_name,value,expires){var date=new Date();date.setDate(date.getDate()+expires);document.cookie=c_name+"="+escape(value)+((expires==null)?"":";expires="+date.toUTCString());}function getCookie(c_name){if(document.cookie.length>0){c_start=document.cookie.indexOf(c_name+"=");if(c_start!=-1){c_start+=c_name.length+1;c_end=document.cookie.indexOf(";",c_start);if(c_end==-1){c_end=document.cookie.length;}return unescape(document.cookie.substring(c_start,c_end));}}return"";}var Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(input){var output="";var chr1,chr2,chr2raw,chr3,chr3raw,enc1,enc2,enc3,enc4;var i=0;while(i<input.length){chr1=input.charCodeAt(i++)&255;chr2=isNaN(chr2raw=input.charCodeAt(i++))?NaN:(chr2raw&255);chr3=isNaN(chr3raw=input.charCodeAt(i++))?NaN:(chr3raw&255);enc1=chr1>>2;enc2=((chr1&3)<<4)|(chr2>>4);enc3=((chr2&15)<<2)|(chr3>>6);enc4=chr3&63;if(isNaN(chr2)){enc3=enc4=64;}else{if(isNaN(chr3)){enc4=64;}}output=output+this._keyStr.charAt(enc1)+this._keyStr.charAt(enc2)+this._keyStr.charAt(enc3)+this._keyStr.charAt(enc4);}return output;}};