/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels;

import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.PlankSawEntry;
import ivorius.yegamolchattels.blocks.PlankSawRegistry;
import ivorius.yegamolchattels.blocks.PlanksRefinementEntry;
import ivorius.yegamolchattels.blocks.PlanksRefinementRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Property;

public class YGCConfig {
    public static final String CATEGORY_BALANCING = "balancing";
    public static final String CATEGORY_VISUAL = "visual";
    private static final Set<String> lifeStatuesBlacklist = new HashSet<String>();
    public static boolean areLifeStatuesAllowed;
    private static final Set<String> equippableStatues;
    public static boolean easterEggsAllowed;
    public static boolean fetchDynamicStatueTextures;
    public static boolean doStatueTextureMerge;
    public static boolean genFlax;
    public static double entityVitaDropChance;
    private static final Set<String> itemShelfBlacklist;
    public static final Set<PlankSawRegistry.Entry> customPlankSawing;
    public static final Set<PlanksRefinementRegistry.Entry> customPlankRefinement;

    public static void loadConfig(String configID) {
        if (configID == null || configID.equals(CATEGORY_BALANCING)) {
            ItemStack source;
            String[] params;
            YGCConfig.getStringSet(lifeStatuesBlacklist, YeGamolChattels.config.get(CATEGORY_BALANCING, "lifeStatuesBlacklist", new String[]{"EnderDragon", "Giant", "WitherBoss"}, "Entity IDs that are not allowed to come alive from statues."));
            YGCConfig.getStringSet(equippableStatues, YeGamolChattels.config.get(CATEGORY_BALANCING, "equippableStatues", new String[]{"Zombie", "Skeleton", "PigZombie"}, "Entity IDs that will be treated as equippable mobs as statues"));
            areLifeStatuesAllowed = YeGamolChattels.config.get(CATEGORY_BALANCING, "areLifeStatuesAllowed", true, "Are statues allowed to come to life with redstone input?").getBoolean();
            easterEggsAllowed = YeGamolChattels.config.get(CATEGORY_BALANCING, "easterEggsAllowed", true).getBoolean();
            genFlax = YeGamolChattels.config.get(CATEGORY_BALANCING, "generateFlax", true).getBoolean();
            entityVitaDropChance = YeGamolChattels.config.get(CATEGORY_BALANCING, "entityVitaDropChance", 0.01, "Drop chance of entity vitas when killing a mob. <Temporary config option: Will be removed when the new system is added>").getDouble();
            itemShelfBlacklist.clear();
            for (String s : YeGamolChattels.config.get(CATEGORY_BALANCING, "itemShelfBlacklist", new String[0], "List of item IDs that are not allowed to be placed in item shelves.").getStringList()) {
                itemShelfBlacklist.add(s.contains(":") ? s : "minecraft:" + s);
            }
            customPlankSawing.clear();
            for (String s : YeGamolChattels.config.get(CATEGORY_BALANCING, "customPlankSawing", new String[0], "List of additional plank saw recipes. Form: SourceJson->DestJson. Example: {id:wood,Damage:2}->{id:yegamolchattels:plank,Damage:2}").getStringList()) {
                params = s.split("->");
                if (params.length != 2) continue;
                source = YGCConfig.tryParseItemStack(params[0]);
                ItemStack dest = YGCConfig.tryParseItemStack(params[1]);
                if (source == null || dest == null) continue;
                customPlankSawing.add(new PlankSawEntry(source, dest));
            }
            customPlankRefinement.clear();
            for (String s : YeGamolChattels.config.get(CATEGORY_BALANCING, "itemShelfBlacklist", new String[0], "List of additional plank refinement recipes. Form: SourceJson->ToolJson->DestJson->ToolReturnJson (optional). Example: {id:yegamolchattels:plank,Damage:2}->{id:yegamolchattels:linseed_oil}->{id:yegamolchattels:smoothed_plank,Damage:2}->{id:glass_bottle}").getStringList()) {
                ItemStack returnTool;
                params = s.split("->");
                if (params.length < 3) continue;
                source = YGCConfig.tryParseItemStack(params[0]);
                ItemStack tool = YGCConfig.tryParseItemStack(params[1]);
                ItemStack dest = YGCConfig.tryParseItemStack(params[2]);
                ItemStack itemStack = returnTool = params.length >= 4 ? YGCConfig.tryParseItemStack(params[3]) : null;
                if (source == null || tool == null || dest == null) continue;
                customPlankRefinement.add(new PlanksRefinementEntry(source, dest, tool.func_77973_b(), returnTool));
            }
        }
        YeGamolChattels.proxy.loadConfig(configID);
    }

    private static ItemStack tryParseItemStack(String json) {
        NBTTagCompound compound = YGCConfig.tryParseTagCompound(json);
        return compound != null ? ItemStack.func_77949_a((NBTTagCompound)compound) : null;
    }

    private static NBTTagCompound tryParseTagCompound(String json) {
        NBTBase sourceNBT;
        try {
            sourceNBT = JsonToNBT.func_150315_a((String)json);
        }
        catch (NBTException e) {
            return null;
        }
        return sourceNBT instanceof NBTTagCompound ? (NBTTagCompound)sourceNBT : null;
    }

    private static void getStringSet(Set<String> set, Property property) {
        set.clear();
        Collections.addAll(set, property.getStringList());
    }

    public static boolean isEntityEquippable(Entity entity) {
        return equippableStatues.contains(EntityList.func_75621_b((Entity)entity));
    }

    public static boolean mayEntityStatueComeAlive(Entity entity) {
        return !lifeStatuesBlacklist.contains(EntityList.func_75621_b((Entity)entity));
    }

    public static boolean mayItemBeStoredInShelf(ItemStack stack) {
        return !itemShelfBlacklist.contains(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
    }

    static {
        equippableStatues = new HashSet<String>();
        itemShelfBlacklist = new HashSet<String>();
        customPlankSawing = new HashSet<PlankSawRegistry.Entry>();
        customPlankRefinement = new HashSet<PlanksRefinementRegistry.Entry>();
    }
}

