/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PlankSawRegistry {
    private static final List<Entry> entries = new ArrayList<Entry>();

    public static void addSawing(Entry entry) {
        entries.add(entry);
    }

    public static List<Entry> allEntries() {
        return Collections.unmodifiableList(entries);
    }

    public static Entry entry(ItemStack source) {
        for (Entry entry : entries) {
            if (!entry.matchesSource(source)) continue;
            return entry;
        }
        return null;
    }

    public static boolean canSawItem(ItemStack ingredient) {
        return PlankSawRegistry.entry(ingredient) != null;
    }

    public static ItemStack getSawResult(int stackSize, ItemStack ingredient) {
        Entry entry = PlankSawRegistry.entry(ingredient);
        if (entry != null) {
            ItemStack result = entry.getResult(ingredient);
            result.field_77994_a = stackSize;
            return result;
        }
        return null;
    }

    public static interface Entry {
        public boolean matchesSource(ItemStack var1);

        public ItemStack getResult(ItemStack var1);
    }
}

