/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlanksRefinementRegistry {
    private static List<Entry> planksRefinementEntries = new ArrayList<Entry>();

    public static void addRefinement(Entry entry) {
        planksRefinementEntries.add(entry);
    }

    public static List<Entry> allEntries() {
        return Collections.unmodifiableList(planksRefinementEntries);
    }

    public static boolean canRefine(ItemStack source) {
        for (Entry entry : planksRefinementEntries) {
            if (!entry.matchesSource(source)) continue;
            return true;
        }
        return false;
    }

    public static Entry entry(ItemStack source, ItemStack tool) {
        for (Entry entry : planksRefinementEntries) {
            if (!entry.matchesSource(source) || !entry.matchesTool(tool)) continue;
            return entry;
        }
        return null;
    }

    public static interface Entry {
        public boolean matchesSource(ItemStack var1);

        public boolean matchesTool(ItemStack var1);

        public ItemStack getResult(ItemStack var1, ItemStack var2);

        public void onToolBreak(ItemStack var1, EntityPlayer var2);
    }
}

