/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import ivorius.ivtoolkit.blocks.IvMultiBlockHelper;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.yegamolchattels.blocks.Statue;
import ivorius.yegamolchattels.blocks.TileEntityStatue;
import ivorius.yegamolchattels.blocks.YGCBlocks;
import ivorius.yegamolchattels.items.ItemStatue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class StatueHelper {
    public static boolean canCarveStatue(Entity statueEntity, World world, int x, int y, int z) {
        if (StatueHelper.isValidStatueBlock(world, x, y, z)) {
            Statue.BlockFragment blockFragment = new Statue.BlockFragment(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            List<int[]> positions = ItemStatue.getStatuePositions(statueEntity, 0);
            List<int[]> validPositions = StatueHelper.getValidPositions(positions, world, blockFragment, x, y, z);
            if (validPositions != null) {
                return true;
            }
        }
        return false;
    }

    public static TileEntityStatue carveStatue(ItemStack stack, Statue statue, World world, int x, int y, int z, EntityLivingBase entityLivingBase) {
        if (StatueHelper.isValidStatueBlock(world, x, y, z)) {
            IvMultiBlockHelper multiBlockHelper;
            Statue.BlockFragment blockFragment = new Statue.BlockFragment(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            int rotation = 0;
            List<int[]> positions = ItemStatue.getStatuePositions(statue.getEntity(), rotation);
            List<int[]> validPositions = StatueHelper.getValidPositions(positions, world, blockFragment, x, y, z);
            if (validPositions != null && (multiBlockHelper = new IvMultiBlockHelper()).beginPlacing(validPositions, world, YGCBlocks.statue, 0, rotation)) {
                TileEntityStatue parent = null;
                for (int[] position : multiBlockHelper) {
                    IvTileEntityMultiBlock tileEntity = multiBlockHelper.placeBlock(position);
                    if (!(tileEntity instanceof TileEntityStatue) || !tileEntity.isParent()) continue;
                    parent = (TileEntityStatue)tileEntity;
                    TileEntityStatue tileEntityStatue = (TileEntityStatue)tileEntity;
                    statue.setMaterial(blockFragment);
                    tileEntityStatue.setStatue(statue);
                    tileEntityStatue.setStatueRotationYaw((entityLivingBase.field_70177_z + 180.0f) % 360.0f);
                }
                stack.func_77972_a(1, entityLivingBase);
                return parent;
            }
        }
        return null;
    }

    public static boolean isValidStatueBlock(World world, int x, int y, int z) {
        Statue.BlockFragment blockFragment = new Statue.BlockFragment(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
        return blockFragment.getBlock().func_149712_f(world, x, y, z) >= 0.0f && StatueHelper.isValidStatueBlock(blockFragment);
    }

    private static boolean isValidStatueBlock(Statue.BlockFragment fragment) {
        Block block = fragment.getBlock();
        return !block.hasTileEntity(fragment.getMetadata()) && (block.func_149662_c() || block == Blocks.field_150359_w || block == Blocks.field_150399_cn);
    }

    public static List<int[]> getValidPositions(List<int[]> positions, World world, Statue.BlockFragment blockFragment, int x, int y, int z) {
        ArrayList<int[]> validLocations = new ArrayList<int[]>();
        for (int[] origin : positions) {
            int posZ;
            int posY;
            int[] position;
            int posX;
            Iterator<int[]> i$ = positions.iterator();
            while (i$.hasNext() && world.func_147439_a(posX = (position = i$.next())[0] + x - origin[0], posY = position[1] + y - origin[1], posZ = position[2] + z - origin[2]) == blockFragment.getBlock() && world.func_72805_g(posX, posY, posZ) == blockFragment.getMetadata()) {
                validLocations.add(new int[]{posX, posY, posZ});
            }
            if (validLocations.size() == positions.size()) {
                return validLocations;
            }
            validLocations.clear();
        }
        return null;
    }
}

