/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityRotatable;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YeGamolChattels;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityLootChest
extends IvTileEntityRotatable
implements IInventory,
PartialUpdateHandler {
    public static final float LOCK_MAX = 0.5f;
    public static final float LOCK_MIN = 5.0E-4f;
    public static final float LOCK_FALL_MAX = 0.31f;
    public static final float FINISH_MARGIN = 0.005f;
    public static final float CHEST_MAX = 0.5f;
    public final ItemStack[] loot = new ItemStack[10];
    public boolean opened = false;
    public boolean closed = true;
    public float chestFrame = 0.0f;
    public float lockFrame = 0.0f;
    public float lockFall = 5.0E-4f;
    public float lockAccel = 1.0f;

    public int firstSlot(boolean empty) {
        for (int i = 0; i < this.loot.length; ++i) {
            if (this.loot[i] == null != empty) continue;
            return i;
        }
        return -1;
    }

    public ItemStack firstItem() {
        int slot = this.firstSlot(false);
        if (slot >= 0) {
            return this.func_70301_a(slot);
        }
        return null;
    }

    public boolean addLoot(ItemStack item) {
        int slot = this.firstSlot(true);
        if (slot >= 0) {
            this.func_70299_a(slot, item.func_77946_l());
            return true;
        }
        return false;
    }

    public boolean pickUpItem(EntityPlayer player) {
        ItemStack stack;
        int slot = this.firstSlot(false);
        if (slot >= 0 && (stack = this.func_70301_a(slot)) != null) {
            if (!this.field_145850_b.field_72995_K && player.field_71071_by.func_70441_a(stack)) {
                this.func_70299_a(slot, null);
                player.field_71070_bA.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public void open() {
        this.closed = false;
        this.opened = true;
        IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"openState", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
    }

    public void close() {
        this.opened = false;
        this.closed = true;
        IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"openState", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
    }

    public boolean itemAccessible() {
        return this.chestFrame > 0.25f && !this.closed;
    }

    public void func_145845_h() {
        block15: {
            block13: {
                block14: {
                    if (!this.closed) break block13;
                    if (!(this.chestFrame > 0.005f)) break block14;
                    if (this.chestFrame >= 0.495f) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.05f);
                    }
                    if (this.lockFall > 5.0E-4f) {
                        this.lockFall -= this.lockFall * 0.2f;
                    }
                    this.chestFrame -= this.chestFrame * 0.2f;
                    break block15;
                }
                if (!(this.chestFrame <= 0.005f)) break block15;
                this.chestFrame = 0.0f;
                this.lockFall = 5.0E-4f;
                this.lockFrame = this.lockFrame > 0.005f ? (this.lockFrame -= (0.0f + this.lockFrame) * 0.1f) : 0.0f;
                break block15;
            }
            if (this.opened) {
                if (this.lockFrame < 0.495f) {
                    this.lockFrame = (float)((double)this.lockFrame + (double)(0.5f - this.lockFrame) * 0.1);
                } else if (this.chestFrame < 0.495f) {
                    if (this.chestFrame == 0.0f) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.05f);
                    }
                    this.lockFrame = 0.5f;
                    if (this.lockAccel < 2.0f) {
                        this.lockAccel += 0.05f;
                    }
                    if (this.lockFall < 0.31f) {
                        this.lockFall *= this.lockAccel;
                    } else {
                        this.lockAccel = this.chestFrame / 0.5f;
                        if (this.lockAccel > 0.95f) {
                            this.lockAccel = 1.0f;
                        }
                        this.lockFall *= this.lockAccel;
                    }
                    this.chestFrame += (0.5f - this.chestFrame) * 0.1f;
                    if (this.chestFrame < 0.49f) {
                        for (int i = 0; i < 10; ++i) {
                            float velocity = 0.001f;
                            float velX = (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity - (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity;
                            float velY = (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity - (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity;
                            float velZ = (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity - (float)this.field_145850_b.field_73012_v.nextInt(100) * velocity;
                            this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), (double)velX, (double)velY, (double)velZ);
                        }
                    }
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (ItemStack loot : this.loot) {
            if (loot == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            loot.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a("items", (NBTBase)tagList);
        nbt.func_74776_a("lockFrame", this.lockFrame);
        nbt.func_74776_a("chestFrame", this.chestFrame);
        nbt.func_74776_a("lockFall", this.lockFall);
        nbt.func_74776_a("lockAccel", this.lockAccel);
        nbt.func_74757_a("opened", this.opened);
        nbt.func_74757_a("closed", this.closed);
        super.func_145841_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        Arrays.fill(this.loot, null);
        NBTTagList tagList = nbt.func_150295_c("items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (item == null) continue;
            this.addLoot(item);
        }
        this.lockFrame = nbt.func_74760_g("lockFrame");
        this.chestFrame = nbt.func_74760_g("chestFrame");
        this.lockFall = nbt.func_74760_g("lockFall");
        this.lockAccel = nbt.func_74760_g("lockAccel");
        this.opened = nbt.func_74767_n("opened");
        this.closed = nbt.func_74767_n("closed");
        super.func_145839_a(nbt);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("openState".equals(context)) {
            buffer.writeBoolean(this.opened);
            buffer.writeBoolean(this.closed);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("openState".equals(context)) {
            this.opened = buffer.readBoolean();
            this.closed = buffer.readBoolean();
        }
    }

    public void dropAllItems() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70304_b(i);
            if (stack == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, stack));
        }
    }

    public int func_70302_i_() {
        return this.loot.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.loot[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.loot[slot] != null) {
            if (this.loot[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.loot[slot];
                this.loot[slot] = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return itemstack;
            }
            ItemStack itemstack = this.loot[slot].func_77979_a(amount);
            if (this.loot[slot].field_77994_a == 0) {
                this.loot[slot] = null;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.loot[slot] != null) {
            ItemStack itemstack = this.loot[slot];
            this.loot[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.loot[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "container.lootChest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

