/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.MCRegistryDefault;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.BlockMicroBlock;
import ivorius.yegamolchattels.client.rendering.GridQuadCache;
import ivorius.yegamolchattels.client.rendering.IIconQuadCache;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMicroBlock
extends TileEntity
implements PartialUpdateHandler {
    public static final int MICROBLOCKS_PER_BLOCK_X = 8;
    public static final int MICROBLOCKS_PER_BLOCK_Y = 8;
    public static final int MICROBLOCKS_PER_BLOCK_Z = 8;
    public static final int MAX_MICROBLOCK_MAPPINGS = 64;
    private IvBlockCollection blockCollection;
    private boolean[] isSideOpaque = new boolean[6];
    private boolean shouldDropAsItem = true;
    @SideOnly(value=Side.CLIENT)
    private GridQuadCache<IIcon> quadCache;

    public TileEntityMicroBlock() {
        this.blockCollection = new IvBlockCollection(8, 8, 8);
    }

    public boolean canUpdate() {
        return false;
    }

    public IvBlockCollection getBlockCollection() {
        return this.blockCollection;
    }

    public void setBlockCollection(IvBlockCollection blockCollection) {
        this.blockCollection = blockCollection;
    }

    public boolean isSideOpaque(ForgeDirection direction) {
        return this.isSideOpaque[direction.ordinal()];
    }

    public boolean areAllSidesOpaque() {
        return this.isSideOpaque[0] && this.isSideOpaque[1] && this.isSideOpaque[2] && this.isSideOpaque[3] && this.isSideOpaque[4] && this.isSideOpaque[5];
    }

    public void markCacheInvalid() {
        this.markCacheInvalid(false);
    }

    private void markCacheInvalid(boolean fromNBT) {
        int[] sizeX = new int[]{1, this.blockCollection.height, this.blockCollection.length};
        int[] sizeY = new int[]{this.blockCollection.width, 1, this.blockCollection.length};
        int[] sizeZ = new int[]{this.blockCollection.width, this.blockCollection.height, 1};
        BlockCoord zeroCoord = new BlockCoord(0, 0, 0);
        this.isSideOpaque[ForgeDirection.DOWN.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)zeroCoord, (int[])sizeY));
        this.isSideOpaque[ForgeDirection.UP.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)new BlockCoord(0, this.blockCollection.height - 1, 0), (int[])sizeY));
        this.isSideOpaque[ForgeDirection.NORTH.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)zeroCoord, (int[])sizeZ));
        this.isSideOpaque[ForgeDirection.EAST.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)new BlockCoord(this.blockCollection.width - 1, 0, 0), (int[])sizeX));
        this.isSideOpaque[ForgeDirection.SOUTH.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)new BlockCoord(0, 0, this.blockCollection.length - 1), (int[])sizeZ));
        this.isSideOpaque[ForgeDirection.WEST.ordinal()] = this.areAllOpaque(BlockArea.areaFromSize((BlockCoord)zeroCoord, (int[])sizeX));
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K) {
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"microBlocks", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
            } else {
                this.markCacheInvalidClient(fromNBT);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    private void markCacheInvalidClient(boolean fromNBT) {
        this.quadCache = null;
    }

    public boolean validateBeingMicroblock() {
        boolean allSame = true;
        Block curBlock = this.blockCollection.getBlock(new BlockCoord(0, 0, 0));
        byte curMeta = this.blockCollection.getMetadata(new BlockCoord(0, 0, 0));
        for (BlockCoord coord : this.blockCollection) {
            if (this.blockCollection.getBlock(coord) == curBlock && this.blockCollection.getMetadata(coord) == curMeta) continue;
            allSame = false;
            break;
        }
        if (allSame) {
            this.shouldDropAsItem = false;
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, curBlock, (int)curMeta, 3);
        } else if (this.blockCollection.getBlockMultiplicity() > 64) {
            BlockMicroBlock.dropAllMicroblockFragments(this, 1.0f);
        }
        return !allSame;
    }

    private boolean areAllOpaque(BlockArea area) {
        for (BlockCoord coord : area) {
            if (this.blockCollection.getBlock(coord).func_149662_c()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldDropAsItem() {
        return this.shouldDropAsItem;
    }

    public void setShouldDropAsItem(boolean shouldDropAsItem) {
        this.shouldDropAsItem = shouldDropAsItem;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeSyncToNBT(compound);
    }

    protected void writeSyncToNBT(NBTTagCompound compound) {
        compound.func_74782_a("microblocks", (NBTBase)this.blockCollection.createTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSyncFromNBT(compound);
    }

    protected void readSyncFromNBT(NBTTagCompound compound) {
        this.blockCollection = new IvBlockCollection(compound.func_74775_l("microblocks"), (MCRegistry)MCRegistryDefault.INSTANCE);
        this.markCacheInvalid(true);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeSyncToNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncFromNBT(pkt.func_148857_g());
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("microBlocks".equals(context)) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.blockCollection.createTagCompound());
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("microBlocks".equals(context)) {
            this.blockCollection = new IvBlockCollection(ByteBufUtils.readTag((ByteBuf)buffer), (MCRegistry)MCRegistryDefault.INSTANCE);
            this.markCacheInvalid(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GridQuadCache<IIcon> getQuadCache() {
        if (this.quadCache == null) {
            this.quadCache = IIconQuadCache.createIconQuadCache(this.blockCollection);
        }
        return this.quadCache;
    }
}

