/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.EnumPedestalEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityPedestal
extends IvTileEntityMultiBlock
implements IInventory,
PartialUpdateHandler {
    public int pedestalIdentifier;
    public int ticksAlive;
    public final ItemStack[] storedItems = new ItemStack[1];
    public int timeItemUp;
    public boolean itemShouldBeUp = false;

    public void updateEntityParent() {
        super.updateEntityParent();
        if (this.isParent()) {
            if (this.itemShouldBeUp && this.timeItemUp < this.getIntegrationTime()) {
                ++this.timeItemUp;
            } else if (!this.itemShouldBeUp && this.timeItemUp > 0) {
                --this.timeItemUp;
            } else if (!this.itemShouldBeUp && this.storedItems[0] != null) {
                this.dropItem();
            }
            if (this.timeItemUp > 0) {
                int cloudN;
                float fractionUp = this.getFractionItemUp();
                float cloudC = 0.0f;
                if (this.pedestalIdentifier == 3) {
                    cloudC = fractionUp * 0.2f;
                }
                if (this.pedestalIdentifier == 4) {
                    cloudC = fractionUp * 0.6f;
                }
                for (cloudN = 0; this.field_145850_b.field_73012_v.nextFloat() < cloudC && cloudN < 10; ++cloudN) {
                }
                for (int i = 0; i < cloudN; ++i) {
                    float xPlus = this.field_145850_b.field_73012_v.nextFloat() * 1.6f - 0.3f;
                    float yPlus = this.field_145850_b.field_73012_v.nextFloat() * this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float zPlus = this.field_145850_b.field_73012_v.nextFloat() * 1.6f - 0.3f;
                    this.field_145850_b.func_72869_a("cloud", (double)((float)this.field_145851_c + xPlus), (double)((float)this.field_145848_d + yPlus), (double)((float)this.field_145849_e + zPlus), 0.0, (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.01f + 0.01f), 0.0);
                }
            }
            ++this.ticksAlive;
        }
    }

    public boolean tryStoringItem(ItemStack stack) {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            return parent.tryStoringItem(stack);
        }
        if (this.isParent()) {
            if (this.storedItems[0] != null || stack == null) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.storedItems[0] = stack.func_77946_l();
                this.itemShouldBeUp = true;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean startDroppingItem(EntityPlayer player) {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            return parent.startDroppingItem(player);
        }
        if (this.isParent()) {
            if (this.storedItems[0] == null) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.itemShouldBeUp = false;
                if (player != null && this.getIntegrationTime() == 0) {
                    IvEntityHelper.addAsCurrentItem((EntityPlayer)player, (ItemStack)this.storedItems[0]);
                    this.storedItems[0] = null;
                }
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public void dropItem() {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            parent.dropItem();
        } else if (this.isParent() && this.storedItems[0] != null && !this.field_145850_b.field_72995_K) {
            EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.storedItems[0]);
            this.field_145850_b.func_72838_d((Entity)itemEntity);
            this.storedItems[0] = null;
            IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
            this.func_70296_d();
        }
    }

    public EnumPedestalEntry getPedestalEntry() {
        return EnumPedestalEntry.getEntry(this.pedestalIdentifier);
    }

    public int getIntegrationTime() {
        EnumPedestalEntry entry = this.getPedestalEntry();
        return entry != null ? entry.integrationTime : 0;
    }

    public float getFractionItemUp() {
        float fractionDone = (float)this.getIntegrationTime() > 0.0f ? (float)this.timeItemUp / (float)this.getIntegrationTime() : 1.0f;
        return fractionDone;
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        this.writePedestalDataToNBT(par1nbtTagCompound);
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.readPedestalDataFromNBT(par1nbtTagCompound);
    }

    public void writePedestalDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("pedestalIdentifier", this.pedestalIdentifier);
        tagCompound.func_74768_a("timeItemUp", this.timeItemUp);
        tagCompound.func_74757_a("itemShouldBeUp", this.itemShouldBeUp);
        if (this.storedItems[0] != null) {
            NBTTagCompound var4 = new NBTTagCompound();
            this.storedItems[0].func_77955_b(var4);
            tagCompound.func_74782_a("storedItem", (NBTBase)var4);
        }
    }

    public void readPedestalDataFromNBT(NBTTagCompound tagCompound) {
        this.pedestalIdentifier = tagCompound.func_74762_e("pedestalIdentifier");
        this.timeItemUp = tagCompound.func_74762_e("timeItemUp");
        this.itemShouldBeUp = tagCompound.func_74767_n("itemShouldBeUp");
        if (tagCompound.func_74764_b("storedItem")) {
            NBTTagCompound var4 = tagCompound.func_74775_l("storedItem");
            this.storedItems[0] = ItemStack.func_77949_a((NBTTagCompound)var4);
        } else {
            this.storedItems[0] = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        float[] extent = this.getPedestalEntry().visualExtent;
        if (extent != null) {
            double[] center = this.getActiveCenterCoords();
            return AxisAlignedBB.func_72330_a((double)(center[0] - (double)extent[0]), (double)(center[1] - (double)extent[1]), (double)(center[2] - (double)extent[2]), (double)(center[0] + (double)extent[0]), (double)(center[1] + (double)extent[1]), (double)(center[2] + (double)extent[2]));
        }
        return super.getRenderBoundingBox();
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("pedestalData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writePedestalDataToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("pedestalData".equals(context)) {
            this.readPedestalDataFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }

    public int func_70302_i_() {
        return this.storedItems.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.storedItems[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.storedItems[slot] != null) {
            if (this.storedItems[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.storedItems[slot];
                this.storedItems[slot] = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return itemstack;
            }
            ItemStack itemstack = this.storedItems[slot].func_77979_a(amount);
            if (this.storedItems[slot].field_77994_a == 0) {
                this.storedItems[slot] = null;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.storedItems[slot] != null) {
            ItemStack itemstack = this.storedItems[slot];
            this.storedItems[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.storedItems[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "container.ygcPedestal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

