/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.network.ClientEventHandler;
import ivorius.ivtoolkit.network.IvNetworkHelperClient;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.tools.IvSideClient;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.PlankSawRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import org.lwjgl.util.vector.Vector2f;

public class TileEntitySawBench
extends IvTileEntityMultiBlock
implements PartialUpdateHandler,
ClientEventHandler {
    public ItemStack containedItem;
    public static final int cutsPerLog = 4;
    public float sawPositionX;
    public float sawPositionY;
    public float woodCutY;
    public float woodCutScore;
    public int cutsLeft;
    public boolean isInWood;

    public boolean tryStoringItem(ItemStack stack, Entity entity) {
        if (stack != null && this.containedItem == null && PlankSawRegistry.canSawItem(stack)) {
            if (!this.field_145850_b.field_72995_K) {
                if (stack.field_77994_a >= 2) {
                    this.containedItem = stack.func_77946_l();
                    this.containedItem.field_77994_a = 2;
                    this.cutsLeft = 4;
                    this.woodCutScore = 0.0f;
                    this.woodCutY = 0.0f;
                    this.calculateIsInWood();
                    stack.field_77994_a -= 2;
                    this.func_70296_d();
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentTranslation("tile.ygcSawBench.morewood", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryEquippingItemOnPlayer(EntityPlayer entityLiving) {
        if (this.containedItem != null && this.cutsLeft == 4) {
            if (!this.field_145850_b.field_72995_K && IvEntityHelper.addAsCurrentItem((EntityPlayer)entityLiving, (ItemStack)this.containedItem)) {
                this.containedItem = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public void chopOffWood(float score, EntityPlayer player, int usedItemIndex) {
        --this.cutsLeft;
        this.woodCutScore = 0.0f;
        this.woodCutY = 0.0f;
        this.calculateIsInWood();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack usedItem = player.field_71071_by.func_70301_a(usedItemIndex);
            usedItem.func_77972_a(1, (EntityLivingBase)player);
            if (usedItem.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(usedItemIndex, null);
            }
            player.field_71071_by.func_70296_d();
            float finalScore = score * score * 0.7f + score * 0.3f;
            int planks = MathHelper.func_76141_d((float)(finalScore * 4.0f + 0.5f));
            if (planks > 0) {
                ItemStack planksStack = PlankSawRegistry.getSawResult(planks, this.containedItem);
                player.field_71071_by.func_70441_a(planksStack);
            }
            if (this.cutsLeft <= 0) {
                this.containedItem = null;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public float moveSaw(EntityPlayer player, float x, float y, int usedItemIndex) {
        if (this.containedItem != null && this.isInWood && y != 0.0f) {
            float safeY = Math.min(y, this.woodCutY - this.sawPositionY);
            float safeX = x / y * safeY;
            this.moveSawInConstraints(safeX, safeY);
            float leftX = x - safeX;
            float leftY = y - safeY;
            Vector2f movInWood = this.possibleMovement(leftX, leftY);
            float plusScore = 0.0f;
            if (movInWood.y > 0.0f) {
                float vecLength = MathHelper.func_76129_c((float)(movInWood.x * movInWood.x + movInWood.y * movInWood.y));
                float nX = movInWood.x / vecLength;
                float sideMov = Math.abs(nX);
                float sideMovInf = sideMov * sideMov;
                sideMovInf = sideMovInf * sideMovInf * sideMovInf;
                this.moveSawInConstraints(movInWood.x * 0.5f, movInWood.y * sideMovInf);
                plusScore = movInWood.y * sideMovInf * sideMovInf * sideMovInf;
                this.woodCutScore += plusScore;
                if (this.sawPositionY > this.woodCutY && this.isInWood) {
                    this.woodCutY = this.sawPositionY;
                }
            }
            if (this.field_145850_b.field_72995_K) {
                IvNetworkHelperClient.sendTileEntityEventPacket((TileEntity)this, (String)"sawMove", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
            }
            if (this.woodCutY >= 1.0f) {
                this.chopOffWood(this.woodCutScore, player, usedItemIndex);
                if (this.field_145850_b.field_72995_K) {
                    IvNetworkHelperClient.sendTileEntityEventPacket((TileEntity)this, (String)"woodChop", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[]{usedItemIndex});
                }
            }
            return plusScore;
        }
        this.moveSawInConstraints(x, y);
        if (this.containedItem != null && !this.isInWood) {
            this.calculateIsInWood();
        }
        if (this.field_145850_b.field_72995_K) {
            IvNetworkHelperClient.sendTileEntityEventPacket((TileEntity)this, (String)"sawMove", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
        }
        return 0.0f;
    }

    public Vector2f possibleMovement(float x, float y) {
        x = MathHelper.func_76131_a((float)(this.sawPositionX + x), (float)-0.3f, (float)0.3f);
        y = MathHelper.func_76131_a((float)(this.sawPositionY + y), (float)-0.2f, (float)1.2f);
        return new Vector2f(x - this.sawPositionX, y - this.sawPositionY);
    }

    public Vector2f moveSawInConstraints(float x, float y) {
        Vector2f possibleMovement = this.possibleMovement(x, y);
        this.sawPositionX += possibleMovement.x;
        this.sawPositionY += possibleMovement.y;
        return possibleMovement;
    }

    public void calculateIsInWood() {
        this.isInWood = this.sawPositionY <= 0.0f;
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.containedItem = ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("containedItem"));
        this.sawPositionX = par1nbtTagCompound.func_74760_g("sawPositionX");
        this.sawPositionY = par1nbtTagCompound.func_74760_g("sawPositionY");
        this.woodCutY = par1nbtTagCompound.func_74760_g("woodCutY");
        this.woodCutScore = par1nbtTagCompound.func_74760_g("woodCutScore");
        this.cutsLeft = par1nbtTagCompound.func_74762_e("cutsLeft");
        this.isInWood = par1nbtTagCompound.func_74767_n("isInWood");
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        if (this.containedItem != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.containedItem.func_77955_b(itemNBT);
            par1nbtTagCompound.func_74782_a("containedItem", (NBTBase)itemNBT);
        }
        par1nbtTagCompound.func_74776_a("sawPositionX", this.sawPositionX);
        par1nbtTagCompound.func_74776_a("sawPositionY", this.sawPositionY);
        par1nbtTagCompound.func_74776_a("woodCutY", this.woodCutY);
        par1nbtTagCompound.func_74776_a("woodCutScore", this.woodCutScore);
        par1nbtTagCompound.func_74768_a("cutsLeft", this.cutsLeft);
        par1nbtTagCompound.func_74757_a("isInWood", this.isInWood);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("sawOpenGui".equals(context)) {
            buffer.writeFloat(this.sawPositionX);
            buffer.writeFloat(this.sawPositionY);
            buffer.writeFloat(this.woodCutY);
            buffer.writeFloat(this.woodCutScore);
            buffer.writeBoolean(this.isInWood);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("sawOpenGui".equals(context)) {
            this.sawPositionX = buffer.readFloat();
            this.sawPositionY = buffer.readFloat();
            this.woodCutY = buffer.readFloat();
            this.woodCutScore = buffer.readFloat();
            this.isInWood = buffer.readBoolean();
            IvSideClient.getClientPlayer().openGui((Object)YeGamolChattels.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void assembleClientEvent(ByteBuf buffer, String context, Object ... params) {
        if ("sawMove".equals(context)) {
            buffer.writeFloat(this.sawPositionX);
            buffer.writeFloat(this.sawPositionY);
            buffer.writeFloat(this.woodCutY);
            buffer.writeFloat(this.woodCutScore);
            buffer.writeBoolean(this.isInWood);
        } else if ("woodChop".equals(context)) {
            buffer.writeInt(((Integer)params[0]).intValue());
        }
    }

    public void onClientEvent(ByteBuf buffer, String context, EntityPlayerMP player) {
        if ("sawMove".equals(context)) {
            this.sawPositionX = buffer.readFloat();
            this.sawPositionY = buffer.readFloat();
            this.woodCutY = buffer.readFloat();
            this.woodCutScore = buffer.readFloat();
            this.isInWood = buffer.readBoolean();
        } else if ("woodChop".equals(context)) {
            int itemIndex = buffer.readInt();
            if (this.woodCutY >= 1.0f && this.isInWood && this.containedItem != null) {
                this.chopOffWood(this.woodCutScore, (EntityPlayer)player, itemIndex);
            }
        }
    }
}

