/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.client.rendering.SnowGlobeCallListHandler;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntitySnowGlobe
extends TileEntity
implements PartialUpdateHandler {
    public boolean needsVisualUpdate = true;
    private int timeUntilVisualUpdate = 100;
    public boolean isRealityGlobe = false;
    public float realityGlobeRatio;
    @SideOnly(value=Side.CLIENT)
    private int glCallListIndex;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.timeUntilVisualUpdate <= 0 && !this.displaysDefaultHouse()) {
                this.timeUntilVisualUpdate = 100;
                this.needsVisualUpdate = true;
            } else if (!this.displaysDefaultHouse()) {
                --this.timeUntilVisualUpdate;
            }
            boolean didDisplayDefaultHouse = this.displaysDefaultHouse();
            this.progressInRGState();
            if (this.displaysDefaultHouse() != didDisplayDefaultHouse) {
                this.needsVisualUpdate = true;
            }
        } else {
            this.progressInRGState();
        }
    }

    private void progressInRGState() {
        this.realityGlobeRatio = IvMathHelper.nearValue((float)this.realityGlobeRatio, (float)(this.isRealityGlobe ? 1.0f : 0.0f), (float)0.0f, (float)0.005f);
    }

    public boolean useItem(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151061_bv) {
            if (!this.field_145850_b.field_72995_K) {
                --stack.field_77994_a;
                this.isRealityGlobe = !this.isRealityGlobe;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"snowGlobeData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isRealityGlobe", this.isRealityGlobe);
        nbt.func_74776_a("realityGlobePercent", this.realityGlobeRatio);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isRealityGlobe = nbt.func_74767_n("isRealityGlobe");
        this.realityGlobeRatio = nbt.func_74760_g("realityGlobePercent");
    }

    public boolean displaysDefaultHouse() {
        return (double)this.realityGlobeRatio < 0.5;
    }

    public float getObfuscationAlpha() {
        return (0.5f - Math.abs(this.realityGlobeRatio - 0.5f)) * 2.0f;
    }

    public float getRumbling() {
        return (0.3f - Math.abs(this.realityGlobeRatio - 0.5f)) * 0.1f;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        return IvTileEntityHelper.getStandardDescriptionPacket((TileEntity)this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 0.1, 0.0);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("snowGlobeData".equals(context)) {
            buffer.writeBoolean(this.isRealityGlobe);
            buffer.writeFloat(this.realityGlobeRatio);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("snowGlobeData".equals(context)) {
            boolean didDisplayDefaultHouse = this.displaysDefaultHouse();
            this.isRealityGlobe = buffer.readBoolean();
            this.realityGlobeRatio = buffer.readFloat();
            if (this.displaysDefaultHouse() != didDisplayDefaultHouse) {
                this.needsVisualUpdate = true;
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 || pass == 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.addCallListForDestruction();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getGlCallListIndex() {
        return this.glCallListIndex;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGlCallListIndex(int glCallListIndex) {
        this.addCallListForDestruction();
        this.glCallListIndex = glCallListIndex;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCallListForDestruction() {
        if (this.glCallListIndex > 0) {
            SnowGlobeCallListHandler.addCallListToDestroy(this.glCallListIndex);
            this.glCallListIndex = 0;
        }
    }
}

