/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YGCConfig;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.achievements.YGCAchievementList;
import ivorius.yegamolchattels.blocks.Statue;
import ivorius.yegamolchattels.client.rendering.TextureAllocationHandler;
import ivorius.yegamolchattels.entities.EntityFakePlayer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TileEntityStatue
extends IvTileEntityMultiBlock
implements PartialUpdateHandler {
    private NBTTagCompound storedStatueTag;
    private Statue statue;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation statueTexture;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation usedEntityTexture;

    public Statue getStatue() {
        return this.statue;
    }

    public void setStatue(Statue statue) {
        this.statue = statue;
    }

    public void statueDataChanged() {
        IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"statueData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
        this.func_70296_d();
    }

    public void setStatueRotationYaw(float rotation) {
        Entity statueEntity = this.statue.getEntity();
        statueEntity.field_70177_z = rotation;
        statueEntity.field_70126_B = rotation;
        if (statueEntity instanceof EntityLivingBase) {
            ((EntityLivingBase)statueEntity).field_70761_aq = rotation;
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.storedStatueTag != null) {
            this.createStatueFromNBT(this.storedStatueTag);
            this.storedStatueTag = null;
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean letStatueComeAlive() {
        Entity statueEntity = this.statue.getEntity();
        if (statueEntity != null && YGCConfig.areLifeStatuesAllowed && !(statueEntity instanceof EntityFakePlayer) && YGCConfig.mayEntityStatueComeAlive(statueEntity)) {
            if (!this.field_145850_b.field_72995_K) {
                EntityPlayer player;
                double[] center = this.getActiveCenterCoords();
                statueEntity.func_70107_b(center[0], center[1] - this.centerCoordsSize[1], center[2]);
                this.statue.updateEntityRotations();
                Statue.BlockFragment statueBlock = this.statue.getMaterial();
                int indefiniteTime = 9999999;
                if (statueBlock.getBlock().func_149688_o() == Material.field_151576_e) {
                    ((EntityLiving)statueEntity).func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, indefiniteTime, 0, true));
                    ((EntityLiving)statueEntity).func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, indefiniteTime, 0, true));
                } else if (statueBlock.getBlock().func_149688_o() == Material.field_151573_f) {
                    ((EntityLiving)statueEntity).func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, indefiniteTime, 0, true));
                }
                if ("Zombie".equals(EntityList.func_75621_b((Entity)statueEntity)) && (player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 10.0)) != null) {
                    player.func_71029_a((StatBase)YGCAchievementList.zombieStatueReanimated);
                }
                this.field_145850_b.func_72838_d(statueEntity);
            }
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStatueDataToNBT(par1NBTTagCompound);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.readStatueDataFromNBT(par1NBTTagCompound);
    }

    public void writeStatueDataToNBT(NBTTagCompound compound) {
        if (this.statue != null) {
            compound.func_74782_a("statue", (NBTBase)this.statue.createTagCompound());
            compound.func_74776_a("statueRotationYaw", this.statue.getEntity().field_70177_z);
        }
    }

    public void readStatueDataFromNBT(NBTTagCompound compound) {
        if (this.field_145850_b != null) {
            this.createStatueFromNBT(compound);
        } else {
            this.storedStatueTag = compound;
        }
    }

    private void createStatueFromNBT(NBTTagCompound compound) {
        this.statue = compound.func_74764_b("statue") ? new Statue(compound.func_74775_l("statue"), this.field_145850_b) : (this.isParent() ? new Statue((Entity)new EntityPig(this.field_145850_b), new Statue.BlockFragment(Blocks.field_150348_b, 0), 0.0f, 0.0f, 0.0f, 2.4f) : null);
        if (this.statue != null) {
            this.setStatueRotationYaw(compound.func_74760_g("statueRotationYaw"));
        }
    }

    public boolean isEntityEquippable() {
        return this.statue != null && YGCConfig.isEntityEquippable(this.statue.getEntity());
    }

    public boolean tryEquipping(ItemStack item) {
        if (item != null && this.statue != null && this.isEntityEquippable()) {
            Entity statueEntity = this.statue.getEntity();
            int slot = EntityLiving.func_82159_b((ItemStack)item);
            if (slot >= 0 && statueEntity.func_70035_c()[slot] == null) {
                if (!this.field_145850_b.field_72995_K) {
                    statueEntity.func_70062_b(slot, item.func_77946_l());
                    item.field_77994_a = 0;
                    this.statueDataChanged();
                }
                return true;
            }
        }
        return false;
    }

    public void addEquipmentToInventory(EntityPlayer player) {
        if (this.statue != null) {
            Entity statueEntity = this.statue.getEntity();
            for (int i = 0; i < statueEntity.func_70035_c().length; ++i) {
                if (statueEntity.func_70035_c()[i] == null || !player.field_71071_by.func_70441_a(statueEntity.func_70035_c()[i])) continue;
                statueEntity.func_70035_c()[i] = null;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.statueDataChanged();
            }
        }
    }

    public void dropEquipment() {
        if (!this.field_145850_b.field_72995_K && this.statue != null) {
            Entity statueEntity = this.statue.getEntity();
            for (int i = 0; i < statueEntity.func_70035_c().length; ++i) {
                if (statueEntity.func_70035_c()[i] == null) continue;
                float var7 = 0.7f;
                double var8 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
                double var10 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.2 + 0.6;
                double var12 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
                EntityItem var14 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var8, (double)this.field_145848_d + var10, (double)this.field_145849_e + var12, statueEntity.func_70035_c()[i]);
                var14.field_145804_b = 10;
                this.field_145850_b.func_72838_d((Entity)var14);
                statueEntity.func_70035_c()[i] = null;
            }
            this.statueDataChanged();
        }
    }

    public double func_145833_n() {
        if (this.statue != null) {
            Entity statueEntity = this.statue.getEntity();
            double var3 = statueEntity.field_70121_D.func_72320_b();
            return (var3 *= 64.0 * statueEntity.field_70155_l) * var3;
        }
        return 0.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.statue != null) {
            Entity statueEntity = this.statue.getEntity();
            if (statueEntity.field_70158_ak) {
                return INFINITE_EXTENT_AABB;
            }
            return this.getBoxAroundCenter(statueEntity.field_70130_N / 2.0f, statueEntity.field_70131_O / 2.0f, statueEntity.field_70130_N / 2.0f);
        }
        return super.getRenderBoundingBox();
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("statueData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writeStatueDataToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("statueData".equals(context)) {
            this.readStatueDataFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.releaseTexture();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void releaseTexture() {
        if (this.statueTexture != null) {
            TextureAllocationHandler.releaseTexture(this.statueTexture);
            this.statueTexture = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getStatueTexture() {
        return this.statueTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void setStatueTexture(ResourceLocation statueTexture) {
        this.statueTexture = statueTexture;
    }

    public ResourceLocation getUsedEntityTexture() {
        return this.usedEntityTexture;
    }

    public void setUsedEntityTexture(ResourceLocation usedEntityTexture) {
        this.usedEntityTexture = usedEntityTexture;
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.statue != null) {
            return this.statue.getMaterial().getBlock().canRenderInPass(pass);
        }
        return false;
    }
}

