/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityRotatable;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.raytracing.IvRaytraceableObject;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.ivtoolkit.raytracing.IvRaytracerMC;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.achievements.YGCAchievementList;
import ivorius.yegamolchattels.items.YGCItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityWeaponRack
extends IvTileEntityRotatable
implements IInventory,
PartialUpdateHandler {
    public static final int weaponRackTypeFloor = 0;
    public static final int weaponRackTypeWall = 1;
    public ItemStack[] storedWeapons = new ItemStack[4];
    public float[] storedWeaponsSwinging = new float[4];
    public boolean[] effectsApplied = new boolean[6];

    public void func_145845_h() {
        super.func_145845_h();
        for (int i = 0; i < this.storedWeaponsSwinging.length; ++i) {
            if (!(this.storedWeaponsSwinging[i] < 1.0f)) continue;
            int n = i;
            this.storedWeaponsSwinging[n] = this.storedWeaponsSwinging[n] + 0.1f;
        }
    }

    public int getStoredWeaponSlots() {
        int type = this.func_145832_p() & 1;
        return type == 0 ? 4 : 2;
    }

    public int getWeaponRackType() {
        return this.func_145832_p() & 1;
    }

    public boolean tryStoringItem(ItemStack stack, Entity entity) {
        int slot;
        if (stack != null && (slot = this.getHoveredSlot(entity)) >= 0 && this.func_94041_b(slot, stack) && this.func_70301_a(slot) == null) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70299_a(slot, stack.func_77946_l());
                this.storedWeaponsSwinging[slot] = 0.0f;
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean tryApplyingEffect(ItemStack stack, Entity entity) {
        int slot;
        if (stack != null && (slot = this.getEffectToBeApplied(stack)) >= 0 && !this.effectsApplied[slot]) {
            if (!this.field_145850_b.field_72995_K) {
                this.effectsApplied[slot] = true;
                --stack.field_77994_a;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71029_a((StatBase)YGCAchievementList.weaponRackVariant);
                }
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"weaponRackData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public int getEffectToBeApplied(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            if (itemBlock.field_150939_a == Blocks.field_150338_P || itemBlock.field_150939_a == Blocks.field_150337_Q) {
                return 0;
            }
            if (itemBlock.field_150939_a == Blocks.field_150321_G) {
                return 3;
            }
        }
        if (item == Items.field_151100_aR && stack.func_77960_j() == 15) {
            return 1;
        }
        if (item == Items.field_151116_aA) {
            return 2;
        }
        if (item == Items.field_151145_ak) {
            return 4;
        }
        if (item == Items.field_151118_aC) {
            return 5;
        }
        return -1;
    }

    public int getHoveredSlot(Entity entity) {
        String info;
        List<IvRaytraceableObject> raytraceables = this.getRaytraceableObjects();
        IvRaytracedIntersection intersection = IvRaytracerMC.getFirstIntersection(raytraceables, (Entity)entity);
        if (intersection != null && (info = (String)intersection.getUserInfo()).startsWith("Slot")) {
            return Integer.valueOf(info.substring(4));
        }
        return -1;
    }

    public List<IvRaytraceableObject> getRaytraceableObjects() {
        ArrayList<IvRaytraceableObject> raytraceables = new ArrayList<IvRaytraceableObject>();
        if (this.getWeaponRackType() == 0) {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot0", -0.45, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot1", -0.225, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot2", 0.0, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot3", 0.225, -0.3, -0.3, 0.225, 0.7, 0.6));
        } else {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot0", -0.5, 0.0, 0.1, 1.0, 0.5, 0.4));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot1", -0.5, -0.5, 0.1, 1.0, 0.5, 0.4));
        }
        return raytraceables;
    }

    public boolean tryDroppingWeapon(int slot) {
        if (this.storedWeapons[slot] != null) {
            if (!this.field_145850_b.field_72995_K) {
                float shiftDist = 0.7f;
                double xShift = (double)(this.field_145850_b.field_73012_v.nextFloat() * shiftDist) + (double)(1.0f - shiftDist) * 0.5;
                double yShift = (double)this.field_145850_b.field_73012_v.nextFloat() * 0.2 + 1.1;
                double zShift = (double)(this.field_145850_b.field_73012_v.nextFloat() * shiftDist) + (double)(1.0f - shiftDist) * 0.5;
                EntityItem var14 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + xShift, (double)this.field_145848_d + yShift, (double)this.field_145849_e + zShift, this.storedWeapons[slot]);
                var14.field_145804_b = 10;
                this.field_145850_b.func_72838_d((Entity)var14);
                this.storedWeapons[slot] = null;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"weaponRackData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean pickUpItem(EntityPlayer player) {
        ItemStack stack;
        int slot = this.getHoveredSlot((Entity)player);
        if (slot >= 0 && (stack = this.func_70301_a(slot)) != null) {
            if (!this.field_145850_b.field_72995_K && player.field_71071_by.func_70441_a(stack)) {
                this.func_70299_a(slot, null);
                player.field_71070_bA.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public void dropAllWeapons() {
        for (int i = 0; i < this.storedWeapons.length; ++i) {
            this.tryDroppingWeapon(i);
        }
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.readWeaponRackDataFromNBT(par1nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        this.writeWeaponRackDataToNBT(par1nbtTagCompound);
    }

    public void readWeaponRackDataFromNBT(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c("Items", 10);
        this.storedWeapons = new ItemStack[this.storedWeapons.length];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound var4 = items.func_150305_b(i);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.storedWeapons.length) continue;
            this.storedWeapons[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            this.storedWeaponsSwinging[var5] = var4.func_74760_g("Swinging");
        }
        NBTTagList effects = compound.func_150295_c("Effects", 10);
        for (int i = 0; i < effects.func_74745_c(); ++i) {
            NBTTagCompound var4 = effects.func_150305_b(i);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            this.effectsApplied[var5] = var4.func_74767_n("Applied");
        }
    }

    public void writeWeaponRackDataToNBT(NBTTagCompound compound) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.storedWeapons.length; ++i) {
            if (this.storedWeapons[i] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            var4.func_74776_a("Swinging", (float)((byte)this.storedWeaponsSwinging[i]));
            this.storedWeapons[i].func_77955_b(var4);
            items.func_74742_a((NBTBase)var4);
        }
        compound.func_74782_a("Items", (NBTBase)items);
        NBTTagList effects = new NBTTagList();
        for (int i = 0; i < this.effectsApplied.length; ++i) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            var4.func_74757_a("Applied", this.effectsApplied[i]);
            effects.func_74742_a((NBTBase)var4);
        }
        compound.func_74782_a("Effects", (NBTBase)effects);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.5));
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("weaponRackData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writeWeaponRackDataToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("weaponRackData".equals(context)) {
            this.readWeaponRackDataFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }

    public int func_70302_i_() {
        return this.storedWeapons.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.storedWeapons[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.storedWeapons[slot] != null) {
            if (this.storedWeapons[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.storedWeapons[slot];
                this.storedWeapons[slot] = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return itemstack;
            }
            ItemStack itemstack = this.storedWeapons[slot].func_77979_a(amount);
            if (this.storedWeapons[slot].field_77994_a == 0) {
                this.storedWeapons[slot] = null;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.storedWeapons[slot] != null) {
            ItemStack itemstack = this.storedWeapons[slot];
            this.storedWeapons[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.storedWeapons[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "container.weaponRack";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemTool || item instanceof ItemSword || this.getWeaponRackType() == 0 && item instanceof ItemBow || item == YGCItems.mallet;
    }
}

