/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.entities.EntityBanner;
import ivorius.yegamolchattels.entities.EntityFlag;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderBanner
extends Render {
    public ResourceLocation textureBannerSmall = new ResourceLocation("yegamolchattels", YeGamolChattels.filePathTextures + "bannersSmall.png");
    public ResourceLocation textureBannerLarge = new ResourceLocation("yegamolchattels", YeGamolChattels.filePathTextures + "bannersLarge.png");

    public void doRenderBanner(EntityBanner entitybannersmall, double d, double d1, double d2, float f, float f1) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glRotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        this.func_110777_b((Entity)entitybannersmall);
        float f2 = 0.0625f;
        GL11.glScalef((float)f2, (float)f2, (float)f2);
        int bannerWidth = entitybannersmall.func_82329_d();
        int bannerHeight = entitybannersmall.func_82330_g();
        this.renderBanner(entitybannersmall, bannerWidth, bannerHeight, entitybannersmall.getColor() % 4 * bannerWidth, (entitybannersmall.getColor() >> 2) * bannerHeight, f1);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderBanner(EntityBanner entity, int bannerWidth, int bannerHeight, int texShiftX, int texShiftY, float t) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float ticks = (float)entity.field_70173_aa + t;
        float wind = EntityFlag.getInterpolatedWind(entity.wind, entity.simWind, t);
        double xShift = (float)(-bannerWidth) / 2.0f;
        double yShift = (float)(-bannerHeight) / 2.0f;
        double segWidth = 1.0;
        double segHeight = 1.0;
        tessellator.func_78382_b();
        for (int voxX = 0; voxX < bannerWidth; ++voxX) {
            for (int voxY = 0; voxY < bannerHeight; ++voxY) {
                double z1;
                double thickness;
                double d = thickness = this.field_76990_c.field_78733_k.field_74347_j ? (double)0.7f : 0.0;
                if (bannerHeight - voxY < 2 + bannerHeight / 16) {
                    thickness *= 2.0;
                }
                double zShift = -thickness * 0.5 + 0.5;
                double voxX1 = (double)voxX + 0.999;
                double voxY1 = (double)voxY + 0.999;
                double minX = xShift + (double)voxX * 1.0;
                double minY = yShift + (double)voxY * 1.0;
                double texMinX = ((double)(texShiftX + bannerWidth) - ((double)voxX + 0.001) * 1.0) / ((double)bannerWidth * 4.0);
                double texMaxX = ((double)(texShiftX + bannerWidth) - voxX1 * 1.0) / ((double)bannerWidth * 4.0);
                double texMinY = ((double)(texShiftY + bannerHeight) - ((double)voxY + 0.001) * 1.0) / ((double)bannerHeight * 4.0);
                double texMaxY = ((double)(texShiftY + bannerHeight) - voxY1 * 1.0) / ((double)bannerHeight * 4.0);
                double waveEffect = (float)(bannerHeight - voxY - 4) * 0.015f * wind;
                double waveEffect1 = ((double)bannerHeight - voxY1 - 4.0) * (double)0.015f * (double)wind;
                double z = waveEffect > 0.0 ? (double)MathHelper.func_76126_a((float)(((float)voxY * 0.04f + ticks * 0.06f) * (float)Math.PI)) * waveEffect : 0.0;
                double d2 = z1 = waveEffect1 > 0.0 ? (double)MathHelper.func_76126_a((float)(((float)voxY1 * 0.04f + ticks * 0.06f) * (float)Math.PI)) * waveEffect1 : 0.0;
                if (!this.field_76990_c.field_78733_k.field_74347_j) {
                    if (z > 0.3) {
                        z = 0.3;
                    }
                    if (z1 > 0.3) {
                        z1 = 0.3;
                    }
                }
                this.setLight(entity, (float)minX + 0.5f, (float)minY + 0.5f);
                RenderBanner.renderSegment(minX, minY, zShift + z, zShift + z1, segWidth, segHeight, thickness, texMinX, texMinY, texMaxX, texMaxY);
            }
        }
        tessellator.func_78381_a();
    }

    private void setLight(EntityHanging entity, float par2, float par3) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(entity.field_70163_u + (double)(par3 / 16.0f)));
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        switch (entity.field_82332_a) {
            case 2: {
                i = MathHelper.func_76128_c((double)(entity.field_70165_t + (double)(par2 / 16.0f)));
                break;
            }
            case 1: {
                k = MathHelper.func_76128_c((double)(entity.field_70161_v - (double)(par2 / 16.0f)));
                break;
            }
            case 0: {
                i = MathHelper.func_76128_c((double)(entity.field_70165_t - (double)(par2 / 16.0f)));
                break;
            }
            case 3: {
                k = MathHelper.func_76128_c((double)(entity.field_70161_v + (double)(par2 / 16.0f)));
            }
        }
        int l = this.field_76990_c.field_78722_g.func_72802_i(i, j, k, 0);
        int i1 = l % 65536;
        int j1 = l / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i1, (float)j1);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.doRenderBanner((EntityBanner)entity, d, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        EntityBanner banner;
        if (entity instanceof EntityBanner && (banner = (EntityBanner)entity).getSize() == 2) {
            return this.textureBannerLarge;
        }
        return this.textureBannerSmall;
    }

    public static void renderSegment(double x, double y, double z, double z1, double sizeX, double sizeY, double sizeZ, double texX, double texY, double texX1, double texY1) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int zShift = -1;
        tessellator.func_78375_b(0.0f, 0.0f, (float)zShift);
        tessellator.func_78374_a(x + sizeX, y, z + (double)zShift * sizeZ, texX1, texY);
        tessellator.func_78374_a(x, y, z + (double)zShift * sizeZ, texX, texY);
        tessellator.func_78374_a(x, y + sizeY, z1 + (double)zShift * sizeZ, texX, texY1);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z1 + (double)zShift * sizeZ, texX1, texY1);
        zShift = 1;
        tessellator.func_78375_b(0.0f, 0.0f, (float)zShift);
        tessellator.func_78374_a(x, y + sizeY, z1 + (double)zShift * sizeZ, texX, texY1);
        tessellator.func_78374_a(x, y, z + (double)zShift * sizeZ, texX, texY);
        tessellator.func_78374_a(x + sizeX, y, z + (double)zShift * sizeZ, texX1, texY);
        tessellator.func_78374_a(x + sizeX, y + sizeY, z1 + (double)zShift * sizeZ, texX1, texY1);
        if (sizeZ > 0.0) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            tessellator.func_78374_a(x + sizeX, y + sizeY, z1 - sizeZ, texX1, texY);
            tessellator.func_78374_a(x, y + sizeY, z1 - sizeZ, texX, texY);
            tessellator.func_78374_a(x, y + sizeY, z1 + sizeZ, texX, texY1);
            tessellator.func_78374_a(x + sizeX, y + sizeY, z1 + sizeZ, texX1, texY1);
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            tessellator.func_78374_a(x, y, z + sizeZ, texX, texY1);
            tessellator.func_78374_a(x, y, z - sizeZ, texX, texY);
            tessellator.func_78374_a(x + sizeX, y, z - sizeZ, texX1, texY);
            tessellator.func_78374_a(x + sizeX, y, z + sizeZ, texX1, texY1);
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            tessellator.func_78374_a(x, y + sizeY, z1 + sizeZ, texX1, texY1);
            tessellator.func_78374_a(x, y + sizeY, z1 - sizeZ, texX, texY1);
            tessellator.func_78374_a(x, y, z - sizeZ, texX, texY);
            tessellator.func_78374_a(x, y, z + sizeZ, texX1, texY);
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            tessellator.func_78374_a(x + sizeX, y, z - sizeZ, texX, texY);
            tessellator.func_78374_a(x + sizeX, y + sizeY, z1 - sizeZ, texX, texY1);
            tessellator.func_78374_a(x + sizeX, y + sizeY, z1 + sizeZ, texX1, texY1);
            tessellator.func_78374_a(x + sizeX, y, z + sizeZ, texX1, texY);
        }
    }
}

