/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.yegamolchattels.blocks.BlockMicroBlock;
import ivorius.yegamolchattels.blocks.TileEntityMicroBlock;
import ivorius.yegamolchattels.client.rendering.GridQuadCache;
import java.nio.FloatBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderMicroBlock
implements ISimpleBlockRenderingHandler {
    private int renderID;

    public RenderMicroBlock(int renderID) {
        this.renderID = renderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150348_b, (int)0);
        GL11.glTranslatef((float)2.0f, (float)0.0f, (float)0.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150348_b, (int)0);
        GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150348_b, (int)0);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150348_b, (int)0);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150344_f, (int)0);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.0f);
        IvRenderHelper.renderCubeInvBlock((RenderBlocks)renderer, (Block)Blocks.field_150344_f, (int)0);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntityMicroBlock tileEntityMicroBlock = (TileEntityMicroBlock)world.func_147438_o(x, y, z);
        IvBlockCollection blockCollection = tileEntityMicroBlock.getBlockCollection();
        int brightness = block.func_149677_c(renderer.field_147845_a, x, y, z);
        RenderMicroBlock.renderMicroblocks(world, new BlockCoord(x, y, z), tileEntityMicroBlock.getQuadCache(), (BlockMicroBlock)block, renderer, brightness);
        return true;
    }

    public static void renderMicroblocks(IBlockAccess world, BlockCoord pos, GridQuadCache<IIcon> quadCache, BlockMicroBlock origBlock, RenderBlocks renderer, int innerBrightness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        tessellator.func_78380_c(innerBrightness);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        renderer.field_152631_f = true;
        for (GridQuadCache.CachedQuadLevel<IIcon> cachedQuadLevel : quadCache) {
            origBlock.renderSide = cachedQuadLevel.direction;
            origBlock.renderIcon = (IIcon)cachedQuadLevel.t;
            FloatBuffer quads = cachedQuadLevel.quads;
            while (quads.position() < quads.limit() - 3) {
                float minX = quads.get();
                float minY = quads.get();
                float maxX = quads.get();
                float maxY = quads.get();
                float[] minAxes = GridQuadCache.getNormalAxes(cachedQuadLevel.direction, cachedQuadLevel.zLevel, minX, minY);
                float[] maxAxes = GridQuadCache.getNormalAxes(cachedQuadLevel.direction, cachedQuadLevel.zLevel, maxX, maxY);
                origBlock.func_149676_a(minAxes[0], minAxes[1], minAxes[2], maxAxes[0], maxAxes[1], maxAxes[2]);
                renderer.func_147775_a((Block)origBlock);
                renderer.func_147784_q((Block)origBlock, x, y, z);
            }
            quads.position(0);
        }
        renderer.field_152631_f = false;
        origBlock.func_149719_a(world, x, y, z);
        origBlock.renderSide = null;
        origBlock.renderIcon = null;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }
}

