/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import ivorius.ivtoolkit.blocks.IvMultiBlockRenderHelper;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.logic.IvObjects;
import ivorius.ivtoolkit.rendering.textures.IvTextureCreatorMC;
import ivorius.ivtoolkit.rendering.textures.IvTexturePatternColorizer;
import ivorius.ivtoolkit.rendering.textures.ModifiedTexture;
import ivorius.ivtoolkit.rendering.textures.PreBufferedTexture;
import ivorius.yegamolchattels.YGCConfig;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.Statue;
import ivorius.yegamolchattels.blocks.TileEntityStatue;
import ivorius.yegamolchattels.client.rendering.EntityBlockTextureMerger;
import ivorius.yegamolchattels.client.rendering.RenderEngineOverride;
import ivorius.yegamolchattels.client.rendering.TextureAllocationHandler;
import java.awt.image.BufferedImage;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererStatue
extends TileEntitySpecialRenderer {
    public RenderEngineOverride renderEngineOverride = new RenderEngineOverride();
    public ResourceLocation statueFallbackTexture = new ResourceLocation("yegamolchattels", YeGamolChattels.filePathTextures + "statueFallbackTexture.png");

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.renderTileEntityStatueAt((TileEntityStatue)tileentity, d, d1, d2, f);
    }

    public void renderTileEntityStatueAt(TileEntityStatue tileEntityStatue, double x, double y, double z, float partialTicks) {
        if (tileEntityStatue.isParent()) {
            ResourceLocation entityResourceLocation;
            int renderPass = MinecraftForgeClient.getRenderPass();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(-tileEntityStatue.centerCoordsSize[1]), (double)0.0);
            IvMultiBlockRenderHelper.transformFor((IvTileEntityMultiBlock)tileEntityStatue, (double)x, (double)y, (double)z);
            Entity entity = tileEntityStatue.getStatue().getEntity();
            entity.func_70029_a(tileEntityStatue.func_145831_w());
            int statusBarLength = BossStatus.field_82826_b;
            ResourceLocation resourceLocation = entityResourceLocation = YGCConfig.doStatueTextureMerge ? EntityBlockTextureMerger.getTexture(entity) : null;
            if (!IvObjects.equals((Object)entityResourceLocation, (Object)tileEntityStatue.getUsedEntityTexture())) {
                tileEntityStatue.releaseTexture();
                tileEntityStatue.setUsedEntityTexture(null);
            }
            if (tileEntityStatue.getStatueTexture() != null) {
                this.renderEngineOverride.textureOverride = tileEntityStatue.getStatueTexture();
            } else {
                ResourceLocation colorizedTexture = this.createTexture(tileEntityStatue, entityResourceLocation);
                tileEntityStatue.setUsedEntityTexture(entityResourceLocation);
                if (colorizedTexture != null) {
                    tileEntityStatue.setStatueTexture(colorizedTexture);
                    TextureAllocationHandler.retainTexture(colorizedTexture);
                    this.renderEngineOverride.textureOverride = colorizedTexture;
                } else {
                    this.renderEngineOverride.textureOverride = this.statueFallbackTexture;
                }
            }
            this.renderEngineOverride.renderEngine = RenderManager.field_78727_a.field_78724_e;
            RenderManager.field_78727_a.field_78724_e = this.renderEngineOverride;
            if (renderPass > 0) {
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            try {
                tileEntityStatue.getStatue().updateEntityRotations();
                GL11.glRotatef((float)(180.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                RenderManager.field_78727_a.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            catch (Exception ex) {
                YeGamolChattels.logger.warn("Exception on rendering statue!", (Throwable)ex);
            }
            if (renderPass > 0) {
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)3042);
            }
            RenderManager.field_78727_a.field_78724_e = this.renderEngineOverride.renderEngine;
            BossStatus.field_82826_b = statusBarLength;
            GL11.glPopMatrix();
        }
    }

    public ResourceLocation createTexture(TileEntityStatue tileEntityStatue, ResourceLocation entityResourceLocation) {
        Statue.BlockFragment fragment;
        BufferedImage patternImage;
        if (YGCConfig.fetchDynamicStatueTextures && (patternImage = EntityBlockTextureMerger.getTexture((fragment = tileEntityStatue.getStatue().getMaterial()).getBlock(), fragment.getMetadata())) != null) {
            TextureManager texManager = Minecraft.func_71410_x().func_110434_K();
            if (entityResourceLocation != null) {
                ITextureObject entityResourceTexture = texManager.func_110581_b(entityResourceLocation);
                if (!TileEntityRendererStatue.isTextureFinal(entityResourceTexture)) {
                    return null;
                }
                ResourceLocation textureColorized = new ResourceLocation("yegamolchattels", "colorized/" + entityResourceLocation + "_" + Block.field_149771_c.func_148750_c((Object)fragment.getBlock()) + "_" + fragment.getMetadata());
                if (texManager.func_110581_b(textureColorized) == null) {
                    ModifiedTexture modifiedTexture = new ModifiedTexture(entityResourceLocation, (IvTextureCreatorMC.LoadingImageEffect)new IvTexturePatternColorizer(patternImage, YeGamolChattels.logger), YeGamolChattels.logger);
                    if (texManager.func_110579_a(textureColorized, (ITextureObject)modifiedTexture)) {
                        return textureColorized;
                    }
                    return null;
                }
                return textureColorized;
            }
            ResourceLocation patternResource = new ResourceLocation("yegamolchattels", "blockextract/" + Block.field_149771_c.func_148750_c((Object)fragment.getBlock()) + "_" + fragment.getMetadata());
            if (texManager.func_110581_b(patternResource) == null) {
                texManager.func_110579_a(patternResource, (ITextureObject)new PreBufferedTexture(patternImage));
            }
            return patternResource;
        }
        return null;
    }

    public static boolean isTextureFinal(ITextureObject resourceLocation) {
        return true;
    }
}

