/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.entities;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityFakePlayer
extends EntityMob {
    private GameProfile playerProfile;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationCape;
    @SideOnly(value=Side.CLIENT)
    private CallbackHandler callbackHandler;

    public EntityFakePlayer(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
    }

    public EntityFakePlayer(World par1World, GameProfile playerProfile) {
        super(par1World);
        this.playerProfile = playerProfile;
        if (this.field_70170_p.field_72995_K) {
            this.setupCustomSkin();
        }
    }

    public String getPlayerUsername() {
        return this.playerProfile != null ? this.playerProfile.getName() : null;
    }

    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.playerProfile != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbttagcompound1, (GameProfile)this.playerProfile);
            tagCompound.func_74782_a("PlayerProfile", (NBTBase)nbttagcompound1);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        if (tagCompound.func_150297_b("PlayerProfile", 10)) {
            this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("PlayerProfile"));
        }
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.setupCustomSkin();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @SideOnly(value=Side.CLIENT)
    private void setupCustomSkin() {
        String s = this.getPlayerUsername();
        if (s != null && !s.isEmpty()) {
            SkinManager skinmanager = Minecraft.func_71410_x().func_152342_ad();
            skinmanager.func_152790_a(this.playerProfile, (SkinManager.SkinAvailableCallback)this.callbackHandler, true);
        }
    }

    public static GameProfile createGameProfile(String playerUsername) {
        GameProfile gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(playerUsername);
        if (gameprofile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
            if (property == null) {
                gameprofile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameprofile, true);
            }
            return gameprofile;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        return this.locationSkin != null ? this.locationSkin : AbstractClientPlayer.field_110314_b;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationCape() {
        return this.locationCape;
    }

    @SideOnly(value=Side.CLIENT)
    public static class CallbackHandler
    implements SkinManager.SkinAvailableCallback {
        private EntityFakePlayer player;

        public CallbackHandler(EntityFakePlayer player) {
            this.player = player;
        }

        public void func_152121_a(MinecraftProfileTexture.Type type, ResourceLocation resourceLocation) {
            switch (type) {
                case CAPE: {
                    this.player.locationCape = resourceLocation;
                }
                case SKIN: {
                    this.player.locationSkin = resourceLocation;
                }
            }
        }
    }
}

