/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.yegamolchattels.YGCConfig;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.achievements.YGCAchievementList;
import ivorius.yegamolchattels.blocks.TileEntitySnowGlobe;
import ivorius.yegamolchattels.blocks.TileEntityStatue;
import ivorius.yegamolchattels.client.rendering.EntityBlockTextureMerger;
import ivorius.yegamolchattels.entities.EntityGhost;
import ivorius.yegamolchattels.items.ItemChisel;
import ivorius.yegamolchattels.items.ItemClubHammer;
import ivorius.yegamolchattels.items.ItemEntityVita;
import ivorius.yegamolchattels.items.MicroblockSelector;
import ivorius.yegamolchattels.items.YGCItems;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class YGCForgeEventHandler {
    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.unloadAllGLObjects(event.world.field_147482_g);
        }
    }

    @SubscribeEvent
    public void unloadChunk(ChunkEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.unloadAllGLObjects(event.getChunk().field_150816_i.values());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void unloadAllGLObjects(Collection tileEntities) {
        for (Object tileEntity : tileEntities) {
            if (tileEntity instanceof TileEntitySnowGlobe) {
                ((TileEntitySnowGlobe)((Object)tileEntity)).addCallListForDestruction();
                continue;
            }
            if (!(tileEntity instanceof TileEntityStatue)) continue;
            ((TileEntityStatue)((Object)tileEntity)).releaseTexture();
        }
    }

    @SubscribeEvent
    public void blockHarvested(BlockEvent.HarvestDropsEvent event) {
        ItemStack equipped;
        if (event.harvester != null && (equipped = event.harvester.func_71045_bC()) != null && equipped.func_77973_b() instanceof ItemClubHammer) {
            ((ItemClubHammer)equipped.func_77973_b()).modifyDrops(event.world, event.block, event.blockMetadata, equipped, event.x, event.y, event.z, event.drops);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity sourceEntity;
        if (event.entityLiving instanceof EntityGhost && (sourceEntity = event.source.func_76346_g()) instanceof EntityPlayer) {
            ((EntityPlayer)sourceEntity).func_71029_a((StatBase)YGCAchievementList.ghostKilled);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (ItemEntityVita.canClassBeValidVita(event.entityLiving.getClass()) && event.entityLiving.func_70681_au().nextDouble() < YGCConfig.entityVitaDropChance) {
            ItemStack vitaStack = ItemEntityVita.createVitaItemStackAsNewbornEntity(YGCItems.entityVita, (Entity)event.entityLiving);
            if (vitaStack != null) {
                event.drops.add(new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, vitaStack));
            } else {
                YeGamolChattels.logger.warn("Could not create vita item stack for " + event.entityLiving);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        MicroblockSelector selector;
        ItemStack heldItem;
        EntityLivingBase renderEntity = Minecraft.func_71410_x().field_71451_h;
        if (renderEntity != null && (heldItem = renderEntity.func_70694_bm()) != null && heldItem.func_77973_b() instanceof MicroblockSelector && (selector = (MicroblockSelector)heldItem.func_77973_b()).showMicroblockSelection(renderEntity, heldItem)) {
            YGCForgeEventHandler.renderSelectedMicroblock((Entity)renderEntity, event.partialTicks, selector.microblockSelectionSize(heldItem));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderSelectedMicroblock(Entity entity, float partialTicks, float size) {
        ItemChisel.MicroBlockFragment hoveredFragment;
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase renderEntity = mc.field_71451_h;
        MovingObjectPosition hoveredObject = mc.field_71476_x;
        if (hoveredObject != null && (hoveredFragment = ItemChisel.getHoveredFragment(entity, hoveredObject.field_72311_b, hoveredObject.field_72312_c, hoveredObject.field_72309_d)) != null) {
            double viewerPosX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)partialTicks;
            double viewerPosY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)partialTicks;
            double viewerPosZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)hoveredFragment.getCoord().x - viewerPosX), (double)((double)hoveredFragment.getCoord().y - viewerPosY), (double)((double)hoveredFragment.getCoord().z - viewerPosZ));
            GL11.glTranslated((double)(((float)hoveredFragment.getInternalCoord().x + 0.5f) / 8.0f), (double)(((float)hoveredFragment.getInternalCoord().y + 0.5f) / 8.0f), (double)(((float)hoveredFragment.getInternalCoord().z + 0.5f) / 8.0f));
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glLineWidth((float)1.0f);
            IvRenderHelper.drawCuboid((Tessellator)Tessellator.field_78398_a, (float)(size / 8.0f), (float)(size / 8.0f), (float)(size / 8.0f), (float)1.0f, (boolean)true);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitch(TextureStitchEvent event) {
        if (event instanceof TextureStitchEvent.Pre) {
            EntityBlockTextureMerger.clearCachedStitchedTexture();
        }
    }
}

