/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.items;

import ivorius.ivtoolkit.blocks.IvMultiBlockHelper;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.yegamolchattels.blocks.Statue;
import ivorius.yegamolchattels.blocks.TileEntityStatue;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemStatue
extends ItemBlock {
    public int statueMaterial;

    public ItemStatue(Block block, Integer material) {
        super(block);
        this.field_77777_bU = 1;
        this.statueMaterial = material;
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int x, int y, int z, int blockSide, float hitX, float hitY, float hitZ) {
        Statue statue = ItemStatue.createStatue(par1ItemStack, par3World);
        if (statue != null) {
            if (!par3World.field_72995_K) {
                int rotation = 0;
                IvMultiBlockHelper multiBlockHelper = new IvMultiBlockHelper();
                List<int[]> positions = ItemStatue.getStatuePositions(statue.getEntity(), rotation);
                if (multiBlockHelper.beginPlacing(positions, par3World, x, y, z, blockSide, par1ItemStack, par2EntityPlayer, this.field_150939_a, 0, rotation)) {
                    for (int[] position : multiBlockHelper) {
                        IvTileEntityMultiBlock tileEntity = multiBlockHelper.placeBlock(position);
                        if (!(tileEntity instanceof TileEntityStatue) || !tileEntity.isParent()) continue;
                        TileEntityStatue tileEntityStatue = (TileEntityStatue)tileEntity;
                        tileEntityStatue.setStatue(statue);
                        tileEntityStatue.setStatueRotationYaw((par2EntityPlayer.field_70177_z + 180.0f) % 360.0f);
                    }
                    --par1ItemStack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public static List<int[]> getStatuePositions(Entity entity, int rotation) {
        int statueWidth = MathHelper.func_76123_f((float)entity.field_70130_N);
        int statueHeight = MathHelper.func_76123_f((float)entity.field_70131_O);
        return IvMultiBlockHelper.getRotatedPositions((int)rotation, (int)statueWidth, (int)statueHeight, (int)statueWidth);
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String base = super.func_77667_c(par1ItemStack) + ".base";
        String entityName = ItemStatue.getStatueEntityID(par1ItemStack);
        String localizedEntityName = entityName != null && entityName.length() > 0 ? I18n.func_135052_a((String)("entity." + entityName + ".name"), (Object[])new Object[0]) : I18n.func_135052_a((String)"tile.ygcStatue.unknown", (Object[])new Object[0]);
        Statue.BlockFragment blockFragment = ItemStatue.getStatueBlockFragment(par1ItemStack);
        String localizedBlockName = blockFragment != null ? new ItemStack(blockFragment.getBlock(), 1, blockFragment.getMetadata()).func_82833_r() : I18n.func_135052_a((String)"tile.ygcStatue.nomaterial", (Object[])new Object[0]);
        return I18n.func_135052_a((String)base, (Object[])new Object[]{localizedEntityName, localizedBlockName});
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
    }

    public static Statue createStatue(ItemStack stack, World world) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("statue")) {
            return new Statue(stack.func_77978_p().func_74775_l("statue"), world);
        }
        return null;
    }

    public static void setStatue(ItemStack stack, Statue statue) {
        stack.func_77983_a("statue", (NBTBase)statue.createTagCompound());
    }

    public static Statue.BlockFragment getStatueBlockFragment(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("statue")) {
            return Statue.getMaterial(stack.func_77978_p().func_74775_l("statue"));
        }
        return null;
    }

    public static String getStatueEntityID(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("statue")) {
            return Statue.getEntityID(stack.func_77978_p().func_74775_l("statue"));
        }
        return null;
    }
}

