(function($){
	var mask = $('.mask');
	$.dialog = {
		okBtn: '确定',
		cancelBtn: '取消',
		open: function(o){
			if(!mask.length) mask = $('<div>').addClass('mask').appendTo('body');
			
			$.dialog._setDialogPosition(o,mask);
			
			mask.show();
			o.fadeIn(300).find(':button:first').focus();
			
			var select = $('select:visible').css('visibility','hidden');
			$.dialog.selectCache = select;
		},
		close: function(o,isReset){
			o.fadeOut(100,function(){
				if(isReset){
					o.remove();
					o = null;
					$.dialog.okBtn = '确定';
					$.dialog.cancelBtn = '取消';
				}
			});
			mask.hide();
			if($.dialog.selectCache != null){
				$.dialog.selectCache.css('visibility','visible');
				$.dialog.selectCache = null;
			}
		},
		alert: function(tit,msg,callback,isClose){
			if(isClose == undefined){
				isClose = true;
			}
			var alert = $.dialog._createDialog(tit,msg,callback,'alert',isClose).addClass('dialog-alert');
			$.dialog.open(alert);
			return alert;
		},
		confirm: function(tit,msg,callback,isClose){
			if(isClose == undefined){
				isClose = true;
			}
			var confirm = $.dialog._createDialog(tit,msg,callback,'confirm',isClose).addClass('dialog-confirm');
			$.dialog.open(confirm);
			return confirm;
		},
		
		_createDialog: function(tit,msg,callback,type,isClose){
			var dialog = $('<div>').addClass('dialog'),
				head = $('<h3>').addClass('d-tit').text(tit),
				body = $('<div>').addClass('d-cnt').html(msg),
				foot = $('<div>').addClass('d-btn-bar'),
				btn = null,
				btn2 = null;
			
			if($.dialog.okBtn != ''){
				btn = $('<input type="button">').val($.dialog.okBtn).addClass('d-btn').addClass('d-btn-ok');
				foot.append(btn);
				
				btn.bind('click',function(){
					if(isClose){
						$.dialog.close(dialog,true);
					}
					if(callback){
						callback();
					}
				});
			}
			
			if(type == 'confirm'){
				btn2 = $('<input type="button">').val($.dialog.cancelBtn).addClass('d-btn').addClass('d-btn-cancel');
				btn2.bind('click',function(){
					$.dialog.close(dialog,true);
				});
				btn2.appendTo(foot);
			}
			
			dialog.append(head).append(body).append(foot).appendTo('body');
			
			return dialog;
		},
		
		_setDialogPosition: function(dialog,mask){
			var dialogWidth = dialog.width(),
				dialogHeight = dialog.height(),
				win = $(window),
				winWidth = win.width(),
				winHeight = win.height(),
				scrollTop = win.scrollTop();
			dialog.css({
				left: ( winWidth - dialogWidth ) / 2,
				top: ( winHeight - dialogHeight ) / 2 + scrollTop
			});
			mask.css({
				width: winWidth,
				height: $(document).height()
			});
		}
	};
	
	$(window).resize(function(){
		var mask = $('.mask');
		if(mask.length && mask.is(':visible')){
			$.dialog._setDialogPosition($('.dialog:visible'),mask);
		}
	});

})(jQuery);