<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes">
	<xsl:output method="xml" version="1.0" encoding="GBK" indent="yes"/>
	<xsl:template match="/">
		<taxXml>
			<sbb>
				<head>
					<publicHead>
						<nsrsbh>
							<xsl:value-of select="/body/val[@x='qyxx'][@y='nsrsbh']"/>
						</nsrsbh>
						<nsrmc>
							<xsl:value-of select="/body/val[@x='qyxx'][@y='nsrmc']"/>
						</nsrmc>
						<tbrq>
							<xsl:value-of select="/body/bbmx/val[@x='HL_YGZFX_0003'][@y='tbrq']"/>
						</tbrq>
						<sssq>
							<rqQ>
								<xsl:value-of select="/body/bbmx/val[@x='HL_YGZFX_0003'][@y='sbrq1']"/>
							</rqQ>
							<rqZ>
								<xsl:value-of select="/body/bbmx/val[@x='HL_YGZFX_0003'][@y='sbrq2']"/>
							</rqZ>
						</sssq>
					</publicHead>
				</head>
				<body>
					<mainInfoRow>
						<nsrsbh>
							<xsl:value-of select="/body/val[@x='qyxx'][@y='nsrsbh']"/>
						</nsrsbh>
						<nsrmc>
							<xsl:value-of select="/body/val[@x='qyxx'][@y='nsrmc']"/>
						</nsrmc>
						<rzzlfs>
							<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='C5']"/>
						</rzzlfs>
						<!--融资租赁方式-->
						<nsrlx>
                            <xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='C6']"/>    						
						</nsrlx>
						<!--纳税人类型-->
						<tbr>
							<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='C23']"/>
						</tbr>
						<!--填表人-->
						<shr>
							<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='C24']"/>
						</shr>
						<!--审核人-->
						<lxdh>
							<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E23']"/>
						</lxdh>
						<!--联系电话-->
						<xm>
							<zlsr_hj>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E8']"/>
							</zlsr_hj>
							<!--应缴增值税融资租赁收入合计-->
							<zlsr_bj>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E9']"/>
							</zlsr_bj>
							<!--本金-->
							<zlsr_lxsr>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E10']"/>
							</zlsr_lxsr>
							<!--利息收入-->
							<zlsr_qtfr>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E11']"/>
							</zlsr_qtfr>
							<!--其他费用-->
							<zlzc_hj>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E12']"/>
							</zlzc_hj>
							<!--应缴增值税融资租赁支出合计-->
							<zlzc_sjkcje>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E13']"/>
							</zlzc_sjkcje>
							<!--扣除项目本期实际扣除金额-->
							<zlzc_qdzyfpje>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E14']"/>
							</zlzc_qdzyfpje>
							<!--取得专用发票金额-->
							<zlzc_jxse>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E15']"/>
							</zlzc_jxse>
							<!--进项税额-->
							<jnyyqk_zlyye>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E17']"/>
							</jnyyqk_zlyye>
							<!--本期仍在地税申报营业税的融资租赁营业额-->
							<jnyyqk_ynyye>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E18']"/>
							</jnyyqk_ynyye>
							<!--本期仍在地税申报营业税应纳营业税额-->
							<zzszyfpqk_fpfs>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E20']"/>
							</zzszyfpqk_fpfs>
							<!--开具增值税专用发票份数-->
							<zzszyfpqk_fpxsebhs>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E21']"/>
							</zzszyfpqk_fpxsebhs>
							<!--开具增值税专用发票销售额(不含税)-->
							<zzszyfpqk_fpxxse>
								<xsl:value-of select="body/bbmx/col/val[@x='HL_YGZFX_0003'][@y='E22']"/>
							</zzszyfpqk_fpxxse>
							<!--开具增值税专用发票销项税额-->
						</xm>
					</mainInfoRow>
				</body>
			</sbb>
			<headAffix>
				<sbfsDm>32</sbfsDm>
				<sbrq>
					<xsl:value-of select="/body/val[@x='qyxx'][@y='sbrq']"/>
				</sbrq>
				<version>
					<xsl:value-of select="/body/val[@x='qyxx'][@y='version']"/>
				</version>
				<clientVersion>
					<xsl:value-of select="/body/val[@x='qyxx'][@y='clientversion']"/>
				</clientVersion>
			</headAffix>
		</taxXml>
	</xsl:template>
</xsl:stylesheet>
