/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import rafradek.TF2weapons.CommonProxy;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.characters.EntityTF2Character;
import rafradek.TF2weapons.characters.RenderTF2Character;
import rafradek.TF2weapons.message.TF2ActionHandler;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.message.TF2UseHandler;
import rafradek.TF2weapons.weapons.EntityBulletTracer;
import rafradek.TF2weapons.weapons.ItemUsable;
import rafradek.TF2weapons.weapons.MinigunLoopSound;
import rafradek.TF2weapons.weapons.MinigunSound;

public class ClientProxy
extends CommonProxy {
    public static TextureMap particleMap;
    public static KeyBinding reload;
    public static ResourceLocation scopeTexture;
    public static BiMap<EntityLivingBase, MinigunSound> fireSounds;
    public static Map<EntityLivingBase, ISound> reloadSounds;
    public static ResourceLocation blackTexture;
    public static ResourceLocation chargeTexture;

    @Override
    public void registerRenderInformation() {
        reloadSounds = new HashMap<EntityLivingBase, ISound>();
        fireSounds = HashBiMap.create();
        ClientRegistry.registerKeyBinding((KeyBinding)reload);
        RenderingRegistry.registerEntityRenderingHandler(EntityTF2Character.class, (Render)new RenderTF2Character());
        TF2weapons.network.registerMessage(TF2ActionHandler.TF2ActionHandlerReturn.class, TF2Message.ActionMessage.class, 1, Side.CLIENT);
        TF2weapons.network.registerMessage(TF2UseHandler.class, TF2Message.UseMessage.class, 2, Side.CLIENT);
    }

    @Override
    public void registerTicks() {
    }

    public static void spawnBulletParticle(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int j) {
        EntityBulletTracer entity = new EntityBulletTracer(world, startX, startY, startZ, endX, endY, endZ, j);
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71451_h != null && Minecraft.func_71410_x().field_71452_i != null) {
            int i = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
            if (i == 1 && entity.field_70170_p.field_73012_v.nextInt(3) == 0) {
                i = 2;
            }
            if (i > 1) {
                entity.func_70106_y();
                return;
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entity);
        }
    }

    @Override
    public void playReloadSound(EntityLivingBase player, ItemStack stack) {
        ResourceLocation soundName = new ResourceLocation(ItemUsable.getData(stack).get("Reload Sound").getString());
        PositionedSoundRecord sound = new PositionedSoundRecord(soundName, 0.6f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        Minecraft.func_71410_x().func_147118_V().func_147683_b(reloadSounds.get(player));
        reloadSounds.put(player, (ISound)sound);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    public static void playMinigunSound(EntityLivingBase living, ResourceLocation playSound, boolean loop, int type, ItemStack stack) {
        MinigunSound sound = loop ? new MinigunLoopSound(playSound, living, type < 2, ItemUsable.getData(stack), type == 1, type) : new MinigunSound(playSound, living, type, ItemUsable.getData(stack));
        if (fireSounds.get((Object)living) != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)fireSounds.get((Object)living));
            ((MinigunSound)((Object)fireSounds.get((Object)living))).setDone();
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        fireSounds.put((Object)living, (Object)sound);
    }

    public static void removeReloadSound(EntityLivingBase entity) {
        if (reloadSounds.get(entity) != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(reloadSounds.remove(entity));
        }
    }

    static {
        reload = new KeyBinding("key.reload", 19, "lol");
        scopeTexture = new ResourceLocation("tf2weapons:textures/misc/scope.png");
        blackTexture = new ResourceLocation("tf2weapons:textures/misc/black.png");
        chargeTexture = new ResourceLocation("tf2weapons:textures/misc/charge.png");
    }
}

